/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.rocci;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.rocci.types.json.JSONResources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class RocciClient {
    private String cmd_line = "";
    private String attributes = "";

    public RocciClient(List<String> cmd_string, String attr) {
        for (String s : cmd_string) {
            this.cmd_line = this.cmd_line + s + " ";
        }
        this.attributes = attr;
    }

    public String describe_resource(String resource_id) throws ConnectorException {
        String res_desc = "";
        String cmd = this.cmd_line + "--action describe" + " --resource " + resource_id;
        try {
            res_desc = this.execute_cmd(cmd);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return res_desc;
    }

    public String get_resource_status(String resource_id) throws ConnectorException {
        String res_status = null;
        String jsonOutput = this.describe_resource(resource_id);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        jsonOutput = "{\"resources\":" + jsonOutput + "}";
        JSONResources obj = (JSONResources)gson.fromJson(jsonOutput, JSONResources.class);
        res_status = obj.getResources().get(0).getAttributes().getOcci().getCompute().getState();
        return res_status;
    }

    public String get_resource_address(String resource_id) throws ConnectorException {
        String res_ip = null;
        String jsonOutput = this.describe_resource(resource_id);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        jsonOutput = "{\"resources\":" + jsonOutput + "}";
        JSONResources obj = (JSONResources)gson.fromJson(jsonOutput, JSONResources.class);
        for (int i = 0; i < obj.getResources().get(0).getLinks().size(); ++i) {
            if (obj.getResources().get(0).getLinks().get(i).getAttributes().getOcci().getNetworkinterface() == null) continue;
            res_ip = obj.getResources().get(0).getLinks().get(i).getAttributes().getOcci().getNetworkinterface().getAddress();
            break;
        }
        return res_ip;
    }

    public void delete_compute(String resource_id) {
        String cmd = this.cmd_line + "--action delete" + " --resource " + resource_id;
        try {
            this.execute_cmd(cmd);
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String create_compute(String os_tpl, String resource_tpl) {
        String s = "";
        String cmd = this.cmd_line + " --action create" + " --resource compute -M os_tpl#" + os_tpl + " -M resource_tpl#" + resource_tpl + " --attribute occi.core.title=\"" + this.attributes + "\"";
        try {
            s = this.execute_cmd(cmd);
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return s;
    }

    private String execute_cmd(String cmd_args) throws ConnectorException, InterruptedException {
        String return_string = "";
        String buff = null;
        String[] cmd_line = new String[]{"/bin/bash", "-c", "occi " + cmd_args};
        try {
            Process p = Runtime.getRuntime().exec(cmd_line);
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new ConnectorException("Error executing command: \n occi " + cmd_args);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((buff = is.readLine()) != null) {
                return_string = return_string + buff;
            }
            return return_string;
        }
        catch (IOException e) {
            throw new ConnectorException((Exception)e);
        }
    }
}

