/*
 *  Copyright 2002-2015 Barcelona Supercomputing Center (www.bsc.es)
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef GS_TEMPLATES_H
#define GS_TEMPLATES_H

// Uncomment the following define to get debug information.
//#define DEBUG_BINDING

#ifdef DEBUG_BINDING
	#define debug_printf(args...) printf(args)
#else
	#define debug_printf(args...) {}
#endif

#include <stdio.h>
#include <stdlib.h>

#include <GS_compss.h>
#include <param_metadata.h>

#ifndef COMPSS_WORKER

#include <fstream>
#include <iostream>
#include <map>
#include <string>
#include <string.h>
#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>

using namespace std;
using namespace boost;

struct Entry {
	 datatype type;
	 char *classname;
	 char *filename;
};
extern map<void *, Entry> objectMap;

#endif /* COMPSS_WORKER */

int GS_register(void *ref, datatype type, direction dir, char *classname, char * &filename);
void GS_clean();
void compss_on(void);
void compss_off(void);
template <class T> void compss_wait_on(T &obj);
template <> inline void compss_wait_on<char *>(char * &obj);

#ifndef COMPSS_WORKER

template <class T>
void compss_wait_on(T &obj) {
	 Entry entry = objectMap[&obj];
	 char *runtime_filename;

	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Entry.type: %d\n", entry.type);
	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Entry.classname: %s\n", entry.classname);
	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Entry.filename: %s\n", entry.filename);

	 GS_Get_File(entry.filename, 0, &runtime_filename);

	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Runtime filename: %s\n", runtime_filename);

	 ifstream ifs(runtime_filename);
	 archive::text_iarchive ia(ifs);
   	 ia >> obj;
   	 ifs.close();

   	 // No longer needed, the current version of the object is in memory now
   	 remove(entry.filename);
   	 remove(runtime_filename);
   	 objectMap.erase(&obj);
}

template <>
void compss_wait_on<char *>(char * &obj) {
     string in_string;

	 Entry entry = objectMap[&obj];
	 char *runtime_filename;

	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Entry.type: %d\n", entry.type);
	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Entry.classname: %s\n", entry.classname);
	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Entry.filename: %s\n", entry.filename);

	 GS_Get_File(entry.filename, 0, &runtime_filename);

	 debug_printf("[   BINDING]  -  @compss_wait_on  -  Runtime filename: %s\n", runtime_filename);

	 if ((datatype)entry.type != file_dt) {
		 debug_printf("[   BINDING]  -  @compss_wait_on  -  Object deserialization from %s\n", runtime_filename);

		 ifstream ifs(runtime_filename);
		 archive::text_iarchive ia(ifs);
		 ia >> in_string;
		 ifs.close();

		 obj = strdup(in_string.c_str());

		 // No longer needed, the current version of the object is in memory now
		 remove(entry.filename);
		 //remove(runtime_filename);

	 }	else {
		 // Update file contents
		 debug_printf("[   BINDING]  -  @compss_wait_on  -  File renaming: %s to %s\n", runtime_filename, entry.filename);
		 remove(entry.filename);
		 //rename(runtime_filename, entry.filename);
		 symlink(runtime_filename, entry.filename);
	 }
	 // No longer needed, synchronization done
	 objectMap.erase(&obj);
}

#else

template <class T> void compss_wait_on(T &obj) { }
template <> void compss_wait_on<char *>(char * &obj) { }

#endif /* COMPSS_WORKER */

#endif /* GS_TEMPLATES */
