/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.vmm;

import integratedtoolkit.connectors.AbstractSSHConnector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.vmm.VMDescription;
import integratedtoolkit.connectors.vmm.VMMClient;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.util.HashMap;

public class VMMConnector
extends AbstractSSHConnector {
    private static final String ENDPOINT_PROP = "Server";
    private static final String ACTIVE = "ACTIVE";
    private static final String ERROR = "ERROR";
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;
    private VMMClient client;

    public VMMConnector(String providerName, HashMap<String, String> props) {
        super(providerName, props);
        this.client = new VMMClient(props.get(ENDPOINT_PROP));
    }

    public void destroy(Object vm) throws ConnectorException {
        String vmId = (String)vm;
        try {
            this.client.deleteVM(vmId);
        }
        catch (Exception e) {
            logger.error((Object)"Exception waiting for VM Creation");
            throw new ConnectorException(e);
        }
    }

    public Object create(String name, CloudMethodResourceDescription requested) throws ConnectorException {
        try {
            logger.debug((Object)("Image password:" + (String)requested.getImage().getProperties().get("Password")));
            String id = this.client.createVM(name, requested.getImage().getName(), requested.getProcessorCoreCount(), (int)(requested.getMemoryPhysicalSize() * 1000.0f), (int)requested.getStorageElemSize(), System.getProperty("it.appName"));
            logger.debug((Object)("Machine " + id + " created"));
            return id;
        }
        catch (Exception e) {
            logger.error((Object)"Exception submitting vm creation", (Throwable)e);
            throw new ConnectorException(e);
        }
    }

    public CloudMethodResourceDescription waitUntilCreation(Object vm, CloudMethodResourceDescription requested) throws ConnectorException {
        CloudMethodResourceDescription granted = new CloudMethodResourceDescription();
        String vmId = (String)vm;
        try {
            VMDescription vmd = this.client.getVMDescription(vmId);
            logger.info((Object)("VM State is " + vmd.getState()));
            int tries = 0;
            while (vmd.getState() == null || !vmd.getState().equals(ACTIVE)) {
                if (vmd.getState().equals(ERROR)) {
                    logger.error((Object)"Error waiting for VM Creation. Middleware has return an error state");
                    throw new ConnectorException("Error waiting for VM Creation. Middleware has return an error state");
                }
                if ((long)tries * 5L > 1800L) {
                    throw new ConnectorException("Maximum VM creation time reached.");
                }
                ++tries;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                vmd = this.client.getVMDescription(vmId);
            }
            granted.setName(vmd.getIpAddress());
            granted.setType(requested.getType());
            granted.setProcessorCPUCount(requested.getProcessorCPUCount());
            granted.setProcessorCoreCount(vmd.getCpus());
            granted.setProcessorArchitecture(requested.getProcessorArchitecture());
            granted.setProcessorSpeed(requested.getProcessorSpeed());
            granted.setMemoryPhysicalSize(requested.getMemoryPhysicalSize());
            granted.setMemoryAccessTime(requested.getMemoryAccessTime());
            granted.setMemorySTR(requested.getMemorySTR());
            granted.setMemoryVirtualSize(requested.getMemoryVirtualSize());
            granted.setStorageElemSize((float)vmd.getDiskGb());
            granted.setStorageElemAccessTime(requested.getStorageElemAccessTime());
            granted.setStorageElemSTR(requested.getStorageElemSTR());
            granted.setOperatingSystemType("Linux");
            granted.setSlots(requested.getSlots());
            granted.getAppSoftware().addAll(requested.getAppSoftware());
            granted.setImage(requested.getImage());
            granted.setValue(requested.getValue().floatValue());
            granted.setValue(this.getMachineCostPerTimeSlot(granted));
            return granted;
        }
        catch (Exception e) {
            logger.error((Object)"Exception waiting for VM Creation");
            throw new ConnectorException(e);
        }
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription rd) {
        return rd.getValue().floatValue();
    }

    public long getTimeSlot() {
        return 0L;
    }

    protected void close() {
    }
}

