/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import benchmarks.AdaptorTestResult;
import benchmarks.AdaptorTestResultEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.monitoring.MetricEvent;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;

public class ResourceBrokerAdaptorTest
implements MetricListener {
    private boolean jobFinished;

    public static void main(String[] args) {
        ResourceBrokerAdaptorTest a = new ResourceBrokerAdaptorTest();
        a.test(args[0], args[1]).print();
        GAT.end();
    }

    public AdaptorTestResult test(String adaptor, String host) {
        try {
            URI temp = new URI(host);
            if (temp.getScheme() == null && !host.equals("")) {
                host = "any://" + host;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        AdaptorTestResult adaptorTestResult = new AdaptorTestResult(adaptor, host);
        GATContext gatContext = new GATContext();
        Preferences preferences = new Preferences();
        preferences.put("resourcebroker.adaptor.name", (Object)adaptor);
        this.jobFinished = false;
        adaptorTestResult.put("submit job easy  ", this.submitJobEasy(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("submit job parallel", this.submitJobParallel(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("submit job stdout", this.submitJobStdout(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("submit job stderr", this.submitJobStderr(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("submit job prestage", this.submitJobPreStage(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("submit job poststage", this.submitJobPostStage(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("submit job environment", this.submitJobEnvironment(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("job state consistency", this.submitJobStateConsistency(gatContext, preferences, host));
        this.jobFinished = false;
        adaptorTestResult.put("job get info        ", this.submitJobGetInfo(gatContext, preferences, host));
        this.jobFinished = false;
        return adaptorTestResult;
    }

    private synchronized void waitForJob() {
        while (!this.jobFinished) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {}
        }
    }

    private AdaptorTestResultEntry submitJobEasy(GATContext gatContext, Preferences preferences, String host) {
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/echo");
        sd.setArguments(new String[]{"test", "1", "2", "3"});
        HashMap attributes = new HashMap();
        sd.setAttributes(attributes);
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(true, stop - start, null);
    }

    private AdaptorTestResultEntry submitJobParallel(GATContext gatContext, Preferences preferences, String host) {
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/echo");
        sd.setArguments(new String[]{"test", "1", "2", "3"});
        try {
            sd.setStdout(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"parallel-stdout"));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        JobDescription jd = new JobDescription(sd);
        jd.setProcessCount(2);
        jd.setResourceCount(1);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(true, stop - start, null);
    }

    private AdaptorTestResultEntry submitJobStdout(GATContext gatContext, Preferences preferences, String host) {
        String result;
        Job job;
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/echo");
        sd.setArguments(new String[]{"test", "1", "2", "'*"});
        try {
            sd.setStdout(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"stdout"));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            job = broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        try {
            Map info = job.getInfo();
            Throwable ex = (Throwable)info.get("poststage.exception");
            if (ex != null) {
                return new AdaptorTestResultEntry(false, 0L, ex);
            }
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("stdout")));
            result = reader.readLine();
            reader.close();
        }
        catch (Exception e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        return new AdaptorTestResultEntry("test 1 2 '*".equals(result), stop - start, null);
    }

    private AdaptorTestResultEntry submitJobStderr(GATContext gatContext, Preferences preferences, String host) {
        String result;
        Job job;
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/ls");
        sd.setArguments(new String[]{"floep"});
        try {
            sd.setStderr(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"stderr"));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            job = broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        try {
            Map info = job.getInfo();
            Throwable ex = (Throwable)info.get("poststage.exception");
            if (ex != null) {
                return new AdaptorTestResultEntry(false, 0L, ex);
            }
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("stderr")));
            result = reader.readLine();
            reader.close();
        }
        catch (Exception e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        return new AdaptorTestResultEntry(result != null && result.endsWith("floep: No such file or directory"), stop - start, null);
    }

    private AdaptorTestResultEntry submitJobPreStage(GATContext gatContext, Preferences preferences, String host) {
        String result;
        Job job;
        ResourceBroker broker;
        File tmp;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/ls");
        sd.setArguments(new String[]{"floep"});
        File floep = new File("floep");
        if (!floep.exists()) {
            try {
                floep.createNewFile();
            }
            catch (IOException e) {
                return new AdaptorTestResultEntry(false, 0L, e);
            }
            floep.deleteOnExit();
        }
        if (!(tmp = new File("tmp")).exists()) {
            tmp.mkdir();
            tmp.deleteOnExit();
        }
        try {
            sd.addPreStagedFile(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"floep"));
            sd.addPreStagedFile(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"tmp"));
            sd.setStdout(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"stdout"));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            job = broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        try {
            Map info = job.getInfo();
            Throwable ex = (Throwable)info.get("poststage.exception");
            if (ex != null) {
                return new AdaptorTestResultEntry(false, 0L, ex);
            }
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("stdout")));
            result = reader.readLine();
            reader.close();
        }
        catch (Exception e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        return new AdaptorTestResultEntry(result != null, stop - start, null);
    }

    private AdaptorTestResultEntry submitJobPostStage(GATContext gatContext, Preferences preferences, String host) {
        Job job;
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/touch");
        sd.setArguments(new String[]{"flap.txt"});
        try {
            sd.addPostStagedFile(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"flap.txt"));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            job = broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        try {
            Map info = job.getInfo();
            Throwable ex = (Throwable)info.get("poststage.exception");
            if (ex != null) {
                return new AdaptorTestResultEntry(false, 0L, ex);
            }
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(new File("flap.txt").exists(), stop - start, null);
    }

    private AdaptorTestResultEntry submitJobEnvironment(GATContext gatContext, Preferences preferences, String host) {
        Job job;
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JAVAGAT_TEST_KEY", "javagat-test-value");
        sd.setEnvironment(env);
        sd.setExecutable("/usr/bin/env");
        try {
            sd.setStdout(GAT.createFile((GATContext)gatContext, (Preferences)preferences, (String)"stdout"));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long start = System.currentTimeMillis();
        try {
            job = broker.submitJob((AbstractJobDescription)jd, (MetricListener)this, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        try {
            Map info = job.getInfo();
            Throwable ex = (Throwable)info.get("poststage.exception");
            if (ex != null) {
                return new AdaptorTestResultEntry(false, 0L, ex);
            }
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        boolean success = false;
        try {
            String result;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("stdout")));
            while ((result = reader.readLine()) != null) {
                if (!result.contains("JAVAGAT_TEST_KEY") || !result.contains("javagat-test-value")) continue;
                success = true;
            }
            reader.close();
        }
        catch (Exception e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        return new AdaptorTestResultEntry(success, stop - start, null);
    }

    private AdaptorTestResultEntry submitJobStateConsistency(GATContext gatContext, Preferences preferences, String host) {
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/sleep");
        sd.setArguments(new String[]{"2"});
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        JobStateMetricListener listener = new JobStateMetricListener(this);
        long start = System.currentTimeMillis();
        try {
            broker.submitJob((AbstractJobDescription)jd, (MetricListener)listener, "job.status");
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        this.waitForJob();
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(listener.getException() == null, stop - start, listener.getException());
    }

    private AdaptorTestResultEntry submitJobGetInfo(GATContext gatContext, Preferences preferences, String host) {
        ResourceBroker broker;
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/sleep");
        sd.setArguments(new String[]{"2"});
        JobDescription jd = new JobDescription(sd);
        try {
            broker = GAT.createResourceBroker((GATContext)gatContext, (Preferences)preferences, (URI)new URI(host));
        }
        catch (GATObjectCreationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        catch (URISyntaxException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        Job job = null;
        Throwable exception = null;
        long start = System.currentTimeMillis();
        try {
            job = broker.submitJob((AbstractJobDescription)jd);
        }
        catch (GATInvocationException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        while (job.getState() != Job.JobState.STOPPED) {
            Map info = null;
            try {
                info = job.getInfo();
            }
            catch (GATInvocationException e) {
                exception = e;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {}
                continue;
            }
            if (info == null) {
                exception = new Exception("getInfo returns null");
            } else {
                if (!info.containsKey("state")) {
                    exception = new Exception("getInfo doesn't contain a key 'state'");
                }
                if (!info.containsKey("hostname")) {
                    exception = new Exception("getInfo doesn't contain a key 'hostname'");
                } else if (info.get("state").equals(Job.JobState.RUNNING) && info.get("hostname") == null) {
                    exception = new Exception("inconsistent getInfo: state=RUNNING, hostname=null");
                }
                if (!info.containsKey("submissiontime")) {
                    exception = new Exception("getInfo doesn't contain a key 'submissiontime'");
                }
                if (!info.containsKey("starttime")) {
                    exception = new Exception("getInfo doesn't contain a key 'starttime'");
                }
                if (!info.containsKey("stoptime")) {
                    exception = new Exception("getInfo doesn't contain a key 'stoptime'");
                }
                if (!info.containsKey("poststage.exception")) {
                    exception = new Exception("getInfo doesn't contain a key 'poststage.exception'");
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                exception = e;
            }
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(exception == null, stop - start, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMetricEvent(MetricEvent val) {
        if (val.getValue().equals(Job.JobState.STOPPED)) {
            ResourceBrokerAdaptorTest resourceBrokerAdaptorTest = this;
            synchronized (resourceBrokerAdaptorTest) {
                this.jobFinished = true;
                this.notifyAll();
            }
        }
    }

    class JobStateMetricListener
    implements MetricListener {
        private Job.JobState state = Job.JobState.INITIAL;
        private Exception e;
        ResourceBrokerAdaptorTest resourceBrokerAdaptorTest;

        public JobStateMetricListener(ResourceBrokerAdaptorTest resourceBrokerAdaptorTest2) {
            this.resourceBrokerAdaptorTest = resourceBrokerAdaptorTest2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMetricEvent(MetricEvent val) {
            Job.JobState newState = (Job.JobState)val.getValue();
            if (newState.equals((Object)Job.JobState.INITIAL) && !this.state.equals((Object)Job.JobState.INITIAL)) {
                this.e = new Exception(newState + " occurs after " + this.state + " but shouldn't");
            }
            if (newState.equals((Object)Job.JobState.PRE_STAGING) && (this.state.equals((Object)Job.JobState.SCHEDULED) || this.state.equals((Object)Job.JobState.POST_STAGING) || this.state.equals((Object)Job.JobState.RUNNING) || this.state.equals((Object)Job.JobState.STOPPED) || this.state.equals((Object)Job.JobState.SUBMISSION_ERROR))) {
                this.e = new Exception(newState + " occurs after " + this.state + " but shouldn't");
            }
            if (newState.equals((Object)Job.JobState.SCHEDULED) && (this.state.equals((Object)Job.JobState.POST_STAGING) || this.state.equals((Object)Job.JobState.RUNNING) || this.state.equals((Object)Job.JobState.STOPPED) || this.state.equals((Object)Job.JobState.SUBMISSION_ERROR))) {
                this.e = new Exception(newState + " occurs after " + this.state + " but shouldn't");
            }
            if (newState.equals((Object)Job.JobState.RUNNING) && (this.state.equals((Object)Job.JobState.POST_STAGING) || this.state.equals((Object)Job.JobState.STOPPED) || this.state.equals((Object)Job.JobState.SUBMISSION_ERROR))) {
                this.e = new Exception(newState + " occurs after " + this.state + " but shouldn't");
            }
            if (newState.equals((Object)Job.JobState.POST_STAGING) && (this.state.equals((Object)Job.JobState.STOPPED) || this.state.equals((Object)Job.JobState.SUBMISSION_ERROR))) {
                this.e = new Exception(newState + " occurs after " + this.state + " but shouldn't");
            }
            this.state = newState;
            if (this.state.equals((Object)Job.JobState.STOPPED)) {
                ResourceBrokerAdaptorTest resourceBrokerAdaptorTest = this.resourceBrokerAdaptorTest;
                synchronized (resourceBrokerAdaptorTest) {
                    this.resourceBrokerAdaptorTest.jobFinished = true;
                    this.resourceBrokerAdaptorTest.notifyAll();
                }
            }
        }

        public Exception getException() {
            return this.e;
        }
    }
}

