/*
 * Decompiled with CFR 0.152.
 */
package examples20;

import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.File;
import org.gridlab.gat.security.CertificateSecurityContext;
import org.gridlab.gat.security.PasswordSecurityContext;
import org.gridlab.gat.security.SecurityContext;

public class SecurityExample {
    public static void main(String[] args) {
        GATContext context = new GATContext();
        try {
            CertificateSecurityContext globusSecurityContext = new CertificateSecurityContext(new URI("userkey.pem"), new URI("usercert.pem"), "grid-proxy-init passphrase");
            globusSecurityContext.addNote("adaptors", "globus,wsgt4new");
            context.addSecurityContext((SecurityContext)globusSecurityContext);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        PasswordSecurityContext ftpSecurityContext = new PasswordSecurityContext(System.getProperty("user.name"), "ftp password");
        ftpSecurityContext.addNote("adaptors", "ftp");
        ftpSecurityContext.addNote("hosts", "host1,host2:21");
        context.addSecurityContext((SecurityContext)ftpSecurityContext);
        PasswordSecurityContext sshSecurityContext = new PasswordSecurityContext(System.getProperty("user.name"), "ssh password");
        sshSecurityContext.addNote("adaptors", "sshtrilead,commandlinessh");
        sshSecurityContext.addNote("hosts", "host3");
        context.addSecurityContext((SecurityContext)sshSecurityContext);
        try {
            File file = GAT.createFile((GATContext)context, (URI)new URI(args[0]));
            System.out.println(args[0] + " exists: " + file.exists());
        }
        catch (Exception e) {
            System.err.println("Failed to check whether '" + args[0] + "' exists: " + e);
        }
        try {
            File file2 = GAT.createFile((URI)new URI(args[0]));
            System.out.println(args[0] + " exists: " + file2.exists());
        }
        catch (Exception e) {
            System.err.println("Failed to check whether '" + args[0] + "' exists: " + e);
        }
    }
}

