/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.jclouds;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import es.bsc.jclouds.client.JCloudsClient;
import integratedtoolkit.connectors.AbstractSSHConnector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.types.AdaptorDescription;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.options.TemplateOptions;

public class JClouds
extends AbstractSSHConnector {
    private JCloudsClient jclouds;
    private String provider;
    private String server;
    private String user;
    private String credential;
    private long timeSlot;
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;
    private static final int DEFAULT_IP_INDEX = 0;
    private int ipIndex = 0;

    public JClouds(String providerName, HashMap<String, String> props) throws Exception {
        super(providerName, props);
        super.setDefaultUser("jclouds");
        this.server = props.get("Server");
        this.provider = props.get("provider");
        if (this.provider == null) {
            throw new Exception("Provider must be specified with \"provider\" property");
        }
        this.user = props.get("provider-user");
        if (this.user == null) {
            throw new Exception("Provider user must be specified with \"provider-user\" property");
        }
        this.credential = props.get("provider-user-credential");
        if (this.credential == null) {
            throw new Exception("Provider user credential must be specified with \"provider-user-credential\" property");
        }
        String time = props.get("time-slot");
        if (time == null) {
            throw new Exception("Provider billing time-slot must be specified with \"time-slot\" property");
        }
        this.timeSlot = Integer.parseInt(time) * 1000;
        String index = props.get("ip-index");
        if (index != null) {
            this.ipIndex = Integer.parseInt(index);
        }
        this.jclouds = new JCloudsClient(this.user, this.credential, this.provider, this.server);
    }

    public void destroy(Object vm) throws ConnectorException {
        this.jclouds.destroyNode(((NodeMetadata)vm).getId());
    }

    public Object create(String name, CloudMethodResourceDescription rd) throws ConnectorException {
        try {
            Template template = this.generateTemplate(rd);
            Set vms = this.jclouds.createVMS(name, 1, template);
            return vms.iterator().next();
        }
        catch (RunNodesException e) {
            throw new ConnectorException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ConnectorException((Exception)e);
        }
    }

    private Template generateTemplate(CloudMethodResourceDescription rd) throws IOException {
        TemplateOptions to = new TemplateOptions();
        String key = super.getKeyPairLocation() + super.getKeyPairName();
        logger.debug((Object)("Authorizing keys :" + key));
        to.authorizePublicKey(Files.toString((File)new File(key + ".pub"), (Charset)Charsets.UTF_8));
        to.overrideLoginPrivateKey(Files.toString((File)new File(key), (Charset)Charsets.UTF_8));
        HashSet<Integer> ports = new HashSet<Integer>();
        logger.debug((Object)"Adding ssh inbound port");
        ports.add(22);
        TreeMap adaptors = rd.getImage().getAdaptorsDescription();
        if (adaptors != null && !adaptors.isEmpty()) {
            for (AdaptorDescription adaptor : adaptors.values()) {
                int[] range = adaptor.getPortRange();
                for (int port = range[0]; port <= range[1]; ++port) {
                    logger.debug((Object)("Adding inbound port:" + port));
                    ports.add(port);
                }
            }
        }
        to.inboundPorts(Ints.toArray(ports));
        logger.debug((Object)("Creating template with image " + rd.getImage().getName()));
        return this.jclouds.createTemplate(rd.getType(), rd.getImage().getName(), to);
    }

    public CloudMethodResourceDescription waitUntilCreation(Object vm, CloudMethodResourceDescription requested) throws ConnectorException {
        CloudMethodResourceDescription granted = new CloudMethodResourceDescription();
        NodeMetadata vmd = (NodeMetadata)vm;
        try {
            logger.info((Object)("VM State is " + ((NodeMetadata.Status)vmd.getStatus()).toString()));
            int tries = 0;
            while (vmd.getStatus() == null || !((NodeMetadata.Status)vmd.getStatus()).equals((Object)NodeMetadata.Status.RUNNING)) {
                if (((NodeMetadata.Status)vmd.getStatus()).equals((Object)NodeMetadata.Status.ERROR)) {
                    logger.error((Object)"Error waiting for VM Creation. Middleware has return an error state");
                    throw new ConnectorException("Error waiting for VM Creation. Middleware has return an error state");
                }
                if (((NodeMetadata.Status)vmd.getStatus()).equals((Object)NodeMetadata.Status.SUSPENDED)) {
                    logger.error((Object)"VM Creation Suspended");
                    throw new ConnectorException("VM creation suspended");
                }
                if ((long)tries * 5L > 1800L) {
                    throw new ConnectorException("Maximum VM creation time reached.");
                }
                ++tries;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                vmd = this.jclouds.getNode(vmd.getId());
            }
            String ip = this.getIp(vmd);
            granted.setName(ip);
            granted.setType(requested.getType());
            granted.setProcessorCPUCount(vmd.getHardware().getProcessors().size());
            int cores = this.getTotalCores(vmd.getHardware().getProcessors());
            granted.setProcessorCoreCount(cores);
            granted.setProcessorArchitecture(requested.getProcessorArchitecture());
            granted.setProcessorSpeed(new Float(((Processor)vmd.getHardware().getProcessors().get(0)).getSpeed()).floatValue());
            granted.setMemoryPhysicalSize((float)(vmd.getHardware().getRam() / 1024));
            granted.setMemoryAccessTime(requested.getMemoryAccessTime());
            granted.setMemorySTR(requested.getMemorySTR());
            granted.setMemoryVirtualSize(requested.getMemoryVirtualSize());
            float disk = this.getTotalDisk(vmd.getHardware().getVolumes());
            granted.setStorageElemSize(disk);
            granted.setStorageElemAccessTime(requested.getStorageElemAccessTime());
            granted.setStorageElemSTR(requested.getStorageElemSTR());
            granted.setOperatingSystemType("Linux");
            granted.setSlots(requested.getSlots());
            granted.getAppSoftware().addAll(requested.getAppSoftware());
            granted.setImage(requested.getImage());
            granted.setValue(requested.getValue().floatValue());
            granted.setValue(this.getMachineCostPerTimeSlot(granted));
            return granted;
        }
        catch (Exception e) {
            logger.error((Object)"Exception waiting for VM Creation");
            throw new ConnectorException(e);
        }
    }

    private float getTotalDisk(List<? extends Volume> volumes) {
        float totalDisk = 0.0f;
        for (Volume volume : volumes) {
            totalDisk += volume.getSize().floatValue();
        }
        return totalDisk;
    }

    private int getTotalCores(List<? extends Processor> processors) {
        int totalCores = 0;
        for (Processor processor : processors) {
            totalCores += (int)processor.getCores();
        }
        return totalCores;
    }

    private String getIp(NodeMetadata vmd) throws ConnectorException {
        if (vmd.getPublicAddresses().isEmpty()) {
            if (vmd.getPrivateAddresses().isEmpty()) {
                throw new ConnectorException("No addresses found in the node description");
            }
            if (vmd.getPrivateAddresses().size() < this.ipIndex + 1) {
                return (String)vmd.getPrivateAddresses().iterator().next();
            }
            return (String)vmd.getPrivateAddresses().toArray()[this.ipIndex];
        }
        if (vmd.getPublicAddresses().size() < this.ipIndex + 1) {
            return (String)vmd.getPublicAddresses().iterator().next();
        }
        return (String)vmd.getPublicAddresses().toArray()[this.ipIndex];
    }

    public float getMachineCostPerTimeSlot(CloudMethodResourceDescription rd) {
        return rd.getValue().floatValue();
    }

    public long getTimeSlot() {
        return this.timeSlot;
    }

    protected void close() {
        this.jclouds.close();
    }
}

