/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import javax.inject.Singleton;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserIdGroupPairToSourceSecurityGroupFormParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof UserIdGroupPair, "this binder is only valid for UserIdGroupPair!");
        UserIdGroupPair pair = (UserIdGroupPair)input;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("SourceSecurityGroupOwnerId", pair.getUserId());
        builder.put("SourceSecurityGroupName", pair.getGroupName());
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(builder.build())).build();
    }
}

