/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloud.domain;

import com.google.common.collect.ForwardingList;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.javax.annotation.Nullable;

public final class ForwardingListPage<T>
extends ForwardingList<T>
implements ListPage<T> {
    private final List<T> items;
    private final String nextPageToken;

    @ConstructorProperties(value={"items", "nextPageToken"})
    ForwardingListPage(List<T> items, String nextPageToken) {
        this.items = NullSafeCopies.copyOf(items);
        this.nextPageToken = nextPageToken;
    }

    public static <T> ListPage<T> create(List<T> items, String nextPageToken) {
        return new ForwardingListPage<T>(items, nextPageToken);
    }

    @Override
    @Nullable
    public String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    protected List<T> delegate() {
        return this.items;
    }
}

