/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.RSASHA1Verify;
import java.io.IOException;

public class PacketAgentIdentitiesAnswer {
    private final int numKeys;
    private final byte[][] blobs;
    private final Object[] keys;

    public PacketAgentIdentitiesAnswer(byte[] payload, int off, int len) throws IOException {
        TypesReader tr = new TypesReader(payload, off, len);
        int packet_type = tr.readByte();
        if (packet_type != 12) {
            throw new IOException("This is not a SSH2_AGENT_IDENTITIES_ANSWER! (" + packet_type + ")");
        }
        this.numKeys = tr.readUINT32();
        this.blobs = new byte[this.numKeys][];
        this.keys = new Object[this.numKeys];
        for (int i = 0; i < this.numKeys; ++i) {
            this.blobs[i] = tr.readByteString();
            tr.readByteString();
            try {
                this.keys[i] = DSASHA1Verify.decodeSSHDSAPublicKey(this.blobs[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                try {
                    this.keys[i] = RSASHA1Verify.decodeSSHRSAPublicKey(this.blobs[i]);
                    continue;
                }
                catch (IllegalArgumentException e1) {
                    throw new IOException("Don't understand answer from ssh agent");
                }
            }
        }
    }

    public int getNumKeys() {
        return this.numKeys;
    }

    public byte[][] getBlobs() {
        return this.blobs;
    }

    public Object[] getKeys() {
        return this.keys;
    }
}

