/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.comm.Comm;
import integratedtoolkit.comm.CommAdaptor;
import integratedtoolkit.types.COMPSsMaster;
import integratedtoolkit.types.data.location.URI;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.util.ErrorManager;
import java.io.File;

public class MasterResource
extends Resource {
    protected static final String ERROR_COMPSs_LOG_BASE_DIR = "ERROR: Cannot create .COMPSs base log directory";
    protected static final String ERROR_APP_OVERLOAD = "ERROR: Cannot erase overloaded directory";
    protected static final String ERROR_APP_LOG_DIR = "ERROR: Cannot create application log directory";
    protected static final String ERROR_TEMP_DIR = "ERROR: Cannot create temp directory";
    protected static final String ERROR_JOBS_DIR = "ERROR: Cannot create jobs directory";
    protected static final String ERROR_WORKERS_DIR = "ERROR: Cannot create workers directory";
    protected static final String WARN_FOLDER_OVERLOAD = "WARNING: Reached maximum number of executions for this application. To avoid this warning please clean .COMPSs folder";
    protected static final int MAX_OVERLOAD = 100;
    private final String userExecutionDirPath = System.getProperty("user.dir");
    private final String COMPSsLogBaseDirPath = System.getProperty("it.baseLogDir") != null ? (!System.getProperty("it.baseLogDir").equals("") ? System.getProperty("it.baseLogDir") + File.separator + ".COMPSs" + File.separator : System.getProperty("user.home") + File.separator + ".COMPSs" + File.separator) : System.getProperty("user.home") + File.separator + ".COMPSs" + File.separator;
    private static String appLogDirPath;
    private static String tempDirPath;
    private static String jobsDirPath;
    private static String workersDirPath;

    public MasterResource() {
        super(new COMPSsMaster());
        if (!new File(this.COMPSsLogBaseDirPath).exists() && !new File(this.COMPSsLogBaseDirPath).mkdir()) {
            ErrorManager.error(ERROR_COMPSs_LOG_BASE_DIR);
        }
        String appName = System.getProperty("it.appName");
        if (System.getProperty("it.serviceName") != null) {
            String serviceName = System.getProperty("it.serviceName");
            int overloadCode = 1;
            String oldest = appLogDirPath = this.COMPSsLogBaseDirPath + serviceName + "_0" + String.valueOf(overloadCode) + File.separator;
            while (new File(appLogDirPath).exists() && overloadCode <= 100) {
                if (new File(oldest).lastModified() > new File(appLogDirPath).lastModified()) {
                    oldest = appLogDirPath;
                }
                if (++overloadCode < 10) {
                    appLogDirPath = this.COMPSsLogBaseDirPath + serviceName + "_0" + String.valueOf(overloadCode) + File.separator;
                    continue;
                }
                appLogDirPath = this.COMPSsLogBaseDirPath + serviceName + "_" + String.valueOf(overloadCode) + File.separator;
            }
            if (overloadCode > 100) {
                appLogDirPath = oldest;
                System.err.println(WARN_FOLDER_OVERLOAD);
                System.err.println("Overwriting entry: " + appLogDirPath);
                if (!this.deleteDirectory(new File(appLogDirPath))) {
                    ErrorManager.error(ERROR_APP_OVERLOAD);
                }
            }
            if (!new File(appLogDirPath).mkdir()) {
                ErrorManager.error(ERROR_APP_LOG_DIR);
            }
            System.setProperty("it.appLogDir", appLogDirPath);
        } else {
            int overloadCode = 1;
            String oldest = appLogDirPath = this.COMPSsLogBaseDirPath + appName + "_0" + String.valueOf(overloadCode) + File.separator;
            while (new File(appLogDirPath).exists() && overloadCode <= 100) {
                if (new File(oldest).lastModified() > new File(appLogDirPath).lastModified()) {
                    oldest = appLogDirPath;
                }
                if (++overloadCode < 10) {
                    appLogDirPath = this.COMPSsLogBaseDirPath + appName + "_0" + String.valueOf(overloadCode) + File.separator;
                    continue;
                }
                appLogDirPath = this.COMPSsLogBaseDirPath + appName + "_" + String.valueOf(overloadCode) + File.separator;
            }
            if (overloadCode > 100) {
                appLogDirPath = oldest;
                System.err.println(WARN_FOLDER_OVERLOAD);
                System.err.println("Overwriting entry: " + appLogDirPath);
                if (!this.deleteDirectory(new File(appLogDirPath))) {
                    ErrorManager.error(ERROR_APP_OVERLOAD);
                }
            }
            if (!new File(appLogDirPath).mkdir()) {
                ErrorManager.error(ERROR_APP_LOG_DIR);
            }
            System.setProperty("it.appLogDir", appLogDirPath);
        }
        tempDirPath = appLogDirPath + "tmpFiles" + File.separator;
        if (!new File(tempDirPath).mkdir()) {
            ErrorManager.error(ERROR_TEMP_DIR);
        }
        if (!new File(jobsDirPath = appLogDirPath + "jobs" + File.separator).mkdir()) {
            ErrorManager.error(ERROR_JOBS_DIR);
        }
        if (!new File(workersDirPath = appLogDirPath + "workers" + File.separator).mkdir()) {
            System.err.println(ERROR_WORKERS_DIR);
            System.exit(1);
        }
    }

    private boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        return directory.delete();
    }

    public String getCOMPSsLogBaseDirPath() {
        return this.COMPSsLogBaseDirPath;
    }

    public String getWorkingDirectory() {
        return tempDirPath;
    }

    public String getUserExecutionDirPath() {
        return this.userExecutionDirPath;
    }

    public String getAppLogDirPath() {
        return appLogDirPath;
    }

    public String getTempDirPath() {
        return tempDirPath;
    }

    public String getJobsDirPath() {
        return jobsDirPath;
    }

    public String getWorkersDirPath() {
        return workersDirPath;
    }

    @Override
    public void setInternalURI(URI u) {
        for (CommAdaptor adaptor : Comm.getAdaptors().values()) {
            adaptor.completeMasterURI(u);
        }
    }

    @Override
    public Resource.Type getType() {
        return Resource.Type.MASTER;
    }

    @Override
    public int compareTo(Resource t) {
        if (t.getType() == Resource.Type.MASTER) {
            return this.getName().compareTo(t.getName());
        }
        return 1;
    }
}

