/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.CoreManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class CloudTypeManager {
    private HashMap<String, Type> types = new HashMap();
    private HashMap<String, HashMap<String, int[]>> vmToType = new HashMap();

    public void add(CloudMethodResourceDescription rd) {
        Type t = new Type(rd);
        this.types.put(rd.getName(), t);
    }

    public LinkedList<CloudMethodResourceDescription> getCompatibleTypes(MethodResourceDescription requested) {
        LinkedList<CloudMethodResourceDescription> compatiblesList = new LinkedList<CloudMethodResourceDescription>();
        if (this.types.isEmpty()) {
            compatiblesList.add(new CloudMethodResourceDescription(requested));
        }
        for (Type type : this.types.values()) {
            CloudMethodResourceDescription rd = type.rd;
            CloudMethodResourceDescription mixedDescription = new CloudMethodResourceDescription(rd);
            if (mixedDescription.getProcessorArchitecture().compareTo("[unassigned]") == 0) {
                mixedDescription.setProcessorArchitecture(requested.getProcessorArchitecture());
            } else if (requested.getProcessorArchitecture().compareTo("[unassigned]") != 0 && requested.getProcessorArchitecture().compareTo(mixedDescription.getProcessorArchitecture()) != 0) continue;
            if (mixedDescription.getProcessorSpeed() == 0.0f) {
                mixedDescription.setProcessorSpeed(requested.getProcessorSpeed());
            } else if (requested.getProcessorSpeed() > 0.0f && requested.getProcessorSpeed() > mixedDescription.getProcessorSpeed()) continue;
            if (mixedDescription.getMemoryAccessTime() == 0.0f) {
                mixedDescription.setMemoryAccessTime(requested.getMemoryAccessTime());
            } else if (requested.getMemoryAccessTime() > 0.0f && requested.getMemoryAccessTime() > mixedDescription.getMemoryAccessTime()) continue;
            if (mixedDescription.getMemorySTR() == 0.0f) {
                mixedDescription.setMemorySTR(requested.getMemorySTR());
            } else if (requested.getMemorySTR() > 0.0f && requested.getMemorySTR() > mixedDescription.getMemorySTR()) continue;
            if (mixedDescription.getStorageElemSize() == 0.0f) {
                mixedDescription.setStorageElemSize(requested.getStorageElemSize());
            } else if (requested.getStorageElemSize() > 0.0f && requested.getStorageElemSize() > mixedDescription.getStorageElemSize()) continue;
            if (mixedDescription.getStorageElemAccessTime() == 0.0f) {
                mixedDescription.setStorageElemAccessTime(requested.getStorageElemAccessTime());
            } else if (requested.getStorageElemAccessTime() > 0.0f && requested.getStorageElemAccessTime() > mixedDescription.getStorageElemAccessTime()) continue;
            if (mixedDescription.getStorageElemSTR() == 0.0f) {
                mixedDescription.setStorageElemSTR(requested.getStorageElemSTR());
            } else if (requested.getStorageElemSTR() > 0.0f && requested.getStorageElemSTR() > mixedDescription.getStorageElemSTR()) continue;
            compatiblesList.add(mixedDescription);
        }
        return compatiblesList;
    }

    public Set<String> getAllInstanceTypeNames() {
        return this.types.keySet();
    }

    public void createdVM(String resourceName, String requestType) {
        HashMap<String, Object> vm = this.vmToType.get(resourceName);
        if (vm == null) {
            vm = new HashMap();
            for (String type : this.types.keySet()) {
                vm.put(type, new int[]{0});
            }
            vm.put(requestType, new int[]{1});
            this.vmToType.put(resourceName, vm);
        } else {
            int[] nArray = vm.get(requestType);
            nArray[0] = nArray[0] + 1;
        }
    }

    public void reduceVM(String resourceName, String requestType) {
        HashMap<String, int[]> vm = this.vmToType.remove(resourceName);
        if (vm != null) {
            int[] nArray = vm.get(requestType);
            nArray[0] = nArray[0] - 1;
            if (this.hasValidInstances(vm)) {
                this.vmToType.put(resourceName, vm);
            }
        }
    }

    public void clearAll() {
        this.vmToType.clear();
    }

    public CloudMethodResourceDescription getDescription(String type) {
        Type t = this.types.get(type);
        if (t != null) {
            return t.rd;
        }
        return null;
    }

    public int[][] getSimultaneousImpls(String type) {
        Type t = this.types.get(type);
        if (t != null) {
            return t.slotsImpl;
        }
        return null;
    }

    public HashMap<String, Object[]> getPossibleReductions(String name) {
        HashMap<String, Object[]> h = new HashMap<String, Object[]>();
        for (Map.Entry<String, int[]> entry : this.vmToType.get(name).entrySet()) {
            Type t;
            String type = entry.getKey();
            Object[] value = new Object[2];
            int[] amount = entry.getValue();
            if (amount == null || amount[0] <= 0 || (t = this.types.get(type)) == null) continue;
            value[0] = t.slotsCore;
            value[1] = t.rd;
            h.put(type, value);
        }
        return h;
    }

    public void removeVM(String name) {
        this.vmToType.remove(name);
    }

    private boolean hasValidInstances(HashMap<String, int[]> vm) {
        int validCount = 0;
        for (int[] amounts : vm.values()) {
            validCount += amounts[0];
        }
        return validCount == 0;
    }

    public HashMap<CloudMethodResourceDescription, Integer> getComposition(String name) {
        HashMap<String, int[]> vm = this.vmToType.get(name);
        HashMap<CloudMethodResourceDescription, Integer> composition = new HashMap<CloudMethodResourceDescription, Integer>();
        for (Map.Entry<String, int[]> entry : vm.entrySet()) {
            String typeName = entry.getKey();
            int[] counts = entry.getValue();
            Type type = this.types.get(typeName);
            if (type == null || counts[0] <= 0) continue;
            composition.put(type.rd, counts[0]);
        }
        return composition;
    }

    public void newCoreElementsDetected(LinkedList<Integer> newCores) {
        int coreCount = CoreManager.getCoreCount();
        for (Type type : this.types.values()) {
            int[] slotsC = new int[coreCount];
            int[][] slotsI = new int[coreCount][];
            System.arraycopy(type.slotsCore, 0, slotsC, 0, type.slotsCore.length);
            for (int i = 0; i < type.slotsImpl.length; ++i) {
                slotsI[i] = new int[type.slotsImpl[i].length];
                System.arraycopy(type.slotsImpl[i], 0, slotsI[i], 0, type.slotsImpl[i].length);
            }
            Iterator i$ = newCores.iterator();
            while (i$.hasNext()) {
                int coreId = (Integer)i$.next();
                Implementation<?>[] impls = CoreManager.getCoreImplementations(coreId);
                slotsI[coreId] = new int[impls.length];
                for (int implId = 0; implId < impls.length; ++implId) {
                    if (impls[implId].getType() != Implementation.Type.METHOD) continue;
                    MethodResourceDescription rd = (MethodResourceDescription)impls[implId].getRequirements();
                    Integer into = type.rd.canHostSimultaneously(rd);
                    slotsC[coreId] = Math.max(slotsC[coreId], into);
                    slotsI[coreId][implId] = into;
                }
            }
            type.slotsCore = slotsC;
            type.slotsImpl = slotsI;
        }
    }

    public String getCurrentState(String prefix) {
        int coreCount = CoreManager.getCoreCount();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("TYPES = [").append("\n");
        for (Map.Entry<String, Type> entry : this.types.entrySet()) {
            int i;
            sb.append(prefix).append("\t").append("TYPE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("KEY = ").append(entry.getKey()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("CORES = [").append("\n");
            for (i = 0; i < coreCount; ++i) {
                sb.append(prefix).append("\t").append("\t").append("\t").append("CORE = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("COREID = ").append(i).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("SLOTS = ").append(entry.getValue().slotsCore[i]).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("\t").append("IMPLEMENTATIONS = [").append("\n");
            for (i = 0; i < coreCount; ++i) {
                for (int j = 0; j < CoreManager.getCoreImplementations(i).length; ++j) {
                    sb.append(prefix).append("\t").append("\t").append("\t").append("IMPLEMENTATION = [").append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("COREID = ").append(i).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("SLOTS = ").append(entry.getValue().slotsImpl[i][j]).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
                }
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        sb.append(prefix).append("VIRTUAL_INSTANCES = [").append("\n");
        for (Map.Entry<String, Object> entry : this.vmToType.entrySet()) {
            HashMap composition = (HashMap)entry.getValue();
            sb.append(prefix).append("\t").append("VIRTUAL_INSTANCE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("NAME = ").append(entry.getKey()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("COMPONENTS = [").append("\n");
            for (Map.Entry component : composition.entrySet()) {
                String componentName = (String)component.getKey();
                int[] amount = (int[])component.getValue();
                sb.append(prefix).append("\t").append("\t").append("\t").append("COMPONENT = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("NAME = ").append(componentName).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("AMOUNT = ").append(amount[0]).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }

    private class Type {
        CloudMethodResourceDescription rd;
        int[] slotsCore;
        int[][] slotsImpl;

        Type(CloudMethodResourceDescription rd) {
            this.rd = rd;
            int coreCount = CoreManager.getCoreCount();
            this.slotsCore = new int[coreCount];
            this.slotsImpl = new int[coreCount][];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                Implementation<?>[] impls = CoreManager.getCoreImplementations(coreId);
                this.slotsImpl[coreId] = new int[impls.length];
                for (int implId = 0; implId < impls.length; ++implId) {
                    if (impls[implId].getType() != Implementation.Type.METHOD) continue;
                    MethodResourceDescription reqs = (MethodResourceDescription)impls[implId].getRequirements();
                    Integer into = rd.canHostSimultaneously(reqs);
                    this.slotsCore[coreId] = Math.max(this.slotsCore[coreId], into);
                    this.slotsImpl[coreId][implId] = into;
                }
            }
        }
    }
}

