/*
 * Decompiled with CFR 0.152.
 */
package org.opennebula.client.template;

import org.opennebula.client.Client;
import org.opennebula.client.OneResponse;
import org.opennebula.client.PoolElement;
import org.w3c.dom.Node;

public class Template
extends PoolElement {
    private static final String METHOD_PREFIX = "template.";
    private static final String ALLOCATE = "template.allocate";
    private static final String INFO = "template.info";
    private static final String DELETE = "template.delete";
    private static final String UPDATE = "template.update";
    private static final String CHOWN = "template.chown";
    private static final String CHMOD = "template.chmod";
    private static final String INSTANTIATE = "template.instantiate";
    private static final String CLONE = "template.clone";
    private static final String RENAME = "template.rename";

    public Template(int n, Client client) {
        super(n, client);
    }

    protected Template(Node node, Client client) {
        super(node, client);
    }

    public static OneResponse allocate(Client client, String string) {
        return client.call(ALLOCATE, string);
    }

    public static OneResponse info(Client client, int n) {
        return client.call(INFO, n);
    }

    public static OneResponse delete(Client client, int n) {
        return client.call(DELETE, n);
    }

    public static OneResponse update(Client client, int n, String string, boolean bl) {
        return client.call(UPDATE, n, string, bl ? 1 : 0);
    }

    public static OneResponse publish(Client client, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return Template.chmod(client, n, -1, -1, -1, n2, -1, -1, -1, -1, -1);
    }

    public static OneResponse chown(Client client, int n, int n2, int n3) {
        return client.call(CHOWN, n, n2, n3);
    }

    public static OneResponse chmod(Client client, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return Template.chmod(client, CHMOD, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public static OneResponse chmod(Client client, int n, String string) {
        return Template.chmod(client, CHMOD, n, string);
    }

    public static OneResponse chmod(Client client, int n, int n2) {
        return Template.chmod(client, CHMOD, n, n2);
    }

    public static OneResponse instantiate(Client client, int n, String string, boolean bl, String string2) {
        return client.call(INSTANTIATE, n, string, bl, string2);
    }

    public static OneResponse clone(Client client, int n, String string) {
        return client.call(CLONE, n, string);
    }

    public static OneResponse rename(Client client, int n, String string) {
        return client.call(RENAME, n, string);
    }

    public OneResponse info() {
        OneResponse oneResponse = Template.info(this.client, this.id);
        super.processInfo(oneResponse);
        return oneResponse;
    }

    public OneResponse delete() {
        return Template.delete(this.client, this.id);
    }

    public OneResponse update(String string) {
        return this.update(string, false);
    }

    public OneResponse update(String string, boolean bl) {
        return Template.update(this.client, this.id, string, bl);
    }

    public OneResponse publish(boolean bl) {
        return Template.publish(this.client, this.id, bl);
    }

    public OneResponse publish() {
        return this.publish(true);
    }

    public OneResponse unpublish() {
        return this.publish(false);
    }

    public OneResponse chown(int n, int n2) {
        return Template.chown(this.client, this.id, n, n2);
    }

    public OneResponse chown(int n) {
        return this.chown(n, -1);
    }

    public OneResponse chgrp(int n) {
        return this.chown(-1, n);
    }

    public OneResponse chmod(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Template.chmod(this.client, this.id, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public OneResponse chmod(String string) {
        return Template.chmod(this.client, this.id, string);
    }

    public OneResponse chmod(int n) {
        return Template.chmod(this.client, this.id, n);
    }

    public OneResponse instantiate(String string, boolean bl, String string2) {
        return Template.instantiate(this.client, this.id, string, bl, string2);
    }

    public OneResponse instantiate(String string) {
        return Template.instantiate(this.client, this.id, string, false, "");
    }

    public OneResponse instantiate() {
        return Template.instantiate(this.client, this.id, "", false, "");
    }

    public OneResponse clone(String string) {
        return Template.clone(this.client, this.id, string);
    }

    public OneResponse rename(String string) {
        return Template.rename(this.client, this.id, string);
    }
}

