/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.advert.cpi.generic;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.advert.Advertisable;
import org.gridlab.gat.advert.MetaData;
import org.gridlab.gat.advert.cpi.AdvertServiceCpi;
import org.gridlab.gat.engine.GATEngine;
import org.gridlab.gat.io.FileInterface;

public class GenericAdvertServiceAdaptor
extends AdvertServiceCpi {
    static final String SEPARATOR = "/";
    String pwd = "/";
    Hashtable<String, Entry> database = new Hashtable();

    public static String getDescription() {
        return "The Generic AdvertService Adaptor implements the Advert Service object using a JavaGAT File object.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = AdvertServiceCpi.getSupportedCapabilities();
        capabilities.put("add", true);
        capabilities.put("delete", true);
        capabilities.put("getMetaData", true);
        capabilities.put("getAdvertisable", true);
        capabilities.put("find", true);
        capabilities.put("setPWD", true);
        capabilities.put("getPWD", true);
        return capabilities;
    }

    public GenericAdvertServiceAdaptor(GATContext gatContext) throws GATObjectCreationException {
        super(gatContext);
        String home = System.getProperty("user.home");
        if (home == null) {
            throw new GATObjectCreationException("could not get user home dir");
        }
    }

    public Advertisable getAdvertisable(GATContext context, String path) throws GATInvocationException, NoSuchElementException {
        Entry entry = this.database.get(path = this.normalizePath(path));
        if (entry == null) {
            throw new NoSuchElementException("No such element: " + path);
        }
        if (entry.getPath() == null) {
            throw new NoSuchElementException("No such element: " + path);
        }
        return GATEngine.getGATEngine().unmarshalAdvertisable(context, entry.getPath());
    }

    public void add(Advertisable advert, MetaData metadata, String path) throws GATInvocationException {
        path = this.normalizePath(path);
        try {
            String advertString = null;
            if (advert != null && (advertString = advert.marshal()) == null) {
                throw new GATInvocationException("could not marshal object");
            }
            this.database.put(path, new Entry(advertString, metadata));
        }
        catch (Exception e) {
            throw new GATInvocationException("local advert", (Throwable)e);
        }
    }

    public void delete(String path) throws NoSuchElementException, GATInvocationException {
        path = this.normalizePath(path);
        this.database.remove(path);
    }

    public String[] find(MetaData query) throws GATInvocationException {
        Vector<String> res = new Vector<String>();
        Enumeration<String> keys = this.database.keys();
        Enumeration<Entry> data = this.database.elements();
        while (data.hasMoreElements()) {
            Entry entry = data.nextElement();
            String key = keys.nextElement();
            MetaData m = entry.metadata;
            if (!m.match(query)) continue;
            res.add(key);
        }
        return res.toArray(new String[res.size()]);
    }

    public MetaData getMetaData(String path) throws NoSuchElementException, GATInvocationException {
        path = this.normalizePath(path);
        return this.database.get(path).getMetaData();
    }

    public String getPWD() {
        return this.pwd;
    }

    public void setPWD(String path) {
        if (path.startsWith(SEPARATOR)) {
            this.pwd = path;
        } else {
            try {
                this.pwd = new java.net.URI(this.pwd + path).normalize().getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public void exportDataBase(URI target) throws GATInvocationException {
        FileInterface sourceFile = null;
        try {
            sourceFile = GAT.createFile((GATContext)this.gatContext, (URI)new URI("file:///" + this.save())).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("failed to create source file", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new GATInvocationException("failed to create source file", (Throwable)e);
        }
        sourceFile.copy(target);
        sourceFile.delete();
    }

    public synchronized void importDataBase(URI source) throws GATInvocationException {
        FileInterface sourceFile = null;
        try {
            sourceFile = GAT.createFile((GATContext)this.gatContext, (URI)source).getFileInterface();
        }
        catch (GATObjectCreationException e) {
            throw new GATInvocationException("failed to create source file", (Throwable)e);
        }
        try {
            File tempLocalFile = File.createTempFile("JavaGAT", "advert-database");
            sourceFile.copy(new URI("file:///" + tempLocalFile.getPath()));
            this.load(tempLocalFile);
            tempLocalFile.delete();
        }
        catch (URISyntaxException e) {
            throw new GATInvocationException("failed to copy", (Throwable)e);
        }
        catch (IOException e) {
            throw new GATInvocationException("failed to copy", (Throwable)e);
        }
    }

    private synchronized String save() throws GATInvocationException {
        ObjectOutputStream out = null;
        FileLock lock = null;
        File f = null;
        try {
            f = File.createTempFile("JavaGAT", "advert-database");
        }
        catch (IOException e) {
            throw new GATInvocationException("local advert", (Throwable)e);
        }
        try {
            FileOutputStream fout = new FileOutputStream(f);
            FileChannel fc = fout.getChannel();
            lock = fc.lock();
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            out = new ObjectOutputStream(bout);
            out.writeObject(this.database);
        }
        catch (Exception e) {
            throw new GATInvocationException("local advert", (Throwable)e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
        return f.getPath();
    }

    private synchronized void load(File f) throws GATInvocationException {
        if (!f.exists()) {
            return;
        }
        ObjectInputStream in = null;
        FileLock lock = null;
        try {
            RandomAccessFile rf = new RandomAccessFile(f, "rw");
            FileChannel fc = rf.getChannel();
            lock = fc.lock();
            FileInputStream fin = new FileInputStream(rf.getFD());
            BufferedInputStream bin = new BufferedInputStream(fin);
            in = new ObjectInputStream(bin);
            this.database = (Hashtable)in.readObject();
        }
        catch (Exception e) {
            throw new GATInvocationException("local advert", (Throwable)e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (Exception e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private String normalizePath(String path) throws GATInvocationException {
        try {
            if (!path.startsWith(SEPARATOR)) {
                path = this.pwd.endsWith(SEPARATOR) ? this.pwd + path : this.pwd + SEPARATOR + path;
            }
            java.net.URI u = new java.net.URI(path);
            return u.normalize().getPath();
        }
        catch (Exception e) {
            throw new GATInvocationException("local advert", (Throwable)e);
        }
    }

    public String toString() {
        return this.database.toString();
    }

    static class Entry
    implements Serializable {
        private String path;
        private MetaData metadata;

        public Entry(String path, MetaData metadata) {
            this.path = path;
            this.metadata = metadata;
        }

        public String getPath() {
            return this.path;
        }

        public MetaData getMetaData() {
            return this.metadata;
        }

        public String toString() {
            return "<" + this.path + ", " + this.metadata + ">";
        }
    }
}

