/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.stage;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.EventManager;
import es.bsc.comm.InternalConnection;
import es.bsc.comm.nio.NIOProperties;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public abstract class Stage {
    protected static final Logger LOGGER = Logger.getLogger("Communication");
    protected final boolean notifyErrors;

    public Stage(boolean notifyErrors) {
        this.notifyErrors = notifyErrors;
    }

    public boolean isShutdown() {
        return false;
    }

    public abstract boolean checkViability(boolean var1, LinkedList<ByteBuffer> var2, LinkedList<ByteBuffer> var3) throws CommException;

    public abstract void start(InternalConnection var1, LinkedList<ByteBuffer> var2, LinkedList<ByteBuffer> var3) throws Exception;

    public abstract void progress(InternalConnection var1, LinkedList<ByteBuffer> var2, LinkedList<ByteBuffer> var3) throws Exception;

    public abstract boolean isComplete(LinkedList<ByteBuffer> var1, LinkedList<ByteBuffer> var2);

    public abstract void notifyCompletion(Connection var1, EventManager<?> var2);

    public abstract void notifyError(Connection var1, EventManager<?> var2, CommException var3);

    public abstract void pause(InternalConnection var1);

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    protected void sendToken(Token token, LinkedList<ByteBuffer> transmit) {
        while (!token.isCompletelyRead() && transmit.size() < NIOProperties.MAX_BUFFERED_PACKETS) {
            this.sendTokenPacket(token, transmit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTokenPacket(Token t, LinkedList<ByteBuffer> transmit) {
        ByteBuffer bb = ByteBuffer.wrap(t.get(NIOProperties.PACKET_SIZE));
        LinkedList<ByteBuffer> linkedList = transmit;
        synchronized (linkedList) {
            transmit.add(bb);
        }
    }

    protected void loadToken(Token token, LinkedList<ByteBuffer> received) {
        while (received.size() > 0 && !token.isCompletelyFilled()) {
            this.loadTokenPacket(token, received);
        }
    }

    protected void loadTokenPacket(Token t, LinkedList<ByteBuffer> received) {
        ByteBuffer bb = received.removeFirst();
        t.load(bb);
        if (bb.hasRemaining()) {
            received.addFirst(bb);
        }
    }

    protected static class Token {
        private static final int SIZE_LENGTH = 4;
        public static final int MAX_SIZE = 10240;
        private final byte[] sizeArray = new byte[4];
        private byte[] content;
        private int putPosition = 0;
        private int readPosition = 0;

        public Token() {
        }

        public Token(byte[] data) {
            int size = data.length;
            this.sizeArray[0] = (byte)(size >>> 24);
            this.sizeArray[1] = (byte)(size >>> 16);
            this.sizeArray[2] = (byte)(size >>> 8);
            this.sizeArray[3] = (byte)size;
            this.content = data;
            this.putPosition = 4 + data.length;
        }

        public void load(ByteBuffer data) {
            if (this.putPosition < 4) {
                while (this.putPosition < 4 && data.remaining() > 0) {
                    this.sizeArray[this.putPosition] = data.get();
                    ++this.putPosition;
                }
                if (this.putPosition == 4) {
                    int size = this.sizeArray[3] & 0xFF | (this.sizeArray[2] & 0xFF) << 8 | (this.sizeArray[1] & 0xFF) << 16 | (this.sizeArray[0] & 0xFF) << 24;
                    this.readPosition = 4;
                    this.content = new byte[size];
                }
            }
            if (data.remaining() > 0) {
                int toRead = data.remaining();
                int toWrite = this.content.length - (this.putPosition - 4);
                int read = Math.min(toRead, toWrite);
                data.get(this.content, this.putPosition - 4, read);
                this.putPosition += read;
            }
        }

        public byte[] getArray() {
            return this.content;
        }

        public int length() {
            if (this.content != null) {
                return this.content.length;
            }
            return 0;
        }

        public boolean isCompletelyFilled() {
            return this.content != null && this.putPosition == this.content.length + 4;
        }

        public boolean isCompletelyRead() {
            return this.content != null && this.readPosition == this.content.length + 4;
        }

        public byte[] get(int size) {
            int arraySize = this.putPosition - this.readPosition;
            arraySize = Math.min(size, arraySize);
            byte[] b = new byte[arraySize];
            int idx = 0;
            while (this.readPosition < 4) {
                b[idx] = this.sizeArray[this.readPosition];
                ++idx;
                ++this.readPosition;
            }
            if (idx < arraySize && this.readPosition < this.putPosition) {
                System.arraycopy(this.content, this.readPosition - 4, b, idx, arraySize - idx);
                this.readPosition += arraySize - idx;
            }
            return b;
        }
    }
}

