/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.worker;

import integratedtoolkit.ITConstants;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.worker.NIOWorker;
import integratedtoolkit.nio.worker.executors.CExecutor;
import integratedtoolkit.nio.worker.executors.JavaExecutor;
import integratedtoolkit.nio.worker.executors.PythonExecutor;
import integratedtoolkit.util.RequestDispatcher;
import integratedtoolkit.util.RequestQueue;
import org.apache.log4j.Logger;

public class JobLauncher
extends RequestDispatcher<NIOTask> {
    protected static final int NUM_HEADER_PARS = 5;
    private final NIOWorker nw;
    private final JavaExecutor java = new JavaExecutor();
    private final CExecutor c = new CExecutor();
    private final PythonExecutor python = new PythonExecutor();
    private Logger logger;
    private boolean workerDebug = false;

    public JobLauncher(RequestQueue<NIOTask> queue, NIOWorker nw, Logger logger, boolean workerDebug) {
        super(queue);
        this.nw = nw;
        this.logger = logger;
        this.workerDebug = workerDebug;
    }

    @Override
    public void processRequests() {
        while (true) {
            NIOTask nt;
            if ((nt = (NIOTask)this.queue.dequeue()) == null) break;
            if (this.workerDebug) {
                this.logger.debug("Dequeuing job " + nt.getJobId());
            }
            boolean success = this.executeTask(nt);
            if (this.workerDebug) {
                this.logger.debug("Job " + nt.getJobId() + " finished (success: " + success + ")");
            }
            this.nw.sendTaskDone(nt, success);
        }
        this.logger.debug("Dequeued job is null");
    }

    private boolean executeTask(NIOTask nt) {
        switch (ITConstants.Lang.valueOf(nt.lang.toUpperCase())) {
            case JAVA: {
                return this.java.execute(nt, this.nw);
            }
            case PYTHON: {
                return this.python.execute(nt, this.nw);
            }
            case C: {
                return this.c.execute(nt, this.nw);
            }
        }
        System.err.println("Incorrect language " + nt.lang + " in job " + nt.getJobId());
        return false;
    }
}

