/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.worker;

import es.bsc.comm.CommException;
import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.stage.Transfer;
import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.NIOAgent;
import integratedtoolkit.nio.NIOMessageHandler;
import integratedtoolkit.nio.NIOParam;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.NIOURI;
import integratedtoolkit.nio.commands.CommandDataReceived;
import integratedtoolkit.nio.commands.CommandShutdownACK;
import integratedtoolkit.nio.commands.CommandTaskDone;
import integratedtoolkit.nio.commands.Data;
import integratedtoolkit.nio.commands.workerFiles.CommandWorkerDebugFilesDone;
import integratedtoolkit.nio.exceptions.SerializedObjectException;
import integratedtoolkit.nio.worker.JobLauncher;
import integratedtoolkit.nio.worker.ObjectCache;
import integratedtoolkit.nio.worker.ThreadPrintStream;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.RequestQueue;
import integratedtoolkit.util.Serializer;
import integratedtoolkit.util.ThreadPool;
import integratedtoolkit.util.Tracer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class NIOWorker
extends NIOAgent {
    public static boolean workerDebug;
    public static String workingDir;
    public static int jobThreads;
    public static String POOL_NAME;
    protected static final String THREAD_POOL_ERR = "Error starting pool of threads";
    protected static final Logger wLogger;
    private static final int MAX_RETRIES = 5;
    protected static ThreadPool pool;
    public static RequestQueue<NIOTask> jobQueue;
    public static ThreadPrintStream out;
    public static ThreadPrintStream err;
    private final ObjectCache objectCache;
    private final String host;
    private String deploymentId;

    public NIOWorker(String uuid, int snd, int rcv, int masterPort, String hostName) {
        super(snd, rcv, masterPort);
        wLogger.info("NIO Worker init");
        this.deploymentId = uuid;
        this.objectCache = new ObjectCache();
        this.masterNode = null;
        jobQueue = new RequestQueue();
        if (tracing_level == 1) {
            NIOTracer.enablePThreads();
        }
        pool = new ThreadPool(jobThreads, POOL_NAME, new JobLauncher(jobQueue, this, wLogger, workerDebug));
        try {
            pool.startThreads();
        }
        catch (Exception e) {
            ErrorManager.error(THREAD_POOL_ERR, e);
        }
        if (tracing_level == 1) {
            NIOTracer.disablePThreads();
        }
        this.host = hostName;
    }

    @Override
    public void setWorkerIsReady(String nodeName) {
    }

    @Override
    public void setMaster(NIONode master) {
        if (this.masterNode == null) {
            this.masterNode = new NIONode(master.ip, masterPort);
        }
    }

    @Override
    public boolean isMyUuid(String uuid) {
        return uuid.equals(this.deploymentId);
    }

    @Override
    public void receivedNewTask(NIONode master, NIOTask task, LinkedList<String> obsoleteFiles) {
        wLogger.info("Received Job " + task);
        if (obsoleteFiles != null) {
            this.removeObsolete(obsoleteFiles);
        }
        wLogger.info("Checking parameters");
        TransferringTask tt = new TransferringTask(task);
        int i = 0;
        block12: for (NIOParam param : task.getParams()) {
            ++i;
            if (param.getData() != null) {
                wLogger.debug("- Checking transfers for data of parameter " + (String)param.getValue());
                switch (param.getType()) {
                    case OBJECT_T: {
                        wLogger.debug("   - " + (String)param.getValue() + " registered as object.");
                        boolean catched = false;
                        boolean locationsInCache = false;
                        boolean existInHost = false;
                        boolean askTransfer = false;
                        wLogger.debug("   - Checking if " + (String)param.getValue() + " is in cache.");
                        catched = this.objectCache.checkPresence((String)param.getValue());
                        if (!catched) {
                            wLogger.debug("   - Checking if " + (String)param.getValue() + " locations are catched");
                            for (NIOURI loc : param.getData().getSources()) {
                                if (!this.objectCache.checkPresence(loc.getPath())) continue;
                                wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") location found in cache.");
                                try {
                                    Object o;
                                    if (param.isPreserveSourceData()) {
                                        wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") preserves sources. CACHE-COPYING");
                                        o = Serializer.deserialize(loc.getPath());
                                        this.storeInCache((String)param.getValue(), o);
                                    } else {
                                        wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") erases sources. CACHE-MOVING");
                                        o = this.objectCache.get(loc.getPath());
                                        this.objectCache.remove(loc.getPath());
                                        this.storeInCache((String)param.getValue(), o);
                                    }
                                    locationsInCache = true;
                                }
                                catch (IOException ioe) {
                                    wLogger.error(ioe);
                                }
                                catch (ClassNotFoundException e) {
                                    wLogger.error(e);
                                }
                                break;
                            }
                            if (!locationsInCache) {
                                wLogger.debug("   - Checking if " + (String)param.getValue() + " locations are in host");
                                NIOURI loc = param.getData().getURIinHost(this.host);
                                if (loc != null) {
                                    wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") found at host.");
                                    try {
                                        File source = new File(workingDir + File.separator + loc.getPath());
                                        File target = new File(workingDir + File.separator + param.getValue().toString());
                                        if (param.isPreserveSourceData()) {
                                            wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") preserves sources. COPYING");
                                            wLogger.debug("         Source obj. file: " + source);
                                            wLogger.debug("         Target: " + target);
                                            Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
                                        } else {
                                            wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") erases sources. MOVING");
                                            wLogger.debug("         Source obj. file: " + source);
                                            wLogger.debug("         Target obj. file: " + target);
                                            source.renameTo(target);
                                        }
                                        Object o = Serializer.deserialize((String)param.getValue());
                                        this.storeInCache((String)param.getValue(), o);
                                        existInHost = true;
                                    }
                                    catch (IOException ioe) {
                                        wLogger.error(ioe);
                                    }
                                    catch (ClassNotFoundException e) {
                                        wLogger.error(e);
                                    }
                                }
                                if (!existInHost) {
                                    askTransfer = true;
                                }
                            }
                        }
                        if (askTransfer) {
                            wLogger.info("- Parameter " + i + "(" + (String)param.getValue() + ") does not exist, requesting data transfer");
                            WorkerDataRequest dr = new WorkerDataRequest(tt, param.getType(), param.getData(), (String)param.getValue());
                            this.addTransferRequest(dr);
                            continue block12;
                        }
                        wLogger.info("- Parameter " + i + "(" + (String)param.getValue() + ") already exists.");
                        --tt.params;
                        continue block12;
                    }
                    case FILE_T: {
                        wLogger.debug("   - " + (String)param.getValue() + " registered as file.");
                        boolean exists = false;
                        boolean locationsInHost = false;
                        boolean askTransfer = false;
                        wLogger.debug("   - Checking if file " + (String)param.getValue() + " exists.");
                        File f = new File(param.getValue().toString());
                        exists = f.exists();
                        if (!exists) {
                            wLogger.debug("   - Checking if " + (String)param.getValue() + " exists in worker");
                            NIOURI loc = param.getData().getURIinHost(this.host);
                            if (loc != null) {
                                wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") found at host.");
                                try {
                                    File source = new File(loc.getPath());
                                    File target = new File(param.getValue().toString());
                                    if (param.isPreserveSourceData()) {
                                        wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") preserves sources. COPYING");
                                        wLogger.debug("         Source file: " + source);
                                        wLogger.debug("         Target file: " + target);
                                        Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
                                    } else {
                                        wLogger.debug("   - Parameter " + i + "(" + (String)param.getValue() + ") erases sources. MOVING");
                                        wLogger.debug("         Source file: " + source);
                                        wLogger.debug("         Target file: " + target);
                                        Files.move(source.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
                                    }
                                    locationsInHost = true;
                                }
                                catch (IOException ioe) {
                                    wLogger.error(ioe);
                                }
                            }
                            if (!locationsInHost) {
                                askTransfer = true;
                            }
                        } else if (this.getDataRequests(param.getData().getName()) != null) {
                            askTransfer = true;
                        }
                        if (askTransfer) {
                            wLogger.info("- Parameter " + i + "(" + (String)param.getValue() + ") does not exist, requesting data transfer");
                            WorkerDataRequest dr = new WorkerDataRequest(tt, param.getType(), param.getData(), (String)param.getValue());
                            this.addTransferRequest(dr);
                            continue block12;
                        }
                        wLogger.info("- Parameter " + i + "(" + (String)param.getValue() + ") already exists.");
                        --tt.params;
                        continue block12;
                    }
                }
                continue;
            }
            --tt.params;
        }
        if (tracing) {
            NIOTracer.emitEvent(tt.task.getTaskId(), NIOTracer.getTaskTransfersType());
        }
        this.requestTransfers();
        if (tracing) {
            NIOTracer.emitEvent(0L, NIOTracer.getTaskTransfersType());
        }
        if (tt.params == 0) {
            this.executeTask(tt.task);
        }
    }

    @Override
    protected void handleDataToSendNotAvailable(Connection c, Data d) {
        ErrorManager.warn("Data " + d.getName() + "in this worker " + this.getHostName() + " could not be sent to master.");
        c.finishConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestedDataNotAvailableError(LinkedList<NIOAgent.DataRequest> failedRequests, String dataId) {
        for (NIOAgent.DataRequest dr : failedRequests) {
            WorkerDataRequest wdr = (WorkerDataRequest)dr;
            --((WorkerDataRequest)wdr).task.params;
            ((WorkerDataRequest)wdr).task.error = true;
            if (((WorkerDataRequest)wdr).task.params == 0) {
                this.sendTaskDone(((WorkerDataRequest)wdr).task.task, false);
            }
            String baseJobPath = workingDir + "/jobs/job" + ((WorkerDataRequest)wdr).task.task.getJobId() + "_" + (Object)((Object)((WorkerDataRequest)wdr).task.task.getHist());
            File fout = new File(baseJobPath + ".out");
            File ferr = new File(baseJobPath + ".err");
            if (fout.exists() && ferr.exists()) continue;
            FileOutputStream fos = null;
            try {
                String errorMessage = "Worker closed because the data " + dataId + " couldn't be retrieved.";
                fos = new FileOutputStream(fout);
                fos.write(errorMessage.getBytes());
                fos.close();
                fos = new FileOutputStream(ferr);
                fos.write(errorMessage.getBytes());
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void receivedValue(Transfer.Destination type, String dataId, Object object, LinkedList<NIOAgent.DataRequest> achievedRequests) {
        if (type == Transfer.Destination.OBJECT) {
            wLogger.info("Received data " + dataId + " with associated object " + object);
            this.storeInCache(dataId, object);
        } else {
            wLogger.info("Received data " + dataId);
        }
        for (NIOAgent.DataRequest dr : achievedRequests) {
            WorkerDataRequest wdr = (WorkerDataRequest)dr;
            --((WorkerDataRequest)wdr).task.params;
            if (tracing) {
                NIOTracer.emitDataTransferEvent("0");
            }
            if (((WorkerDataRequest)wdr).task.params != 0) continue;
            if (!((WorkerDataRequest)wdr).task.error) {
                this.executeTask(((WorkerDataRequest)wdr).task.task);
                continue;
            }
            this.sendTaskDone(((WorkerDataRequest)wdr).task.task, false);
        }
    }

    public void sendTaskDone(NIOTask nt, boolean successful) {
        int taskID = nt.getJobId();
        Connection c = null;
        for (int retries = 0; retries < 5; ++retries) {
            try {
                c = tm.startConnection(this.masterNode);
                break;
            }
            catch (Exception e) {
                if (retries >= 5) {
                    wLogger.error("Exception sending Task notification", e);
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        CommandTaskDone cmd = new CommandTaskDone(this, taskID, successful);
        c.sendCommand(cmd);
        if (workerDebug) {
            c.sendDataFile(workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()) + ".out");
            c.sendDataFile(workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()) + ".err");
        } else if (!successful) {
            c.sendDataFile(workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()) + ".out");
            c.sendDataFile(workingDir + "/jobs/job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist()) + ".err");
        }
        c.finishConnection();
    }

    private void executeTask(NIOTask task) {
        if (workerDebug) {
            wLogger.debug("Enqueueing job " + task.getJobId() + " for execution.");
        }
        jobQueue.enqueue(task);
        if (workerDebug) {
            wLogger.debug("Notifying presence of all data for job " + task.getJobId() + ".");
        }
        CommandDataReceived cdr = new CommandDataReceived(this, task.getTransferGroupId());
        for (int retries = 0; retries < 5; ++retries) {
            if (this.tryNofiyDataReceived(cdr)) {
                return;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean tryNofiyDataReceived(CommandDataReceived cdr) {
        Connection c = tm.startConnection(this.masterNode);
        c.sendCommand(cdr);
        c.finishConnection();
        return true;
    }

    public void removeObsolete(LinkedList<String> obsolete) {
        try {
            for (String name : obsolete) {
                if (name.startsWith(File.separator)) {
                    File f = new File(name);
                    f.delete();
                    continue;
                }
                this.removeFromCache(name);
            }
        }
        catch (Exception e) {
            wLogger.error(e);
        }
    }

    public void receivedUpdateSources(Connection c) {
    }

    @Override
    public void shutdown(Connection closingConnection) {
        wLogger.debug("Entering shutdown method on worker");
        try {
            pool.stopThreads();
            if (closingConnection != null) {
                closingConnection.sendCommand(new CommandShutdownACK());
                closingConnection.finishConnection();
            }
            tm.shutdown(closingConnection);
        }
        catch (Exception e) {
            wLogger.error(e);
        }
        wLogger.debug("Finish shutdown method on worker");
    }

    @Override
    public Object getObject(String s) throws SerializedObjectException {
        String realName = s.substring(s.lastIndexOf(47) + 1);
        return this.objectCache.get(realName);
    }

    @Override
    public String getObjectAsFile(String s) {
        wLogger.warn("getObjectAsFile has been called in the worker side!");
        return null;
    }

    public void storeInCache(String name, Object value) {
        this.objectCache.store(name, value);
    }

    public void removeFromCache(String name) {
        this.objectCache.remove(name);
    }

    @Override
    public String getWorkingDir() {
        return workingDir + File.separator;
    }

    public static void main(String[] args) {
        workerDebug = Boolean.valueOf(args[0]);
        workingDir = args[1];
        jobThreads = new Integer(args[2]);
        int maxSnd = new Integer(args[3]);
        int maxRcv = new Integer(args[4]);
        String workerIP = args[5];
        int wPort = new Integer(args[6]);
        int mPort = new Integer(args[7]);
        String trace = args[8];
        String host = args[9];
        String installDir = args[10];
        String appUuid = args[11];
        System.setProperty("it.tracing", trace);
        tracing = Integer.parseInt(trace) > 0;
        tracing_level = Integer.parseInt(trace);
        if (tracing) {
            NIOTracer.emitEvent(Tracer.Event.START.getId(), Tracer.Event.START.getType());
            try {
                tracingID = Integer.parseInt(host);
                NIOTracer.setWorkerInfo(installDir, workerIP, workingDir, tracingID);
            }
            catch (Exception e) {
                logger.error("No valid hostID provided to the tracing system. Provided ID: " + host);
            }
        }
        ConsoleAppender console = new ConsoleAppender();
        Logger.getRootLogger().setLevel(workerDebug ? Level.DEBUG : Level.OFF);
        String PATTERN = "%d [%p|%c|%C{1}] %m%n";
        console.setLayout(new PatternLayout(PATTERN));
        console.activateOptions();
        Logger.getRootLogger().addAppender(console);
        if (workerDebug) {
            wLogger.debug("WorkingDir:" + workingDir);
            wLogger.debug("jobThreads: " + String.valueOf(jobThreads));
            wLogger.debug("maxSnd: " + String.valueOf(maxSnd));
            wLogger.debug("maxRcv: " + String.valueOf(maxRcv));
            wLogger.debug("WorkerName: " + workerIP);
            wLogger.debug("WorkerPort: " + String.valueOf(wPort));
            wLogger.debug("MasterPort: " + String.valueOf(mPort));
            wLogger.debug("Tracing: " + trace);
            wLogger.debug("Host: " + host);
            wLogger.debug("Install Dir: " + installDir);
            wLogger.debug("App uuid: " + appUuid);
        }
        NIOWorker nw = new NIOWorker(appUuid, maxSnd, maxRcv, mPort, workerIP);
        NIOMessageHandler mh = new NIOMessageHandler(nw);
        wLogger.debug("  Initializing the TransferManager structures...");
        try {
            tm.init("es.bsc.comm.nio.NIOEventManager", null, mh);
        }
        catch (CommException ce) {
            wLogger.error("Error initializing Transfer Manager on worker " + nw.getHostName(), ce);
            nw.shutdown(null);
            return;
        }
        wLogger.debug("  Starting TransferManager Thread");
        tm.start();
        try {
            tm.startServer(new NIONode(null, wPort));
        }
        catch (CommException ce) {
            wLogger.error("Error starting TransferManager Server at Worker" + nw.getHostName(), ce);
            nw.shutdown(null);
            return;
        }
        if (tracing) {
            NIOTracer.emitEvent(0L, Tracer.Event.START.getType());
        }
        try {
            tm.join();
        }
        catch (InterruptedException ie) {
            wLogger.warn("TransferManager interrupted", ie);
        }
    }

    public static void registerOutputs(String path) {
        err.registerThread(path);
        out.registerThread(path);
    }

    public static void unregisterOutputs() {
        err.unregisterThread();
        out.unregisterThread();
    }

    @Override
    public void receivedTaskDone(Connection c, int jobID, boolean successful) {
    }

    @Override
    public void copiedData(int transfergroupID) {
    }

    @Override
    public void shutdownNotification(Connection c) {
    }

    public String getHostName() {
        return this.host;
    }

    @Override
    public void waitUntilTracingPackageGenerated() {
    }

    @Override
    public void notifyTracingPackageGeneration() {
    }

    @Override
    public void waitUntilWorkersDebugInfoGenerated() {
    }

    @Override
    public void notifyWorkersDebugInfoGeneration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateWorkersDebugInfo(Connection c) {
        String outSource = workingDir + File.separator + "log" + File.separator + "worker_" + this.host + ".out";
        String outTarget = workingDir + File.separator + "log" + File.separator + "static_" + "worker_" + this.host + ".out";
        if (new File(outSource).exists()) {
            try {
                Files.copy(new File(outSource).toPath(), new File(outTarget).toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                logger.error(e);
            }
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outTarget);
                fos.write("Empty file".getBytes());
                fos.close();
            }
            catch (Exception e) {
                logger.error(e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        logger.error(e);
                    }
                }
            }
        }
        String errSource = workingDir + File.separator + "log" + File.separator + "worker_" + this.host + ".err";
        String errTarget = workingDir + File.separator + "log" + File.separator + "static_" + "worker_" + this.host + ".err";
        if (new File(errSource).exists()) {
            try {
                Files.copy(new File(errSource).toPath(), new File(errTarget).toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                logger.error(e);
            }
        } else {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(errTarget);
                fos.write("Empty file".getBytes());
                fos.close();
            }
            catch (Exception e) {
                logger.error(e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        logger.error(e);
                    }
                }
            }
        }
        c.sendCommand(new CommandWorkerDebugFilesDone());
        c.finishConnection();
    }

    static {
        POOL_NAME = "NIO_JOBS";
        wLogger = Logger.getLogger("integratedtoolkit.Worker");
        try {
            out = new ThreadPrintStream(".out", System.out);
            err = new ThreadPrintStream(".err", System.err);
            System.setErr(err);
            System.setOut(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class TransferringTask {
        NIOTask task;
        int params;
        boolean error;

        public TransferringTask(NIOTask task) {
            this.task = task;
            this.params = task.getParams().size();
        }
    }

    private class WorkerDataRequest
    extends NIOAgent.DataRequest {
        private final TransferringTask task;

        public WorkerDataRequest(TransferringTask task, ITExecution.ParamType type, Data source, String target) {
            super(type, source, target);
            this.task = task;
        }
    }
}

