/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.nio.worker.executors;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.nio.NIOParam;
import integratedtoolkit.nio.NIOTask;
import integratedtoolkit.nio.NIOTracer;
import integratedtoolkit.nio.exceptions.JobExecutionException;
import integratedtoolkit.nio.worker.NIOWorker;
import integratedtoolkit.nio.worker.executors.Executor;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;

public class JavaExecutor
extends Executor {
    @Override
    String createSandBox() {
        return null;
    }

    @Override
    void executeTask(String sandBox, NIOTask nt, NIOWorker nw) throws Exception {
        int i;
        int i2;
        Object[] values;
        Class[] types;
        int taskType = nt.getTaskType() + 1;
        int taskId = nt.getTaskId();
        boolean debug = NIOWorker.workerDebug;
        String className = nt.getClassName();
        String methodName = nt.getMethodName();
        boolean hasTarget = nt.isHasTarget();
        int numParams = nt.getNumParams();
        if (hasTarget) {
            types = new Class[numParams - 1];
            values = new Object[numParams - 1];
        } else {
            types = new Class[numParams];
            values = new Object[numParams];
        }
        boolean[] isFile = new boolean[numParams];
        String[] renamings = new String[numParams];
        boolean[] writeFinalValue = new boolean[numParams];
        for (int i3 = 0; i3 < writeFinalValue.length; ++i3) {
            writeFinalValue[i3] = false;
        }
        Object target = null;
        Iterator params = nt.getParams().iterator();
        for (i2 = 0; i2 < numParams; ++i2) {
            NIOParam np = (NIOParam)params.next();
            switch (np.getType()) {
                case FILE_T: {
                    types[i2] = String.class;
                    values[i2] = np.getValue();
                    writeFinalValue[i2] = np.isWriteFinalValue();
                    break;
                }
                case OBJECT_T: {
                    String renaming;
                    String name = renaming = (renamings[i2] = np.getValue().toString());
                    writeFinalValue[i2] = np.isWriteFinalValue();
                    Object o = nw.getObject(name);
                    if (hasTarget && i2 == numParams - 1) {
                        if (o == null) {
                            throw new JobExecutionException("Target object with renaming " + name + ", method " + methodName + ", class " + className + " is null!" + "\n");
                        }
                        target = o;
                        break;
                    }
                    if (o == null) {
                        throw new JobExecutionException("Object parameter " + i2 + " with renaming " + name + ", method " + methodName + ", class " + className + " is null!" + "\n");
                    }
                    types[i2] = o.getClass();
                    values[i2] = o;
                    break;
                }
                case BOOLEAN_T: {
                    types[i2] = Boolean.TYPE;
                    values[i2] = np.getValue();
                    break;
                }
                case CHAR_T: {
                    types[i2] = Character.TYPE;
                    values[i2] = np.getValue();
                    break;
                }
                case STRING_T: {
                    types[i2] = String.class;
                    values[i2] = np.getValue();
                    break;
                }
                case BYTE_T: {
                    types[i2] = Byte.TYPE;
                    values[i2] = np.getValue();
                    break;
                }
                case SHORT_T: {
                    types[i2] = Short.TYPE;
                    values[i2] = np.getValue();
                    break;
                }
                case INT_T: {
                    types[i2] = Integer.TYPE;
                    values[i2] = np.getValue();
                    break;
                }
                case LONG_T: {
                    types[i2] = Long.TYPE;
                    values[i2] = np.getValue();
                    break;
                }
                case FLOAT_T: {
                    types[i2] = Float.TYPE;
                    values[i2] = np.getValue();
                    break;
                }
                case DOUBLE_T: {
                    types[i2] = Double.TYPE;
                    values[i2] = np.getValue();
                }
            }
            isFile[i2] = np.getType().equals((Object)ITExecution.ParamType.FILE_T);
        }
        if (debug) {
            System.out.println("WORKER - Parameters of execution:");
            System.out.println("  * Method class: " + className);
            System.out.println("  * Method name: " + methodName);
            System.out.print("  * Parameter types:");
            for (i2 = 0; i2 < types.length; ++i2) {
                System.out.print(" " + types[i2].getName());
            }
            System.out.println();
            System.out.print("  * Parameter values:");
            for (Object v : values) {
                System.out.print(" " + v);
            }
            System.out.println();
        }
        Class<?> methodClass = null;
        Method method = null;
        try {
            methodClass = Class.forName(className);
        }
        catch (Exception e) {
            throw new JobExecutionException("Can not get class by reflection", e);
        }
        try {
            method = methodClass.getMethod(methodName, types);
        }
        catch (Exception e) {
            throw new JobExecutionException("Can not get method by reflection", e);
        }
        if (tracing) {
            NIOTracer.emitEventAndCounters(taskType, NIOTracer.getTaskEventsType());
            NIOTracer.emitEvent(taskId, NIOTracer.getTaskSchedulingType());
        }
        Object retValue = null;
        retValue = method.invoke(target, values);
        if (tracing) {
            NIOTracer.emitEventAndCounters(0, NIOTracer.getTaskEventsType());
            NIOTracer.emitEvent(0L, NIOTracer.getTaskSchedulingType());
        }
        boolean allOutFilesCreated = true;
        for (i = 0; i < numParams; ++i) {
            String filepath;
            File f;
            if (!isFile[i] || (f = new File(filepath = (String)values[i])).exists()) continue;
            String errMsg = "ERROR: File with path '" + values[i] + "' has not been generated by task '" + nt.getMethodName() + "'" + "' (in class '" + nt.getClassName() + "' at method '" + nt.getMethodName() + "', parameter number: " + (i + 1) + " )";
            System.out.println(errMsg);
            System.err.println(errMsg);
            allOutFilesCreated = false;
        }
        if (!allOutFilesCreated) {
            throw new JobExecutionException("ERROR: One or more OUT files have not been created by task '" + nt.getMethodName() + "'");
        }
        for (i = 0; i < numParams; ++i) {
            if (!writeFinalValue[i]) continue;
            Object res = hasTarget && i == numParams - 1 ? target : values[i];
            nw.storeInCache(renamings[i], res);
        }
        if (retValue != null) {
            String renaming = (String)nt.getParams().getLast().getValue();
            nw.storeInCache(renaming.substring(renaming.lastIndexOf(47) + 1), retValue);
        }
    }

    @Override
    void removeSandBox(String sandBox) {
    }
}

