/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.data;

import integratedtoolkit.types.data.DataInstanceId;
import java.io.Serializable;

public abstract class DataAccessId
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract int getDataId();

    public static class RWAccessId
    extends DataAccessId {
        private static final long serialVersionUID = 1L;
        private DataInstanceId readDataInstance;
        private DataInstanceId writtenDataInstance;
        private boolean preserveSourceData = false;

        public RWAccessId() {
        }

        public RWAccessId(DataInstanceId rdi, DataInstanceId wdi, boolean preserveSourceData) {
            this.readDataInstance = rdi;
            this.writtenDataInstance = wdi;
            this.preserveSourceData = preserveSourceData;
        }

        @Override
        public int getDataId() {
            return this.readDataInstance.getDataId();
        }

        public int getRVersionId() {
            return this.readDataInstance.getVersionId();
        }

        public int getWVersionId() {
            return this.writtenDataInstance.getVersionId();
        }

        public DataInstanceId getReadDataInstance() {
            return this.readDataInstance;
        }

        public DataInstanceId getWrittenDataInstance() {
            return this.writtenDataInstance;
        }

        public boolean isPreserveSourceData() {
            return this.preserveSourceData;
        }

        public String toString() {
            return "Read data: " + this.readDataInstance + ", Written data: " + this.writtenDataInstance + (this.preserveSourceData ? ", Preserved" : ", Erased");
        }
    }

    public static class WAccessId
    extends DataAccessId {
        private static final long serialVersionUID = 1L;
        private DataInstanceId writtenDataInstance;

        public WAccessId() {
        }

        public WAccessId(int dataId, int wVersionId) {
            this.writtenDataInstance = new DataInstanceId(dataId, wVersionId);
        }

        public WAccessId(DataInstanceId wdi) {
            this.writtenDataInstance = wdi;
        }

        @Override
        public int getDataId() {
            return this.writtenDataInstance.getDataId();
        }

        public int getWVersionId() {
            return this.writtenDataInstance.getVersionId();
        }

        public DataInstanceId getWrittenDataInstance() {
            return this.writtenDataInstance;
        }

        public String toString() {
            return "Written data: " + this.writtenDataInstance;
        }
    }

    public static class RAccessId
    extends DataAccessId {
        private static final long serialVersionUID = 1L;
        private DataInstanceId readDataInstance;
        private boolean preserveSourceData = true;

        public RAccessId() {
        }

        public RAccessId(int dataId, int rVersionId) {
            this.readDataInstance = new DataInstanceId(dataId, rVersionId);
        }

        public RAccessId(DataInstanceId rdi) {
            this.readDataInstance = rdi;
        }

        @Override
        public int getDataId() {
            return this.readDataInstance.getDataId();
        }

        public int getRVersionId() {
            return this.readDataInstance.getVersionId();
        }

        public DataInstanceId getReadDataInstance() {
            return this.readDataInstance;
        }

        public boolean isPreserveSourceData() {
            return this.preserveSourceData;
        }

        public String toString() {
            return "Read data: " + this.readDataInstance + (this.preserveSourceData ? ", Preserved" : ", Erased");
        }
    }
}

