/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import integratedtoolkit.connectors.AbstractConnector;
import integratedtoolkit.connectors.Connector;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.utils.KeyManager;
import integratedtoolkit.types.CloudImageDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;

public abstract class AbstractSSHConnector
extends AbstractConnector {
    private static Integer MAX_ALLOWED_ERRORS = 3;
    private static Integer RETRY_TIME = 10;
    private static int SERVER_TIMEOUT = 20000;
    private String defaultUser = System.getProperty("user.name");
    private String keyPairName = "id_rsa";
    private String keyPairLocation = System.getProperty("user.home") + File.separator + ".ssh";

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
    }

    public String getKeyPairName() {
        return this.keyPairName;
    }

    public String getKeyPairLocation() {
        return this.keyPairLocation;
    }

    public AbstractSSHConnector(String providerName, HashMap<String, String> props) {
        super(providerName, props);
        if (props.get("vm-user") != null) {
            this.defaultUser = props.get("vm-user");
        }
        if (props.get("vm-keypair-name") != null) {
            this.keyPairName = props.get("vm-keypair-name");
        }
        if (props.get("vm-keypair-location") != null) {
            this.keyPairLocation = props.get("vm-keypair-location");
        }
    }

    @Override
    public void configureAccess(String workerIP, String user, String password) throws ConnectorException {
        if (debug) {
            logger.debug((Object)("Configuring access for user " + user + " in " + workerIP));
        }
        Session c = null;
        try {
            this.putInKnownHosts(workerIP);
            String keypair = KeyManager.getKeyPair();
            String passwordOrKeyPair = null;
            boolean setPassword = false;
            if (user == null) {
                user = this.defaultUser;
            }
            if (password != null) {
                setPassword = true;
                passwordOrKeyPair = password;
            } else if (this.keyPairName != null) {
                setPassword = false;
                passwordOrKeyPair = this.keyPairLocation + File.separator + this.keyPairName;
            }
            c = AbstractSSHConnector.getSession(workerIP, user, setPassword, passwordOrKeyPair);
            if (keypair == null) {
                throw new ConnectorException("There are no key pair to configure. Please create with ssh-keygen tool");
            }
            if (debug) {
                logger.debug((Object)("Configuring key pair: " + keypair));
            }
            this.configureKeys(workerIP, user, c, KeyManager.getPublicKey(keypair), KeyManager.getPrivateKey(keypair), KeyManager.getKeyType());
        }
        catch (Exception e) {
            logger.error((Object)("Error configuring access for " + workerIP), (Throwable)e);
            throw new ConnectorException(e);
        }
        finally {
            if (c != null && c.isConnected()) {
                if (debug) {
                    logger.debug((Object)"Disconnecting session");
                }
                c.disconnect();
            }
        }
    }

    @Override
    public void prepareMachine(String ip, CloudImageDescription cid) throws ConnectorException {
        if (debug) {
            logger.debug((Object)("Preparing new machine " + ip));
        }
        String user = cid.getProperties().get("User");
        LinkedList<String[]> packages = cid.getPackages();
        if (!packages.isEmpty()) {
            Session c = null;
            ChannelSftp client = null;
            try {
                c = AbstractSSHConnector.getSession(ip, user, false, null);
                client = (ChannelSftp)c.openChannel("sftp");
                client.connect();
                for (String[] p : packages) {
                    String[] path = p[0].split(File.separator);
                    String name = path[path.length - 1];
                    String target = p[1] + File.separator + name;
                    if (client == null) {
                        if (c != null) {
                            c.disconnect();
                        }
                        logger.error((Object)("Client is null. Can not connect to " + ip));
                        throw new ConnectorException("Can not connect to " + ip);
                    }
                    client.put(p[0], target, (SftpProgressMonitor)new MyProgressMonitor());
                    client.chmod(Integer.parseInt("700", 8), target);
                    String command = "tar xzf " + target + " -C " + p[1] + " && rm " + p[1] + File.separator + name;
                    this.executeTask(ip, user, command, c);
                    command = "echo \"\nfor i in " + p[1] + File.separator + "*.jar ; " + "do\n" + "\texport CLASSPATH=\\$CLASSPATH:\\$i\n" + "done\" >> " + File.separator + "home" + File.separator + user + File.separator + ".bashrc";
                    this.executeTask(ip, user, command, c);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed preparing the Machine " + ip), (Throwable)e);
                throw new ConnectorException("Failed preparing the Machine " + ip + ": " + e.getMessage());
            }
            finally {
                if (client != null && client.isConnected()) {
                    client.disconnect();
                }
                if (c != null) {
                    c.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInKnownHosts(String workerIP) throws ConnectorException {
        if (debug) {
            logger.debug((Object)"Putting id of new machine in master machine known hosts");
        }
        String key = new String();
        String[] cmd = new String[]{"/bin/sh", "-c", "ssh-keyscan -t rsa,dsa " + workerIP};
        int errors = 0;
        String errorString = null;
        while (key.isEmpty() && errors < MAX_ALLOWED_ERRORS) {
            InputStream errStream = null;
            InputStream outStream = null;
            try {
                if (debug) {
                    StringBuilder sb = new StringBuilder("");
                    for (String param : cmd) {
                        sb.append(param).append(" ");
                    }
                    logger.debug((Object)("COMM CMD: " + sb.toString()));
                }
                Process p = Runtime.getRuntime().exec(cmd);
                errStream = p.getErrorStream();
                outStream = p.getInputStream();
                p.waitFor();
                if (p.exitValue() == 0) {
                    key = this.readInputStream(outStream);
                    continue;
                }
                errorString = this.readInputStream(outStream);
                ++errors;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception arr$) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error getting id for known hosts", (Throwable)e);
                throw new ConnectorException(e);
            }
            finally {
                try {
                    outStream.close();
                    errStream.close();
                }
                catch (IOException e) {
                    if (!debug) continue;
                    logger.debug((Object)("Exception closing streams (" + e.getMessage() + ")"));
                }
            }
        }
        if (errors == MAX_ALLOWED_ERRORS) {
            logger.error((Object)("Error executing key-scan command: " + errorString));
            throw new ConnectorException("Error executing key-scan command: " + errorString);
        }
        cmd = new String[]{"/bin/sh", "-c", "/bin/echo \"" + key + "\"" + " >> " + System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "known_hosts"};
        logger.debug((Object)"Modifiying known hosts");
        Object object = knownHosts;
        synchronized (object) {
            errors = 0;
            int exitValue = -1;
            while (exitValue == 0 && errors < MAX_ALLOWED_ERRORS) {
                InputStream errStream = null;
                InputStream outStream = null;
                try {
                    if (debug) {
                        StringBuilder sb = new StringBuilder("");
                        for (String param : cmd) {
                            sb.append(param).append(" ");
                        }
                        logger.debug((Object)("COMM CMD: " + sb.toString()));
                    }
                    Process p = Runtime.getRuntime().exec(cmd);
                    errStream = p.getErrorStream();
                    outStream = p.getInputStream();
                    p.waitFor();
                    if (p.exitValue() == 0) continue;
                    errorString = this.readInputStream(outStream);
                    ++errors;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error adding key in master's known hosts", (Throwable)e);
                    throw new ConnectorException(e);
                }
                finally {
                    try {
                        outStream.close();
                        errStream.close();
                    }
                    catch (IOException e) {
                        if (!debug) continue;
                        logger.debug((Object)("Exception closing streams (" + e.getMessage() + ")"));
                    }
                }
            }
        }
        if (errors == MAX_ALLOWED_ERRORS) {
            logger.error((Object)("Error setting key in local known_hosts: " + errorString));
            throw new ConnectorException("Error setting key in local known_hosts: " + errorString);
        }
    }

    public void configureKeys(String workerIP, String user, Session c, String publicKey, String privateKey, String keyType) throws ConnectorException {
        if (debug) {
            logger.debug((Object)("Configuring keys for " + workerIP + " user: " + user));
        }
        try {
            String command = "/bin/echo \"" + publicKey + "\" > " + File.separator + "home" + File.separator + user + File.separator + ".ssh" + File.separator + keyType + ".pub" + " ; " + "/bin/echo \"" + privateKey + "\" > " + File.separator + "home" + File.separator + user + File.separator + ".ssh" + File.separator + keyType + ";" + "chmod 600 " + File.separator + "home" + File.separator + user + File.separator + ".ssh" + File.separator + keyType + " ; " + "/bin/echo \"" + publicKey + "\" >> " + File.separator + "home" + File.separator + user + File.separator + ".ssh" + File.separator + "authorized_keys";
            this.executeTask(workerIP, user, command, c);
        }
        catch (Exception e) {
            logger.error((Object)("Error configuring keys for " + workerIP + " user: " + user), (Throwable)e);
            throw new ConnectorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask(String ip, String user, String command, Session session) throws ConnectorException {
        ChannelExec exec = null;
        int numRetries = 0;
        ConnectorException reason = null;
        while (numRetries < MAX_ALLOWED_ERRORS) {
            try {
                if (debug) {
                    logger.debug((Object)("Executing command: " + command));
                }
                exec = (ChannelExec)session.openChannel("exec");
                exec.setCommand(command);
                InputStream inputStream = exec.getErrStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                exec.connect(SERVER_TIMEOUT);
                int exitStatus = -1;
                while (exitStatus < 0) {
                    exitStatus = exec.getExitStatus();
                    if (exitStatus == 0) {
                        bufferedReader.close();
                        inputStream.close();
                        if (debug) {
                            logger.debug((Object)("Command successfully executed: " + command));
                        }
                        return;
                    }
                    if (exitStatus > 0) {
                        String line;
                        while ((line = bufferedReader.readLine()) != null) {
                            stringBuilder.append(line);
                            stringBuilder.append('\n');
                        }
                        if (debug) {
                            logger.debug((Object)("Failed to execute command " + command + " in " + ip + ".\nReturned std error: " + stringBuilder.toString()));
                        }
                        bufferedReader.close();
                        inputStream.close();
                        throw new Exception("Failed to execute command " + command + " in " + ip + " (exit status:" + exitStatus + ")");
                    }
                    logger.debug((Object)"Command still on execution");
                    try {
                        Thread.sleep(RETRY_TIME * 1000);
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)"Sleep interrupted");
                    }
                }
                bufferedReader.close();
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)("Exception running command on " + user + "@" + ip), (Throwable)e);
                logger.error((Object)("Retrying: " + ++numRetries + " of " + MAX_ALLOWED_ERRORS));
                reason = new ConnectorException(e);
            }
            finally {
                if (exec != null && exec.isConnected()) {
                    logger.debug((Object)"Disconnecting exec channel");
                    exec.disconnect();
                }
            }
            try {
                Thread.sleep(RETRY_TIME * 1000);
            }
            catch (InterruptedException e) {
                logger.debug((Object)"Sleep interrupted");
            }
        }
        if (numRetries == MAX_ALLOWED_ERRORS) {
            logger.error((Object)("Exception running command on " + user + "@" + ip), reason);
            throw reason;
        }
    }

    private String readInputStream(InputStream is) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append('\n');
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            block11: {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    if (!debug) break block11;
                    logger.debug((Object)("Exception closing the reader (" + e.getMessage() + ")"));
                }
            }
        }
        return stringBuilder.toString();
    }

    private static Session getSession(String host, String user, boolean password, String keyPairOrPassword) throws Exception {
        Session session = null;
        JSch jsch = new JSch();
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        if (keyPairOrPassword == null) {
            password = false;
            keyPairOrPassword = KeyManager.getKeyPair();
            logger.warn((Object)("Neither password nor key-pair specified. Trying with default key-pair (" + KeyManager.getKeyPair() + ")"));
        }
        int errors = 0;
        JSchException exception = null;
        while (errors < MAX_ALLOWED_ERRORS) {
            block12: {
                try {
                    if (password) {
                        session = jsch.getSession(user, host, 22);
                        session.setPassword(keyPairOrPassword);
                    } else {
                        jsch.addIdentity(keyPairOrPassword);
                        session = jsch.getSession(user, host, 22);
                    }
                    session.setConfig(config);
                    session.connect();
                    if (session.isConnected()) {
                        return session;
                    }
                    ++errors;
                    if (password) {
                        logger.warn((Object)("Error connecting to " + user + "@" + host + " with password. Retrying after " + RETRY_TIME * errors + " seconds..."));
                    } else {
                        logger.warn((Object)("Error connecting to " + user + "@" + host + " with public key" + keyPairOrPassword + ". Retrying after " + RETRY_TIME * errors + " seconds..."));
                    }
                }
                catch (JSchException e) {
                    exception = e;
                    logger.warn((Object)("Error creating session to " + user + "@" + host + "(" + e.getMessage() + "). Retrying after " + RETRY_TIME * ++errors + " seconds..."));
                    if (session == null || !session.isConnected()) break block12;
                    session.disconnect();
                }
            }
            try {
                Thread.sleep(RETRY_TIME * errors * 1000);
            }
            catch (Exception e) {
                logger.debug((Object)"Sleep interrumped");
            }
        }
        if (exception != null) {
            logger.error((Object)("Error creating session to " + user + "@" + host), (Throwable)exception);
            throw new Exception("Error creating session to " + user + "@" + host, exception);
        }
        logger.error((Object)("Error creating session to " + user + "@" + host));
        throw new Exception("Error creating session to " + user + "@" + host);
    }

    public static class MyProgressMonitor
    implements SftpProgressMonitor {
        long max = 1L;
        long count = 0L;

        public boolean count(long count) {
            this.count += count;
            float percent = this.count * 100L / this.max;
            if (Connector.debug) {
                Connector.logger.debug((Object)("..." + percent + "%"));
            }
            return true;
        }

        public void end() {
            Connector.logger.debug((Object)"Operation Finished");
        }

        public void init(int op, String src, String dest, long max) {
            if (Connector.debug) {
                Connector.logger.debug((Object)("Starting " + (op == 0 ? "put" : "get") + ": " + src));
            }
            this.max = max;
        }
    }
}

