/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.api.impl;

import integratedtoolkit.api.ITDebug;
import integratedtoolkit.api.impl.IntegratedToolkitImpl;
import integratedtoolkit.components.impl.RuntimeMonitor;
import integratedtoolkit.components.impl.debug.AccessProcessorDebug;
import integratedtoolkit.components.impl.debug.TaskDispatcherDebug;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.Tracer;

public class IntegratedToolkitDebugImpl
extends IntegratedToolkitImpl
implements ITDebug {
    AccessProcessorDebug ap;

    @Override
    public void startIT() {
        if (tracing) {
            Tracer.masterEventFinish();
            Tracer.masterEventStart(Tracer.Event.START.getId());
        }
        Thread.currentThread().setName("APPLICATION");
        if (COMPSs_VERSION == null) {
            logger.info("Starting COMPSs Runtime");
        } else if (COMPSs_BUILDNUMBER == null) {
            logger.info("Starting COMPSs Runtime v" + COMPSs_VERSION);
        } else if (COMPSs_BUILDNUMBER.endsWith("rnull")) {
            COMPSs_BUILDNUMBER = COMPSs_BUILDNUMBER.substring(0, COMPSs_BUILDNUMBER.length() - 6);
            logger.info("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        } else {
            logger.info("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        }
        if (!initialized) {
            logger.debug("Initializing components");
            td = new TaskDispatcherDebug();
            this.ap = new AccessProcessorDebug();
            IntegratedToolkitImpl.ap = this.ap;
            if (RuntimeMonitor.isEnabled()) {
                monitor = new RuntimeMonitor(this.ap, td, Long.parseLong(System.getProperty("it.monitor")));
            }
            this.ap.setTD(td);
            td.setTP(this.ap);
            initialized = true;
            logger.debug("Ready to process tasks");
        } else {
            String className = Thread.currentThread().getStackTrace()[2].getClassName();
            logger.debug("Initializing " + className + "Itf");
            try {
                td.addInterface(Class.forName(className + "Itf"));
            }
            catch (Exception e) {
                ErrorManager.fatal("Error adding interface " + className + "Itf");
            }
        }
        if (tracing) {
            Tracer.masterEventFinish();
        }
    }
}

