/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.impl;

import integratedtoolkit.api.ITExecution;
import integratedtoolkit.comm.Comm;
import integratedtoolkit.components.impl.AccessProcessor;
import integratedtoolkit.components.impl.TaskDispatcher;
import integratedtoolkit.types.Implementation;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.data.DataAccessId;
import integratedtoolkit.types.data.DataInstanceId;
import integratedtoolkit.types.data.LogicalData;
import integratedtoolkit.types.data.Transferable;
import integratedtoolkit.types.data.location.DataLocation;
import integratedtoolkit.types.data.operation.DataOperation;
import integratedtoolkit.types.data.operation.JobTransfersListener;
import integratedtoolkit.types.job.Job;
import integratedtoolkit.types.job.JobStatusListener;
import integratedtoolkit.types.parameter.DependencyParameter;
import integratedtoolkit.types.parameter.Parameter;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.RequestDispatcher;
import integratedtoolkit.util.RequestQueue;
import integratedtoolkit.util.ThreadPool;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobManager {
    private static final String STAGING_ERR = "Error staging in job files";
    private AccessProcessor TP;
    private TaskDispatcher TD;
    private static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher.JobManager");
    private static final boolean debug = logger.isDebugEnabled();
    private static final boolean presched = System.getProperty("it.presched") != null && System.getProperty("it.presched").equals("true");
    public Map<Integer, Worker<?>> enfDataToService;
    public JobDispatcher jd = new JobDispatcher(1, "Job Submitter");
    public static final int POOL_SIZE = 1;
    public static final String POOL_NAME = "Job Submitter";

    public JobManager() {
        this.enfDataToService = new HashMap();
        logger.info("Initialization finished");
    }

    public void setCoWorkers(AccessProcessor TP, TaskDispatcher TD) {
        this.TP = TP;
        this.TD = TD;
    }

    public void shutdown() {
        this.jd.stop();
    }

    public void newJob(Task task, Implementation<?> impl, Worker<?> res) {
        this.processJob(task, impl, res, Job.JobHistory.NEW);
    }

    public void jobRescheduled(Task task, Implementation<?> impl, Worker<?> res) {
        this.processJob(task, impl, res, Job.JobHistory.RESCHEDULED);
    }

    private void processJob(Task task, Implementation<?> impl, Worker<?> res, Job.JobHistory history) {
        try {
            JobStatusListener listener = new JobStatusListener(res, task, this);
            Job<?> job = res.newJob(task.getId(), task.getTaskParams(), impl, listener);
            job.setHistory(history);
            if (task.getEnforcingData() != null && !task.isSchedulingStrongForced()) {
                this.enfDataToService.put(task.getEnforcingData().getDataId(), res);
            }
            logger.info((history == Job.JobHistory.NEW ? "New" : "Rescheduled") + " Job " + job.getJobId() + " (Task: " + task.getId() + ")");
            logger.info("  * Method name: " + task.getTaskParams().getName());
            logger.info("  * Target host: " + res.getName());
            this.checkTransfers(job, task, res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkTransfers(Job<?> job, Task task, Worker<?> res) {
        Parameter[] params = job.getTaskParams().getParameters();
        JobTransfersListener listener = new JobTransfersListener(job, task, res, this);
        job.setTransferGroupId(listener.getId());
        for (Parameter p : params) {
            logger.debug("    * " + p);
            if (!(p instanceof DependencyParameter)) continue;
            DependencyParameter dp = (DependencyParameter)p;
            if (job.getKind() == Job.JobKind.SERVICE && dp.getDirection() == ITExecution.ParamDirection.INOUT) continue;
            this.transferJobData(dp, res, listener);
        }
        listener.enable();
    }

    private void transferJobData(DependencyParameter param, Worker<?> targetResource, JobTransfersListener listener) {
        DataAccessId access = param.getDataAccessId();
        if (access instanceof DataAccessId.WAccessId) {
            String tgtName = ((DataAccessId.WAccessId)access).getWrittenDataInstance().getRenaming();
            if (debug) {
                logger.debug("Setting data target job transfer: " + targetResource.getCompleteRemotePath(param.getType(), tgtName));
            }
            param.setDataTarget(targetResource.getCompleteRemotePath(param.getType(), tgtName));
            return;
        }
        listener.addOperation();
        if (access instanceof DataAccessId.RAccessId) {
            String srcName = ((DataAccessId.RAccessId)access).getReadDataInstance().getRenaming();
            targetResource.getData(srcName, srcName, (Transferable)param, (DataOperation.EventListener)listener);
        } else {
            String srcName = ((DataAccessId.RWAccessId)access).getReadDataInstance().getRenaming();
            String tgtName = ((DataAccessId.RWAccessId)access).getWrittenDataInstance().getRenaming();
            targetResource.getData(srcName, tgtName, (LogicalData)null, (Transferable)param, (DataOperation.EventListener)listener);
        }
    }

    public void failedTransfers(Job<?> job, Task task, int failedtransfers, Worker<?> res) {
        if (debug) {
            logger.debug("Received a notification for the transfers of job " + job.getJobId() + " with state FAILED");
        }
        int implId = job.getImplementation().getImplementationId();
        if (job.getHistory() == Job.JobHistory.RESCHEDULED) {
            if (debug) {
                logger.debug("Error staging in job files: " + failedtransfers + " transfers failed.");
            }
            task.setStatus(Task.TaskState.FAILED);
            this.TP.notifyTaskEnd(task, implId, res);
        } else if (job.getHistory() == Job.JobHistory.RESUBMITTED_FILES) {
            if (debug) {
                logger.debug("Asking for reschedule of job " + job.getJobId() + " since " + failedtransfers + " transfers failed.");
            }
            this.TD.rescheduleJob(task, implId, res);
        } else {
            if (debug) {
                logger.debug("Resubmitting input files of job " + job.getJobId() + " to host " + job.getResource().getName() + " since " + failedtransfers + " transfers failed.");
            }
            job.setHistory(Job.JobHistory.RESUBMITTED_FILES);
            this.checkTransfers(job, task, res);
        }
    }

    public void submitJob(Job<?> job, Worker<?> host) {
        if (debug) {
            logger.debug("Received a notification for the transfers of job " + job.getJobId() + " with state DONE");
        }
        if (presched) {
            if (host.tryAcquirePreschSlot()) {
                this.jd.dispatch(job);
            } else {
                if (debug) {
                    logger.debug("Prescheduling job " + job.getJobId() + " at host " + host + ", now pending");
                }
                host.addPendingJob(job);
            }
        } else {
            this.jd.dispatch(job);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void completedJob(Job<?> job, Task task, Worker<?> host) {
        int jobId = job.getJobId();
        logger.info("Received a notification for job " + jobId + " with state OK");
        block5: for (Parameter p : job.getTaskParams().getParameters()) {
            if (!(p instanceof DependencyParameter)) continue;
            DataInstanceId dId = null;
            DependencyParameter dp = (DependencyParameter)p;
            switch (p.getDirection()) {
                case IN: {
                    continue block5;
                }
                case OUT: {
                    dId = ((DataAccessId.WAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                    break;
                }
                case INOUT: {
                    dId = ((DataAccessId.RWAccessId)dp.getDataAccessId()).getWrittenDataInstance();
                    if (job.getKind() == Job.JobKind.SERVICE) continue block5;
                }
            }
            String name = dId.getRenaming();
            if (job.getKind() == Job.JobKind.METHOD) {
                DataLocation outLoc = DataLocation.getLocation(host, dp.getDataTarget());
                if (debug) {
                    logger.debug("Target data is: " + dp.getDataTarget() + "location: " + outLoc.getType().toString());
                }
                Comm.registerLocation(name, outLoc);
                continue;
            }
            Object value = job.getReturnValue();
            Comm.registerValue(name, value);
        }
        task.setStatus(Task.TaskState.FINISHED);
        this.TP.notifyTaskEnd(task, job.getImplementation().getImplementationId(), host);
        if (presched) {
            this.checkPending(host);
        }
    }

    public void failedJob(Job<?> job, Task task, Job.JobListener.JobEndStatus endStatus, Worker<?> host) {
        int jobId = job.getJobId();
        Implementation<?> impl = job.getImplementation();
        String hostName = host.getName();
        logger.info("Received a notification for job " + jobId + " with state FAILED");
        String taskName = task.getTaskParams().getName();
        String taskWithIdPrefix = "Task '" + taskName + "' with job id " + jobId;
        switch (job.getHistory()) {
            case NEW: {
                ErrorManager.warn(taskWithIdPrefix + " FAILED in worker '" + hostName + "'.\nResubmitting job to same worker.");
                job.setHistory(Job.JobHistory.RESUBMITTED);
                this.jd.dispatch(job);
                break;
            }
            case RESUBMITTED_FILES: {
                ErrorManager.warn(taskWithIdPrefix + " FAILED in worker '" + hostName + "'.\nResubmitting job to same worker.");
                job.setHistory(Job.JobHistory.RESUBMITTED);
                this.jd.dispatch(job);
                break;
            }
            case RESUBMITTED: {
                ErrorManager.warn(taskWithIdPrefix + " FAILED in worker '" + hostName + "' after resubmit.\nRescheduling job. (Changing worker)");
                this.TD.rescheduleJob(task, impl.getImplementationId(), host);
                if (!presched) break;
                this.checkPending(host);
                break;
            }
            case RESCHEDULED: {
                task.setStatus(Task.TaskState.FAILED);
                this.TP.notifyTaskEnd(task, impl.getImplementationId(), host);
                if (presched) {
                    this.checkPending(host);
                }
                ErrorManager.warn("Task FAILED again after rescheduling to worker '" + hostName + "'.\n");
                JobManager.notifyJobErrorAndShutdown(taskName, jobId);
            }
        }
    }

    public static void notifyJobErrorAndShutdown(String taskName, int jobId) {
        String errorFilepath = Comm.appHost.getJobsDirPath() + "job" + jobId + "_[NEW|RESUBMITTED|RESCHEDULED].[out|err]";
        ErrorManager.error("Task '" + taskName + "' TOTALLY FAILED.\n" + "Possible causes:\n" + "     -Exception thrown by task '" + taskName + "'.\n" + "     -Expected output files not generated by task '" + taskName + "'.\n" + "     -Could not provide nor retrieve needed data between master and worker.\n" + "\n" + "Check files '" + errorFilepath + "' to find out the error.\n \n");
    }

    private void checkPending(Worker<?> host) {
        Job<?> preschedJob = host.getPendingJob();
        if (preschedJob != null) {
            if (debug) {
                logger.debug("Putting in queue the prescheduled job " + preschedJob.getJobId() + " for host " + host);
            }
            this.jd.dispatch(preschedJob);
        } else {
            host.releasePreschSlot();
        }
    }

    private class JobDispatcher {
        protected RequestQueue<Job<?>> queue = new RequestQueue();
        private ThreadPool pool;
        private static final String THREAD_POOL_ERR = "Error starting pool of threads";
        private static final String SUBMISSION_ERROR = "Error submitting job ";

        public JobDispatcher(int poolSize, String poolName) {
            this.pool = new ThreadPool(poolSize, poolName, new JobSubmitter(this.queue));
            try {
                this.pool.startThreads();
            }
            catch (Exception e) {
                ErrorManager.fatal(THREAD_POOL_ERR, e);
            }
        }

        public void dispatch(Job<?> job) {
            this.queue.enqueue(job);
        }

        public void stop() {
            try {
                this.pool.stopThreads();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        class JobSubmitter
        extends RequestDispatcher<Job<?>> {
            public JobSubmitter(RequestQueue<Job<?>> queue) {
                super(queue);
            }

            @Override
            public void processRequests() {
                Job job;
                while ((job = (Job)this.queue.dequeue()) != null) {
                    try {
                        job.submit();
                        if (!debug) continue;
                        logger.debug("Job " + job.getJobId() + " submitted");
                    }
                    catch (Exception ex) {
                        logger.error(JobDispatcher.SUBMISSION_ERROR + job.getJobId(), ex);
                        job.getListener().jobFailed(job, Job.JobListener.JobEndStatus.SUBMISSION_FAILED);
                    }
                }
            }
        }
    }
}

