/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.components.impl;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.components.impl.AccessProcessor;
import integratedtoolkit.components.impl.JobManager;
import integratedtoolkit.components.impl.TaskScheduler;
import integratedtoolkit.components.scheduler.impl.DefaultTaskScheduler;
import integratedtoolkit.types.Task;
import integratedtoolkit.types.request.exceptions.ShutdownException;
import integratedtoolkit.types.request.td.CERegistration;
import integratedtoolkit.types.request.td.GetCurrentScheduleRequest;
import integratedtoolkit.types.request.td.MonitoringDataRequest;
import integratedtoolkit.types.request.td.NewWaitingTaskRequest;
import integratedtoolkit.types.request.td.NotifyTaskEndRequest;
import integratedtoolkit.types.request.td.RescheduleTaskRequest;
import integratedtoolkit.types.request.td.ScheduleTasksRequest;
import integratedtoolkit.types.request.td.ShutdownRequest;
import integratedtoolkit.types.request.td.TDRequest;
import integratedtoolkit.types.request.td.UpdateLocalCEIRequest;
import integratedtoolkit.types.request.td.WorkerUpdateRequest;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.util.CEIParser;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.ResourceManager;
import integratedtoolkit.util.Tracer;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class TaskDispatcher
implements Runnable,
ResourceUser {
    protected AccessProcessor accessProcessor;
    protected TaskScheduler scheduler;
    protected JobManager jobManager;
    protected LinkedBlockingDeque<TDRequest> requestQueue = new LinkedBlockingDeque();
    protected Thread dispatcher = new Thread(this);
    protected boolean keepGoing;
    private boolean endRequested = false;
    private int[] taskCountToEnd;
    protected static final Logger logger = Logger.getLogger("integratedtoolkit.Components.TaskDispatcher");
    protected static final boolean debug = logger.isDebugEnabled();
    private static final String RES_LOAD_ERR = "Error loading resource information";
    private static final String CREAT_INIT_VM_ERR = "Error creating initial VMs";
    protected static boolean tracing = System.getProperty("it.tracing") != null && Integer.parseInt(System.getProperty("it.tracing")) > 0;

    public TaskDispatcher() {
        this.dispatcher.setName("Task Dispatcher");
        CEIParser.parse();
        try {
            ResourceManager.load(this);
        }
        catch (ClassNotFoundException e) {
            ErrorManager.fatal(CREAT_INIT_VM_ERR, e);
        }
        catch (Exception e) {
            ErrorManager.fatal(RES_LOAD_ERR, e);
        }
        try {
            String schedulerPath = System.getProperty("it.scheduler");
            if (schedulerPath == null || schedulerPath.compareTo("default") == 0) {
                this.scheduler = new DefaultTaskScheduler();
            } else {
                Class<?> conClass = Class.forName(schedulerPath);
                Constructor<?> ctor = conClass.getDeclaredConstructors()[0];
                this.scheduler = (TaskScheduler)ctor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            ErrorManager.fatal(CREAT_INIT_VM_ERR, e);
        }
        this.jobManager = new JobManager();
        this.taskCountToEnd = new int[CoreManager.getCoreCount()];
        this.keepGoing = true;
        if (Tracer.basicModeEnabled()) {
            Tracer.enablePThreads();
        }
        this.dispatcher.start();
        if (Tracer.basicModeEnabled()) {
            Tracer.disablePThreads();
        }
        logger.info("Initialization finished");
    }

    public void setTP(AccessProcessor TP) {
        this.accessProcessor = TP;
        this.scheduler.setCoWorkers(this.jobManager);
        this.jobManager.setCoWorkers(TP, this);
    }

    @Override
    public void run() {
        while (this.keepGoing) {
            try {
                TDRequest request = this.requestQueue.take();
                this.dispatchRequest(request);
            }
            catch (InterruptedException ie) {
            }
            catch (ShutdownException se) {
                logger.debug("Exiting dispatcher because of shutting down");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addRequest(TDRequest request) {
        this.requestQueue.offer(request);
    }

    private void addPrioritaryRequest(TDRequest request) {
        this.requestQueue.offerFirst(request);
    }

    protected void dispatchRequest(TDRequest request) throws Exception {
        switch (request.getRequestType()) {
            case SCHEDULE_TASKS: {
                if (tracing) {
                    Tracer.masterEventStart(Tracer.Event.SCHEDULE_TASK.getId());
                }
                ScheduleTasksRequest stRequest = (ScheduleTasksRequest)request;
                List<Task> toSchedule = stRequest.getToSchedule();
                for (Task currentTask : toSchedule) {
                    int coreID = currentTask.getTaskParams().getId();
                    if (debug) {
                        logger.debug("Treating Scheduling request for task " + currentTask.getId() + "(core " + coreID + ")");
                    }
                    int n = coreID;
                    this.taskCountToEnd[n] = this.taskCountToEnd[n] + 1;
                    currentTask.setStatus(Task.TaskState.TO_SCHEDULE);
                    this.scheduler.scheduleTask(currentTask);
                }
                if (!tracing) break;
                Tracer.masterEventFinish();
                break;
            }
            case FINISHED_TASK: {
                int coreId;
                if (tracing) {
                    Tracer.masterEventStart(Tracer.Event.FINISHED_TASK.getId());
                }
                NotifyTaskEndRequest nte = (NotifyTaskEndRequest)request;
                Task task = nte.getTask();
                int implId = nte.getImplementationId();
                Worker<?> resource = nte.getWorker();
                int n = coreId = task.getTaskParams().getId().intValue();
                this.taskCountToEnd[n] = this.taskCountToEnd[n] - 1;
                this.scheduler.taskEnd(task, resource, implId);
                resource.endTask(CoreManager.getCoreImplementations(coreId)[implId].getRequirements());
                if (this.scheduler.scheduleToResource(resource) || this.endRequested) {
                    // empty if block
                }
                if (!tracing) break;
                Tracer.masterEventFinish();
                break;
            }
            case RESCHEDULE_TASK: {
                if (tracing) {
                    Tracer.masterEventStart(Tracer.Event.RESCHEDULE_TASK.getId());
                }
                RescheduleTaskRequest rqr = (RescheduleTaskRequest)request;
                Task task = rqr.getTask();
                int coreId = task.getTaskParams().getId();
                int taskId = task.getId();
                int implId = rqr.getImplementationId();
                Worker<?> resource = rqr.getResource();
                if (debug) {
                    logger.debug("Reschedule: Task " + taskId + " failed to run in " + resource.getName());
                }
                this.scheduler.taskEnd(task, resource, implId);
                resource.endTask(CoreManager.getCoreImplementations(coreId)[implId].getRequirements());
                this.scheduler.scheduleToResource(resource);
                if (!this.scheduler.rescheduleTask(task, resource)) {
                    task.setLastResource(resource.getName());
                }
                if (!tracing) break;
                Tracer.masterEventFinish();
                break;
            }
            case NEW_WAITING_TASK: {
                if (tracing) {
                    Tracer.masterEventStart(Tracer.Event.NEW_WAITING_TASK.getId());
                }
                NewWaitingTaskRequest nwtRequest = (NewWaitingTaskRequest)request;
                if (!tracing) break;
                Tracer.masterEventFinish();
                break;
            }
            case DEBUG: {
                if (!tracing) break;
                Tracer.masterEventStart(Tracer.Event.DEBUG_TASK.getId());
                Tracer.masterEventFinish();
                break;
            }
            default: {
                if (tracing) {
                    Tracer.masterEventStart(Tracer.Event.DEFAULT_TASK.getId());
                    Tracer.masterEventFinish();
                }
                request.process(this.scheduler, this.jobManager);
            }
        }
    }

    public void scheduleTasks(List<Task> toSchedule, boolean waiting, int[] waitingCount) {
        if (debug) {
            StringBuilder sb = new StringBuilder("Schedule tasks: ");
            for (Task t : toSchedule) {
                sb.append(t.getTaskParams().getName()).append("(").append(t.getId()).append(") ");
            }
            logger.debug(sb);
        }
        this.addRequest(new ScheduleTasksRequest(toSchedule, waiting, waitingCount));
    }

    public void notifyJobEnd(Task task, int implId, Worker<?> resource) {
        this.addRequest(new NotifyTaskEndRequest(task, implId, resource));
    }

    public void rescheduleJob(Task task, int implId, Worker<?> failedResource) {
        task.setStatus(Task.TaskState.TO_RESCHEDULE);
        this.addRequest(new RescheduleTaskRequest(task, implId, failedResource));
    }

    public void newWaitingTask(int methodId) {
        this.addRequest(new NewWaitingTaskRequest(methodId));
    }

    @Override
    public ResourceUser.WorkloadStatus getWorkload() {
        Semaphore sem = new Semaphore(0);
        GetCurrentScheduleRequest request = new GetCurrentScheduleRequest(sem);
        this.addPrioritaryRequest(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return request.getResponse();
    }

    public String getCurrentMonitoringData() {
        Semaphore sem = new Semaphore(0);
        MonitoringDataRequest request = new MonitoringDataRequest(sem);
        this.addRequest(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return request.getResponse();
    }

    @Override
    public void createdResources(Worker<?> r) {
        WorkerUpdateRequest request = new WorkerUpdateRequest(r);
        this.addPrioritaryRequest(request);
    }

    public void addInterface(Class<?> forName) {
        if (debug) {
            logger.debug("Updating CEI " + forName.getName());
        }
        Semaphore sem = new Semaphore(0);
        this.addRequest(new UpdateLocalCEIRequest(forName, sem));
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (debug) {
            logger.debug("Updated CEI " + forName.getName());
        }
    }

    public void registerCEI(String signature, String declaringClass, MethodResourceDescription constraints) {
        if (debug) {
            logger.debug("Registering CEI");
        }
        Semaphore sem = new Semaphore(0);
        this.addRequest(new CERegistration(signature, declaringClass, constraints, sem));
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (debug) {
            logger.debug("Registered CEI");
        }
    }

    public void shutdown() {
        Semaphore sem = new Semaphore(0);
        ShutdownRequest request = new ShutdownRequest(sem);
        this.addRequest(request);
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

