/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources.description;

import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.annotations.Constraints;
import integratedtoolkit.types.resources.MethodResourceDescription;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;

public class CloudMethodResourceDescription
extends MethodResourceDescription {
    public static final CloudMethodResourceDescription EMPTY = new CloudMethodResourceDescription();
    private String name;
    private String type;
    private CloudImageDescription image;
    private String providerName;
    int slots = 0;
    private Float value = Float.valueOf(0.0f);

    public CloudMethodResourceDescription() {
    }

    public CloudMethodResourceDescription(Constraints constraints) {
        super(constraints);
    }

    public CloudMethodResourceDescription(MethodResourceDescription constraints) {
        super(constraints);
    }

    public CloudMethodResourceDescription(CloudMethodResourceDescription clone) {
        super(clone);
        this.name = clone.name;
        this.type = clone.type;
        this.image = clone.image;
        this.providerName = clone.providerName;
    }

    public CloudMethodResourceDescription(Node n) {
        this.name = n.getAttributes().getNamedItem("Name").getTextContent();
        this.hostQueue = new LinkedList();
        this.appSoftware = new LinkedList();
        this.type = this.name;
        for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
            Node capabilities = n.getChildNodes().item(i);
            if (capabilities.getNodeName().compareTo("#text") == 0) continue;
            if (capabilities.getNodeName().compareTo("Capabilities") == 0) {
                for (int j = 0; j < capabilities.getChildNodes().getLength(); ++j) {
                    int k;
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("#text") == 0) continue;
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("Host") == 0) {
                        Node host = capabilities.getChildNodes().item(j);
                        for (k = 0; k < host.getChildNodes().getLength(); ++k) {
                            if (host.getChildNodes().item(k).getNodeName().compareTo("#text") == 0 || host.getChildNodes().item(k).getNodeName().compareTo("TaskCount") == 0 || host.getChildNodes().item(k).getNodeName().compareTo("Queue") != 0) continue;
                            this.hostQueue.add(host.getChildNodes().item(k).getTextContent());
                        }
                        continue;
                    }
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("Processor") == 0) {
                        Node processor = capabilities.getChildNodes().item(j);
                        for (k = 0; k < processor.getChildNodes().getLength(); ++k) {
                            if (processor.getChildNodes().item(k).getNodeName().compareTo("#text") == 0) continue;
                            if (processor.getChildNodes().item(k).getNodeName().compareTo("Architecture") == 0) {
                                this.processorArchitecture = processor.getChildNodes().item(k).getTextContent();
                                continue;
                            }
                            if (processor.getChildNodes().item(k).getNodeName().compareTo("CPUCount") == 0) {
                                this.processorCPUCount = Integer.parseInt(processor.getChildNodes().item(k).getTextContent());
                                continue;
                            }
                            if (processor.getChildNodes().item(k).getNodeName().compareTo("CoreCount") == 0) {
                                this.processorCoreCount = Integer.parseInt(processor.getChildNodes().item(k).getTextContent());
                                if (this.processorCPUCount != 0) continue;
                                this.processorCPUCount = 1;
                                continue;
                            }
                            if (processor.getChildNodes().item(k).getNodeName().compareTo("Speed") != 0) continue;
                            this.processorSpeed = Float.parseFloat(processor.getChildNodes().item(k).getTextContent());
                        }
                        continue;
                    }
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("OS") == 0) {
                        Node OS = capabilities.getChildNodes().item(j);
                        for (k = 0; k < OS.getChildNodes().getLength(); ++k) {
                            if (OS.getChildNodes().item(k).getNodeName().compareTo("#text") == 0 || OS.getChildNodes().item(k).getNodeName().compareTo("OSType") != 0) continue;
                            this.operatingSystemType = OS.getChildNodes().item(k).getTextContent();
                        }
                        continue;
                    }
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("StorageElement") == 0) {
                        Node storageElement = capabilities.getChildNodes().item(j);
                        for (k = 0; k < storageElement.getChildNodes().getLength(); ++k) {
                            if (storageElement.getChildNodes().item(k).getNodeName().compareTo("#text") == 0) continue;
                            if (storageElement.getChildNodes().item(k).getNodeName().compareTo("Size") == 0) {
                                this.storageElemSize = Float.parseFloat(storageElement.getChildNodes().item(k).getTextContent());
                                continue;
                            }
                            if (storageElement.getChildNodes().item(k).getNodeName().compareTo("AccessTime") == 0) {
                                this.storageElemAccessTime = Float.parseFloat(storageElement.getChildNodes().item(k).getTextContent());
                                continue;
                            }
                            if (storageElement.getChildNodes().item(k).getNodeName().compareTo("STR") != 0) continue;
                            this.storageElemSTR = Float.parseFloat(storageElement.getChildNodes().item(k).getTextContent());
                        }
                        continue;
                    }
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("Memory") == 0) {
                        Node memory = capabilities.getChildNodes().item(j);
                        for (k = 0; k < memory.getChildNodes().getLength(); ++k) {
                            if (memory.getChildNodes().item(k).getNodeName().compareTo("#text") == 0) continue;
                            if (memory.getChildNodes().item(k).getNodeName().compareTo("PhysicalSize") == 0) {
                                this.memoryPhysicalSize = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
                                continue;
                            }
                            if (memory.getChildNodes().item(k).getNodeName().compareTo("VirtualSize") == 0) {
                                this.memoryVirtualSize = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
                                continue;
                            }
                            if (memory.getChildNodes().item(k).getNodeName().compareTo("AccessTime") == 0) {
                                this.memoryAccessTime = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
                                continue;
                            }
                            if (memory.getChildNodes().item(k).getNodeName().compareTo("STR") != 0) continue;
                            this.memorySTR = Float.parseFloat(memory.getChildNodes().item(k).getTextContent());
                        }
                        continue;
                    }
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("ApplicationSoftware") == 0) {
                        Node apps = capabilities.getChildNodes().item(j);
                        for (k = 0; k < apps.getChildNodes().getLength(); ++k) {
                            if (apps.getChildNodes().item(k).getNodeName().compareTo("#text") == 0) continue;
                            Node soft = capabilities.getChildNodes().item(j);
                            for (int app = 0; app < soft.getChildNodes().getLength(); ++app) {
                                this.appSoftware.add(soft.getChildNodes().item(app).getTextContent());
                            }
                        }
                        continue;
                    }
                    if (capabilities.getChildNodes().item(j).getNodeName().compareTo("Service") != 0 && capabilities.getChildNodes().item(j).getNodeName().compareTo("VO") != 0 && capabilities.getChildNodes().item(j).getNodeName().compareTo("Cluster") != 0 && capabilities.getChildNodes().item(j).getNodeName().compareTo("FileSystem") != 0 && capabilities.getChildNodes().item(j).getNodeName().compareTo("NetworkAdaptor") != 0 && capabilities.getChildNodes().item(j).getNodeName().compareTo("JobPolicy") != 0 && capabilities.getChildNodes().item(j).getNodeName().compareTo("AccessControlPolicy") != 0) continue;
                }
                continue;
            }
            if (capabilities.getNodeName().compareTo("Price") != 0) continue;
            this.value = Float.valueOf(Float.parseFloat(capabilities.getTextContent()));
        }
    }

    @Override
    public int getSlots() {
        return this.slots;
    }

    @Override
    public void setSlots(int qty) {
        this.slots = qty;
    }

    @Override
    public void addSlot() {
        ++this.slots;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getProcessorArchitecture() {
        return this.processorArchitecture;
    }

    @Override
    public void setProcessorArchitecture(String Architecture) {
        this.processorArchitecture = Architecture;
    }

    @Override
    public int getProcessorCPUCount() {
        return this.processorCPUCount;
    }

    @Override
    public void setProcessorCPUCount(int count) {
        this.processorCPUCount = count;
    }

    @Override
    public int getProcessorCoreCount() {
        return this.processorCoreCount;
    }

    @Override
    public void setProcessorCoreCount(int count) {
        this.processorCoreCount = count;
    }

    @Override
    public float getProcessorSpeed() {
        return this.processorSpeed;
    }

    @Override
    public void setProcessorSpeed(float GHz) {
        this.processorSpeed = GHz;
    }

    @Override
    public float getMemoryPhysicalSize() {
        return this.memoryPhysicalSize;
    }

    @Override
    public void setMemoryPhysicalSize(float GB) {
        this.memoryPhysicalSize = GB;
    }

    @Override
    public float getMemoryVirtualSize() {
        return this.memoryVirtualSize;
    }

    @Override
    public void setMemoryVirtualSize(float GB) {
        this.memoryVirtualSize = GB;
    }

    @Override
    public float getMemoryAccessTime() {
        return this.memoryAccessTime;
    }

    @Override
    public void setMemoryAccessTime(float ns) {
        this.memoryAccessTime = ns;
    }

    @Override
    public float getMemorySTR() {
        return this.memorySTR;
    }

    @Override
    public void setMemorySTR(float GBs) {
        this.memorySTR = GBs;
    }

    @Override
    public float getStorageElemSize() {
        return this.storageElemSize;
    }

    @Override
    public void setStorageElemSize(float GB) {
        this.storageElemSize = GB;
    }

    @Override
    public float getStorageElemAccessTime() {
        return this.storageElemAccessTime;
    }

    @Override
    public void setStorageElemAccessTime(float ms) {
        this.storageElemAccessTime = ms;
    }

    @Override
    public float getStorageElemSTR() {
        return this.storageElemSTR;
    }

    @Override
    public void setStorageElemSTR(float MBs) {
        this.storageElemSTR = MBs;
    }

    @Override
    public List<String> getHostQueue() {
        return this.hostQueue;
    }

    @Override
    public void setHostQueue(List<String> hostQueue) {
        this.hostQueue = new LinkedList<String>(hostQueue);
    }

    @Override
    public void addHostQueue(String queue) {
        this.hostQueue.add(queue);
    }

    @Override
    public String getOperatingSystemType() {
        return this.operatingSystemType;
    }

    @Override
    public void setOperatingSystemType(String OSType) {
        this.operatingSystemType = OSType;
    }

    @Override
    public List<String> getAppSoftware() {
        return this.appSoftware;
    }

    @Override
    public void setAppSoftware(List<String> appSoftware) {
        this.appSoftware = new LinkedList<String>(appSoftware);
    }

    @Override
    public void resetAppSoftware() {
        this.appSoftware = new LinkedList();
    }

    @Override
    public void addAppSoftware(String software) {
        this.appSoftware.add(software);
    }

    public CloudImageDescription getImage() {
        return this.image;
    }

    public void setImage(CloudImageDescription image) {
        this.image = image;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Float getValue() {
        return this.value;
    }

    @Override
    public void setValue(float value) {
        this.value = Float.valueOf(value);
    }

    public void join(CloudMethodResourceDescription mr2) {
        int i;
        this.processorCPUCount = Math.max(this.processorCPUCount, mr2.processorCPUCount);
        this.processorCoreCount = Math.max(this.processorCoreCount, mr2.processorCoreCount);
        this.processorSpeed = Math.max(this.processorSpeed, mr2.processorSpeed);
        this.memoryPhysicalSize = Math.max(this.memoryPhysicalSize, mr2.memoryPhysicalSize);
        this.memoryVirtualSize = Math.max(this.memoryVirtualSize, mr2.memoryVirtualSize);
        this.memoryAccessTime = Math.max(this.memoryAccessTime, mr2.memoryAccessTime);
        this.memorySTR = Math.max(this.memorySTR, mr2.memorySTR);
        this.storageElemSize = Math.max(this.storageElemSize, mr2.storageElemSize);
        this.storageElemAccessTime = Math.max(this.storageElemAccessTime, mr2.storageElemAccessTime);
        this.storageElemSTR = Math.max(this.storageElemSTR, mr2.storageElemSTR);
        if (this.processorArchitecture.compareTo("[unassigned]") == 0) {
            this.processorArchitecture = mr2.processorArchitecture;
        }
        if (this.operatingSystemType.compareTo("[unassigned]") == 0) {
            this.operatingSystemType = mr2.operatingSystemType;
        }
        for (i = 0; i < mr2.hostQueue.size(); ++i) {
            if (this.hostQueue.contains(mr2.hostQueue.get(i))) continue;
            this.hostQueue.add(mr2.hostQueue.get(i));
        }
        for (i = 0; i < mr2.appSoftware.size(); ++i) {
            if (this.appSoftware.contains(mr2.appSoftware.get(i))) continue;
            this.appSoftware.add(mr2.appSoftware.get(i));
        }
        this.slots += mr2.slots;
    }

    public float difference(CloudMethodResourceDescription mr2) {
        float processor_dif = this.processorCoreCount - mr2.processorCoreCount;
        float memory_dif = this.memoryPhysicalSize - mr2.memoryPhysicalSize;
        return processor_dif * 10000.0f + memory_dif;
    }

    public boolean contains(CloudMethodResourceDescription rc2) {
        return !(this.operatingSystemType.compareTo(rc2.operatingSystemType) != 0 && this.operatingSystemType.compareTo("[unassigned]") != 0 && "[unassigned]".compareTo(rc2.operatingSystemType) != 0 || this.processorArchitecture.compareTo(rc2.processorArchitecture) != 0 && this.processorArchitecture.compareTo("[unassigned]") != 0 && "[unassigned]".compareTo(rc2.processorArchitecture) != 0 || !this.hostQueue.containsAll(rc2.hostQueue) || !this.appSoftware.containsAll(rc2.appSoftware) || this.processorCoreCount < rc2.processorCoreCount || this.processorCPUCount < rc2.processorCPUCount || this.processorSpeed < rc2.processorSpeed || this.memoryPhysicalSize < rc2.memoryPhysicalSize || this.memoryVirtualSize < rc2.memoryVirtualSize || this.memorySTR < rc2.memorySTR || this.memoryAccessTime < rc2.memoryAccessTime || this.storageElemAccessTime < rc2.storageElemAccessTime || this.storageElemSTR < rc2.storageElemSTR || this.storageElemSize < rc2.storageElemSize);
    }

    @Override
    public CloudMethodResourceDescription multiply(int amount) {
        CloudMethodResourceDescription rd = new CloudMethodResourceDescription();
        rd.processorCoreCount = this.processorCoreCount * amount;
        rd.processorCPUCount = this.processorCPUCount * amount;
        rd.memoryPhysicalSize = this.memoryPhysicalSize * (float)amount;
        rd.memoryVirtualSize = this.memoryVirtualSize * (float)amount;
        rd.storageElemSize = this.storageElemSize * (float)amount;
        return rd;
    }

    public void increase(CloudMethodResourceDescription rd) {
        this.processorCPUCount += rd.processorCPUCount;
        this.processorCoreCount += rd.processorCoreCount;
        this.memoryPhysicalSize += rd.memoryPhysicalSize;
        this.memoryVirtualSize += rd.memoryVirtualSize;
        this.storageElemSize += rd.storageElemSize;
    }

    public void reduce(CloudMethodResourceDescription rd) {
        this.processorCPUCount -= rd.processorCPUCount;
        this.processorCoreCount -= rd.processorCoreCount;
        this.memoryPhysicalSize -= rd.memoryPhysicalSize;
        this.memoryVirtualSize -= rd.memoryVirtualSize;
        this.storageElemSize -= rd.storageElemSize;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[CLOUD");
        sb.append(" PROVIDER =").append(this.providerName);
        sb.append(" IMAGE=").append(this.image == null ? "NULL" : this.image.getName());
        sb.append(" TYPE=").append(this.type);
        sb.append("]");
        return sb.toString();
    }
}

