/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.AdaptorDescription;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathResult;
import org.xml.sax.SAXException;

public class ProjectManager {
    private static Document projectDoc;
    private static XPathEvaluator evaluator;

    public static void init() throws Exception {
        String projectFile = System.getProperty("it.project.file");
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        projectDoc = docFactory.newDocumentBuilder().parse(projectFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaFile = new StreamSource(System.getProperty("it.project.schema"));
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(projectDoc));
        }
        catch (SAXException e) {
            System.err.println("Error Validating project.xml config file.\n" + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("IOError while trying to validate project.xml config file.\n" + e.getMessage());
        }
        evaluator = new XPathEvaluatorImpl(projectDoc);
        String xPathToWorkers = "/Project/Worker";
        XPathResult workerRes = (XPathResult)evaluator.evaluate(xPathToWorkers, projectDoc, null, (short)4, null);
    }

    public static TreeMap<String, AdaptorDescription> parseAdaptors() {
        TreeMap<String, AdaptorDescription> adaptorsDesc = new TreeMap<String, AdaptorDescription>();
        int[] nioPorts = new int[2];
        int[] gatPorts = new int[2];
        nioPorts = ProjectManager.getAdaptorMinMaxPort("integratedtoolkit.nio.master.NIOAdaptor", evaluator, projectDoc);
        gatPorts = ProjectManager.getAdaptorMinMaxPort("integratedtoolkit.gat.master.GATAdaptor", evaluator, projectDoc);
        adaptorsDesc.put("integratedtoolkit.nio.master.NIOAdaptor", new AdaptorDescription("integratedtoolkit.nio.master.NIOAdaptor", nioPorts[0], nioPorts[1], null));
        adaptorsDesc.put("integratedtoolkit.gat.master.GATAdaptor", new AdaptorDescription("integratedtoolkit.gat.master.GATAdaptor", gatPorts[0], gatPorts[1], null));
        return adaptorsDesc;
    }

    public static int[] getAdaptorMinMaxPort(String adaptorName, XPathEvaluator evaluator, Document projectDoc) {
        int[] ports = new int[]{-1, -1};
        String basePath = "/Project/Worker/Adaptors";
        String path = basePath + "/Adaptor[@name='" + adaptorName + "']";
        XPathResult res = (XPathResult)evaluator.evaluate(path + "/MinPort", projectDoc, null, (short)9, null);
        Node n = res.getSingleNodeValue();
        try {
            ports[0] = Integer.parseInt(n.getTextContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        res = (XPathResult)evaluator.evaluate(path + "/MaxPort", projectDoc, null, (short)9, null);
        n = res.getSingleNodeValue();
        try {
            ports[1] = Integer.parseInt(n.getTextContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ports;
    }

    public static boolean containsWorker(String name) {
        String xPathToService = "/Project/Worker[@Name='" + name + "']";
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToService, projectDoc, null, (short)9, null);
        Node n = res.getSingleNodeValue();
        return n != null;
    }

    public static HashMap<String, String> getWorkerProperties(String name) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String xPathToService = "/Project/Worker[@Name='" + name + "']";
        XPathResult worker = (XPathResult)evaluator.evaluate(xPathToService, projectDoc, null, (short)9, null);
        Node workerNode = worker.getSingleNodeValue();
        for (int j = 0; j < workerNode.getChildNodes().getLength(); ++j) {
            Node n = workerNode.getChildNodes().item(j);
            String propName = n.getNodeName();
            if (propName.compareTo("#text") == 0 || propName.compareTo("#comment") == 0) continue;
            String propValue = n.getTextContent();
            properties.put(propName, propValue);
        }
        return properties;
    }

    private static String getResourcePropertyInit(String workerName, String property) {
        String xPathToProp = "/Project/Worker[@Name='" + workerName + "']/" + property;
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToProp, projectDoc, null, (short)9, null);
        Node n = res.getSingleNodeValue();
        if (n == null) {
            return null;
        }
        return n.getTextContent();
    }

    public static boolean existsCloudProvider(String cloudName) {
        String xPathToProp = "/Project/Cloud/Provider[@name='" + cloudName + "']";
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToProp, projectDoc, null, (short)9, null);
        Node n = res.getSingleNodeValue();
        return n != null;
    }

    public static String getCloudProperty(String property) {
        String xPathToProp = "/Project/Cloud/" + property;
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToProp, projectDoc, null, (short)9, null);
        Node n = res.getSingleNodeValue();
        if (n == null) {
            return null;
        }
        return n.getTextContent();
    }

    public static Integer getCloudProviderLimitOfVMs(String cloudName) {
        String xPathToProp = "/Project/Cloud/Provider[@name='" + cloudName + "']/LimitOfVMs";
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToProp, projectDoc, null, (short)4, null);
        Node n = res.iterateNext();
        if (n != null) {
            return Integer.parseInt(n.getTextContent());
        }
        return null;
    }

    public static HashMap<String, String> getCloudProviderProperties(String cloudName) {
        String xPathToProp = "/Project/Cloud/Provider[@name='" + cloudName + "']/Property";
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToProp, projectDoc, null, (short)4, null);
        HashMap<String, String> properties = new HashMap<String, String>();
        Node n = res.iterateNext();
        while (n != null) {
            String name = "";
            String value = "";
            for (int i = 0; i < n.getChildNodes().getLength(); ++i) {
                Node child = n.getChildNodes().item(i);
                if (child.getNodeName().compareTo("Name") == 0) {
                    name = child.getTextContent();
                    continue;
                }
                if (child.getNodeName().compareTo("Value") != 0) continue;
                value = child.getTextContent();
            }
            properties.put(name, value);
            if (n.getAttributes().getNamedItem("context") != null) {
                String context = n.getAttributes().getNamedItem("context").getTextContent();
                properties.put("[context=" + context + "]" + name, value);
                if (context.compareTo("file") == 0) {
                    properties.put("[context=file]" + name, value);
                } else if (context.compareTo("job") == 0) {
                    properties.put("[context=job]" + name, value);
                } else {
                    properties.put("[context=file]" + name, value);
                    properties.put("[context=job]" + name, value);
                }
            }
            n = res.iterateNext();
        }
        return properties;
    }

    public static Node existsImageOnProvider(String cloudProvider, String imageName) {
        String xPathToProp = "/Project/Cloud/Provider[@name='" + cloudProvider + "']/ImageList/Image[@name='" + imageName + "']";
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToProp, projectDoc, null, (short)9, null);
        Node n = res.getSingleNodeValue();
        return n;
    }

    public static Node existsInstanceTypeOnProvider(String cloudProvider, String instanceName) {
        String xPathToProp = "/Project/Cloud/Provider[@name='" + cloudProvider + "']/InstanceTypes/Resource[@name='" + instanceName + "']";
        XPathResult res = (XPathResult)evaluator.evaluate(xPathToProp, projectDoc, null, (short)9, null);
        Node n = res.getSingleNodeValue();
        return n;
    }

    public static boolean isInit() {
        return projectDoc != null;
    }

    public static void refresh() throws Exception {
        String projectFile = System.getProperty("it.project.file");
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        Document tempDoc = docFactory.newDocumentBuilder().parse(projectFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaFile = new StreamSource(System.getProperty("it.project.schema"));
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(tempDoc));
        evaluator = new XPathEvaluatorImpl(tempDoc);
        projectDoc = tempDoc;
    }
}

