/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.commandlineSsh;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.CommandRunner;
import org.gridlab.gat.engine.util.SshHelper;
import org.gridlab.gat.io.File;
import org.gridlab.gat.io.FileInterface;
import org.gridlab.gat.io.cpi.FileCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandlineSshFileAdaptor
extends FileCpi {
    private static final String SSH_PORT_STRING = "commandlinessh.ssh.port";
    private static final String SSH_STRICT_HOST_KEY_CHECKING = "commandlinessh.StrictHostKeyChecking";
    public static final int SSH_PORT = 22;
    protected static Logger logger = LoggerFactory.getLogger(CommandlineSshFileAdaptor.class);
    private final URI fixedURI;
    private final SshHelper locationUtils;
    private final java.io.File localFile;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileCpi.getSupportedCapabilities();
        capabilities.put("canRead", true);
        capabilities.put("canWrite", true);
        capabilities.put("copy", true);
        capabilities.put("createNewFile", true);
        capabilities.put("delete", true);
        capabilities.put("exists", true);
        capabilities.put("getAbsolutePath", true);
        capabilities.put("getAbsoluteFile", true);
        capabilities.put("isDirectory", true);
        capabilities.put("isFile", true);
        capabilities.put("lastModified", true);
        capabilities.put("length", true);
        capabilities.put("list", true);
        capabilities.put("mkdir", true);
        capabilities.put("mkdirs", true);
        capabilities.put("setLastModified", true);
        return capabilities;
    }

    public static String getDescription() {
        return "The CommandlineSsh File Adaptor implements the File object using ssh commands.";
    }

    public static Preferences getSupportedPreferences() {
        Preferences p = FileCpi.getSupportedPreferences();
        p.put(SSH_PORT_STRING, (Object)"22");
        p.put(SSH_STRICT_HOST_KEY_CHECKING, (Object)"false");
        return p;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"commandlinessh", "ssh", "file", ""};
    }

    public CommandlineSshFileAdaptor(GATContext gatContext, URI location) throws GATObjectCreationException {
        super(gatContext, location);
        this.fixedURI = CommandlineSshFileAdaptor.fixURI((URI)location, null);
        this.localFile = this.fixedURI.isCompatible("file") && this.fixedURI.refersToLocalHost() ? new java.io.File(this.fixedURI.getPath()) : null;
        this.locationUtils = new SshHelper(gatContext, location, "commandlinessh", SSH_PORT_STRING, SSH_STRICT_HOST_KEY_CHECKING);
    }

    private boolean runSshCommand(String ... params) throws GATInvocationException {
        return this.locationUtils.runSshCommand(params).getExitCode() == 0;
    }

    public long lastModified() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.lastModified();
        }
        CommandRunner command = this.locationUtils.runSshCommand(new String[]{"stat", "-c", "%Y", this.fixedURI.getPath()});
        if (command.getExitCode() != 0) {
            if (logger.isInfoEnabled()) {
                logger.info("command failed, error = " + command.getStderr());
            }
            return 0L;
        }
        String result = command.getStdout();
        return Long.parseLong(result.replaceAll("\\s", "")) * 1000L;
    }

    private String toTouchDateFormat(long date) {
        Date d = new Date(date);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm.ss");
        return formatter.format(d);
    }

    public boolean setLastModified(long lastModified) throws GATInvocationException {
        if (!this.exists()) {
            return false;
        }
        if (this.localFile != null) {
            return this.localFile.setLastModified(lastModified);
        }
        return this.runSshCommand("touch", "-c", "-t", this.toTouchDateFormat(lastModified), this.fixedURI.getPath());
    }

    public long length() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.length();
        }
        CommandRunner command = this.locationUtils.runSshCommand(new String[]{"wc", "-c", this.fixedURI.getPath()});
        if (command.getExitCode() != 0) {
            if (logger.isInfoEnabled()) {
                logger.info("command failed, error = " + command.getStderr());
            }
            return 0L;
        }
        String result = command.getStdout();
        return Long.parseLong(result.replaceAll(" .*\\s?", ""));
    }

    public String[] list() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.list();
        }
        CommandRunner command = this.locationUtils.runSshCommand(new String[]{"ls", "-1", this.fixedURI.getPath()});
        if (command.getExitCode() != 0) {
            if (logger.isInfoEnabled()) {
                logger.info("command failed, error = " + command.getStderr());
            }
            return null;
        }
        String result = command.getStdout();
        if (result == null || result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public File[] listFiles() throws GATInvocationException {
        try {
            String[] f = this.list();
            if (f == null) {
                return null;
            }
            File[] res = new File[f.length];
            for (int i = 0; i < f.length; ++i) {
                String uri = this.fixedURI.toString();
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                }
                uri = uri + f[i];
                res[i] = GAT.createFile((GATContext)this.gatContext, (URI)new URI(uri));
            }
            return res;
        }
        catch (Exception e) {
            throw new GATInvocationException("file cpi", (Throwable)e);
        }
    }

    public File getAbsoluteFile() throws GATInvocationException {
        String absUri = this.fixedURI.toString().replace(this.fixedURI.getPath(), this.getAbsolutePath());
        try {
            return GAT.createFile((GATContext)this.gatContext, (URI)new URI(absUri));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAbsolutePath() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.getAbsolutePath();
        }
        String fixed = this.fixedURI.getPath();
        if (fixed.startsWith("/")) {
            return fixed;
        }
        CommandRunner command = this.locationUtils.runSshCommand(new String[]{"echo", "~"});
        if (command.getExitCode() != 0) {
            if (logger.isInfoEnabled()) {
                logger.info("command failed, error = " + command.getStderr());
            }
            throw new GATInvocationException("Could not execute \"echo ~\"");
        }
        String result = command.getStdout();
        return result.replace("\n", "") + "/" + fixed;
    }

    public boolean mkdir() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.mkdir();
        }
        return this.runSshCommand("mkdir", this.fixedURI.getPath());
    }

    public boolean mkdirs() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.mkdirs();
        }
        return this.runSshCommand("mkdir", "-p", this.fixedURI.getPath());
    }

    public boolean createNewFile() throws GATInvocationException {
        if (this.localFile != null) {
            try {
                return this.localFile.createNewFile();
            }
            catch (IOException e) {
                throw new GATInvocationException("local createNewFile failed", (Throwable)e);
            }
        }
        if (this.exists()) {
            return false;
        }
        return this.runSshCommand("touch", this.fixedURI.getPath());
    }

    public boolean delete() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.delete();
        }
        if (!this.exists()) {
            return false;
        }
        return this.runSshCommand("rm", "-rf", this.fixedURI.getPath());
    }

    public boolean isDirectory() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.isDirectory();
        }
        return this.runSshCommand("test", "-d", this.fixedURI.getPath());
    }

    public boolean isFile() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.isFile();
        }
        return this.runSshCommand("test", "-f", this.fixedURI.getPath());
    }

    public boolean exists() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.exists();
        }
        return this.runSshCommand("/usr/bin/test", "-e", this.fixedURI.getPath());
    }

    public boolean canRead() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.canRead();
        }
        return this.runSshCommand("/usr/bin/test", "-r", this.fixedURI.getPath());
    }

    public boolean canWrite() throws GATInvocationException {
        if (this.localFile != null) {
            return this.localFile.canWrite();
        }
        return this.runSshCommand("/usr/bin/test", "-w", this.fixedURI.getPath());
    }

    public void copy(URI dest) throws GATInvocationException {
        dest = CommandlineSshFileAdaptor.fixURI((URI)dest, null);
        if (this.localFile != null && dest.isCompatible("file") && dest.refersToLocalHost()) {
            if (logger.isDebugEnabled()) {
                logger.debug("commandlineSsh file: copy local to local");
            }
            this.copyLocaltoLocal(dest);
            return;
        }
        if (dest.isCompatible("file") && dest.refersToLocalHost()) {
            if (logger.isDebugEnabled()) {
                logger.debug("commandlineSsh file: copy remote to local");
            }
            this.copyToLocal(dest);
            return;
        }
        if (this.localFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("commandlineSsh file: copy local to remote");
            }
            this.copyToRemote(dest);
            return;
        }
        throw new GATInvocationException("commandlineSsh: cannot do third party copy");
    }

    protected void copyLocaltoLocal(URI dest) throws GATInvocationException {
        int exitValue;
        java.io.File destFile;
        java.io.File destinationParentFile;
        if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true") && (destinationParentFile = (destFile = new java.io.File(dest.getPath())).getParentFile()) != null) {
            destinationParentFile.mkdirs();
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("cp");
        boolean dir = false;
        if (this.exists()) {
            if (this.isDirectory()) {
                dir = true;
            }
        } else {
            throw new GATInvocationException("the source file does not exist.");
        }
        if (dir) {
            java.io.File local = new java.io.File(dest.getPath());
            if (local.exists()) {
                if (!local.isDirectory()) {
                    throw new GATInvocationException("local destination already exists, and it is not a directory");
                }
            } else if (!local.mkdir()) {
                throw new GATInvocationException("could not create local dir");
            }
            command.add("-r");
        }
        command.add(this.getPath());
        command.add(dest.getPath());
        if (logger.isInfoEnabled()) {
            logger.info("CommandlineSsh: running command: " + command);
        }
        CommandRunner runner = new CommandRunner(command);
        if (logger.isInfoEnabled()) {
            logger.info("\nstderr: " + runner.getStderr() + "\nstdout: " + runner.getStdout());
        }
        if ((exitValue = runner.getExitCode()) != 0) {
            throw new GATInvocationException("CommandlineSsh command failed: " + runner.getStderr());
        }
    }

    protected void copyToLocal(URI dest) throws GATInvocationException {
        int exitValue;
        String username;
        if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true")) {
            try {
                FileInterface destFile = GAT.createFile((GATContext)this.gatContext, (URI)dest).getFileInterface();
                File destinationParentFile = destFile.getParentFile();
                if (destinationParentFile != null) {
                    destinationParentFile.getFileInterface().mkdirs();
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("CommandlineSshFileAdaptor", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CommandlineSsh: Prepared session for location " + this.location + "; host: " + this.location.resolveHost());
        }
        ArrayList command = this.locationUtils.getScpCommand();
        boolean dir = false;
        if (this.exists()) {
            if (this.isDirectory()) {
                dir = true;
            }
        } else {
            throw new GATInvocationException("the remote file does not exist.");
        }
        if (dir) {
            java.io.File local = new java.io.File(dest.getPath());
            if (local.exists()) {
                if (!local.isDirectory()) {
                    throw new GATInvocationException("local destination already exists, and it is not a directory");
                }
            } else if (!local.mkdir()) {
                throw new GATInvocationException("could not create local dir");
            }
            command.add("-r");
        }
        if ((username = this.locationUtils.getUserName()) != null) {
            command.add(username + "@" + this.location.resolveHost() + ":" + this.location.getPath());
        } else {
            command.add(this.location.resolveHost() + ":" + this.location.getPath());
        }
        command.add(dest.getPath());
        if (logger.isInfoEnabled()) {
            logger.info("CommandlineSsh: running command: " + command);
        }
        CommandRunner runner = new CommandRunner((List)command);
        if (logger.isInfoEnabled()) {
            logger.info("\nstderr: " + runner.getStderr() + "\nstdout: " + runner.getStdout());
        }
        if ((exitValue = runner.getExitCode()) != 0 && runner.getStderr().length() > 0) {
            throw new GATInvocationException("CommandlineSsh command failed: " + runner.getStderr());
        }
    }

    protected void copyToRemote(URI dest) throws GATInvocationException {
        int exitValue;
        SshHelper destUtils;
        if (!CommandlineSshFileAdaptor.recognizedScheme((String)dest.getScheme(), (String[])CommandlineSshFileAdaptor.getSupportedSchemes())) {
            throw new GATInvocationException("CommandlineSshFileAdaptor: unrecognized scheme");
        }
        try {
            destUtils = new SshHelper(this.gatContext, dest, "commandlinessh", SSH_PORT_STRING, SSH_STRICT_HOST_KEY_CHECKING);
        }
        catch (GATObjectCreationException e1) {
            Throwable e = e1.getCause();
            if (e1 != null) {
                throw new GATInvocationException(e1.getSuperMessage(), e);
            }
            throw new GATInvocationException(e1.getSuperMessage(), (Throwable)e1);
        }
        String username = destUtils.getUserName();
        if (this.gatContext.getPreferences().containsKey("file.create") && ((String)this.gatContext.getPreferences().get("file.create")).equalsIgnoreCase("true")) {
            try {
                FileInterface destFile = GAT.createFile((GATContext)this.gatContext, (URI)dest).getFileInterface();
                File destinationParentFile = destFile.getParentFile();
                if (destinationParentFile != null) {
                    destinationParentFile.getFileInterface().mkdirs();
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("CommandlineSshFileAdaptor", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CommandlineSsh: Prepared session for location " + dest + "; host: " + dest.resolveHost());
        }
        ArrayList command = destUtils.getScpCommand();
        if (this.determineIsDirectory()) {
            File remote = null;
            try {
                remote = GAT.createFile((GATContext)this.gatContext, (URI)dest);
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("commandlineSsh", (Throwable)e);
            }
            if (remote.getFileInterface().exists()) {
                if (!remote.getFileInterface().isDirectory()) {
                    throw new GATInvocationException("remote destination already exists, and it is not a directory");
                }
            } else if (!remote.getFileInterface().mkdir()) {
                throw new GATInvocationException("could not create remote dir");
            }
            command.add("-r");
        }
        command.add(this.location.getPath());
        if (username != null) {
            command.add(username + "@" + dest.resolveHost() + ":" + dest.getPath());
        } else {
            command.add(dest.resolveHost() + ":" + dest.getPath());
        }
        if (logger.isInfoEnabled()) {
            logger.info("CommandlineSsh: running command: " + command);
        }
        CommandRunner runner = new CommandRunner((List)command);
        if (logger.isInfoEnabled()) {
            logger.info("\nstderr: " + runner.getStderr() + "\nstdout: " + runner.getStdout());
        }
        if ((exitValue = runner.getExitCode()) != 0 && runner.getStderr().length() > 0) {
            throw new GATInvocationException("CommandlineSsh command failed: " + runner.getStderr());
        }
    }
}

