/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.commandlineSsh;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.MethodNotApplicableException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.SshHelper;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.io.File;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.ResourceBrokerCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;
import org.gridlab.gat.resources.cpi.commandlineSsh.CommandlineSshJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandlineSshResourceBrokerAdaptor
extends ResourceBrokerCpi {
    private static final String SSH_STRICT_HOST_KEY_CHECKING = "commandlinessh.StrictHostKeyChecking";
    private static final String SSH_PORT_STRING = "commandlinessh.ssh.port";
    private static final String SSH_STOPPABLE = "commandlinessh.stoppable";
    public static final int SSH_PORT = 22;
    protected static Logger logger = LoggerFactory.getLogger(CommandlineSshResourceBrokerAdaptor.class);
    private final SshHelper brokerHelper;

    public static String getDescription() {
        return "The CommandlineSsh ResourceBroker Adaptor implements the ResourceBroker object using ssh commands.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = ResourceBrokerCpi.getSupportedCapabilities();
        capabilities.put("submitJob", true);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences p = ResourceBrokerCpi.getSupportedPreferences();
        p.put(SSH_STRICT_HOST_KEY_CHECKING, (Object)"false");
        p.put(SSH_STOPPABLE, (Object)"false");
        p.put(SSH_PORT_STRING, (Object)"22");
        return p;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"commandlinessh", "ssh"};
    }

    public static void init() {
    }

    public CommandlineSshResourceBrokerAdaptor(GATContext gatContext, URI brokerURI) throws GATObjectCreationException {
        super(gatContext, brokerURI);
        this.brokerHelper = new SshHelper(gatContext, brokerURI, "commandlinessh", SSH_PORT_STRING, SSH_STRICT_HOST_KEY_CHECKING);
    }

    public Job submitJob(AbstractJobDescription abstractDescription, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        String host;
        if (!(abstractDescription instanceof JobDescription)) {
            throw new GATInvocationException("can only handle JobDescriptions: " + abstractDescription.getClass());
        }
        JobDescription description = (JobDescription)abstractDescription;
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        if (description.getProcessCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: process count > 1: " + description.getProcessCount());
        }
        if (description.getResourceCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: resource count > 1: " + description.getResourceCount());
        }
        Map env = sd.getEnvironment();
        if (env != null && !env.isEmpty()) {
            throw new MethodNotApplicableException("cannot handle environment");
        }
        String path = this.getExecutable(description);
        String authority = this.getAuthority();
        if (authority == null) {
            authority = "localhost";
        }
        if ((host = this.getHostname()) == null) {
            host = "localhost";
        }
        Sandbox sandbox = new Sandbox(this.gatContext, description, authority, null, true, false, false, false);
        try {
            StreamForwarder f;
            CommandlineSshJob commandlineSshJob = new CommandlineSshJob(this.gatContext, description, sandbox);
            CommandlineSshJob job = null;
            if (description instanceof WrapperJobDescription) {
                WrapperJobCpi tmp = new WrapperJobCpi(this.gatContext, (Job)commandlineSshJob, listener, metricDefinitionName);
                listener = tmp;
                job = tmp;
            } else {
                job = commandlineSshJob;
            }
            if (listener != null && metricDefinitionName != null) {
                Metric metric = commandlineSshJob.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
                commandlineSshJob.addMetricListener(listener, metric);
            }
            commandlineSshJob.setState(Job.JobState.PRE_STAGING);
            sandbox.prestage();
            boolean stoppable = "true".equalsIgnoreCase((String)this.gatContext.getPreferences().get(SSH_STOPPABLE));
            ArrayList command = this.brokerHelper.getSshCommand(stoppable);
            if (!sd.streamingStdinEnabled() && sd.getStdin() == null) {
                command.add("-n");
            }
            String[] args = this.getArgumentsArray(description);
            if (this.brokerHelper.onWindows()) {
                command.add("-cmd=" + SshHelper.protectAgainstShellMetas((String)path));
            } else {
                String dir = sd.getStringAttribute("directory", sandbox.getSandboxPath());
                if (dir != null) {
                    command.add("cd");
                    command.add(SshHelper.protectAgainstShellMetas((String)dir));
                    command.add("&&");
                }
                command.add(SshHelper.protectAgainstShellMetas((String)path));
            }
            Process p = this.brokerHelper.startSshCommand((List)command, args);
            commandlineSshJob.setState(Job.JobState.RUNNING);
            commandlineSshJob.setSubmissionTime();
            commandlineSshJob.setStartTime();
            commandlineSshJob.setProcess(p);
            if (!sd.streamingStderrEnabled()) {
                try {
                    if (sd.getStderr() != null) {
                        f = new StreamForwarder(p.getErrorStream(), (OutputStream)GAT.createFileOutputStream((File)sd.getStderr()));
                        commandlineSshJob.setErrorStream(f);
                    } else {
                        new StreamForwarder(p.getErrorStream(), null);
                    }
                }
                catch (GATObjectCreationException e) {
                    throw new GATInvocationException("Unable to create file output stream for stderr!", (Throwable)e);
                }
            }
            if (!sd.streamingStdoutEnabled()) {
                try {
                    if (sd.getStdout() != null) {
                        f = new StreamForwarder(p.getInputStream(), (OutputStream)GAT.createFileOutputStream((File)sd.getStdout()));
                        commandlineSshJob.setOutputStream(f);
                    } else {
                        new StreamForwarder(p.getInputStream(), null);
                    }
                }
                catch (GATObjectCreationException e) {
                    throw new GATInvocationException("Unable to create file output stream for stdout!", (Throwable)e);
                }
            }
            if (!sd.streamingStdinEnabled() && sd.getStdin() != null) {
                try {
                    new StreamForwarder((InputStream)GAT.createFileInputStream((File)sd.getStdin()), p.getOutputStream());
                }
                catch (GATObjectCreationException e) {
                    throw new GATInvocationException("Unable to create file input stream for stdin!", (Throwable)e);
                }
            }
            commandlineSshJob.monitorState();
            return job;
        }
        catch (GATInvocationException e) {
            sandbox.removeSandboxDir();
            throw e;
        }
        catch (Throwable e) {
            sandbox.removeSandboxDir();
            throw new GATInvocationException("CommandlineSsh: got exception", e);
        }
    }
}

