/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class NIOProperties {
    private static final Logger LOGGER = Logger.getLogger("Communication");
    public static final String MAX_BUFFERED_PACKETS_NAME = "MAX_BUFFERED_PACKETS";
    private static final int DEFAULT_MAX_BUFFERED_PACKETS = 10;
    public static int MAX_BUFFERED_PACKETS;
    public static final String MIN_BUFFERED_PACKETS_NAME = "MIN_BUFFERED_PACKETS";
    private static final int DEFAULT_MIN_BUFFERED_PACKETS = 5;
    public static int MIN_BUFFERED_PACKETS;
    public static final String PACKET_SIZE_NAME = "PACKET_SIZE";
    private static final int DEFAULT_PACKET_SIZE = 8192;
    public static int PACKET_SIZE;
    public static final String NETWORK_BUFFER_SIZE_NAME = "NETWORK_BUFFER_SIZE";
    private static final int DEFAULT_NETWORK_BUFFER_SIZE = 81920;
    public static int NETWORK_BUFFER_SIZE;
    public static final String MAX_SENDS_NAME = "MAX_SEND";
    private static final int DEFAULT_MAX_SENDS = Integer.MAX_VALUE;
    public static int MAX_SENDS;
    public static final String MAX_RECEIVES_NAME = "MAX_RECEIVES";
    private static final int DEFAULT_MAX_RECEIVES = Integer.MAX_VALUE;
    public static int MAX_RECEIVES;
    public static final String MAX_RETRIES_NAME = "MAX_RETRIES";
    private static final int DEFAULT_MAX_RETRIES = 5;
    public static int MAX_RETRIES;
    private static final String PROP_FILE_NAME = "nio.cfg";

    public static void importProperties() {
        System.getProperty("MAX_PACKETS_PER_TRANSFER");
    }

    public static void importProperties(String loc) {
        if (loc == null) {
            MAX_BUFFERED_PACKETS = 10;
            PACKET_SIZE = 8192;
            MIN_BUFFERED_PACKETS = 5;
            NETWORK_BUFFER_SIZE = 81920;
            MAX_SENDS = Integer.MAX_VALUE;
            MAX_RECEIVES = Integer.MAX_VALUE;
            MAX_RETRIES = 5;
        } else {
            FileInputStream inputStream;
            String path = loc + File.separator + PROP_FILE_NAME;
            try {
                inputStream = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Can not find properties file " + path);
                return;
            }
            try {
                Properties prop = new Properties();
                prop.load(inputStream);
                MAX_BUFFERED_PACKETS = Integer.parseInt(prop.getProperty(MAX_BUFFERED_PACKETS_NAME));
                MIN_BUFFERED_PACKETS = Integer.parseInt(prop.getProperty(MIN_BUFFERED_PACKETS_NAME));
                PACKET_SIZE = Integer.parseInt(prop.getProperty(PACKET_SIZE_NAME));
                NETWORK_BUFFER_SIZE = Integer.parseInt(prop.getProperty(NETWORK_BUFFER_SIZE_NAME));
                MAX_SENDS = Integer.parseInt(prop.getProperty(MAX_SENDS_NAME));
                MAX_RECEIVES = Integer.parseInt(prop.getProperty(MAX_RECEIVES_NAME));
                MAX_RETRIES = Integer.parseInt(prop.getProperty(MAX_RETRIES_NAME));
            }
            catch (IOException e) {
                LOGGER.error("Error loading properties", e);
            }
            try {
                inputStream.close();
            }
            catch (IOException ie) {
                LOGGER.error("Error closing stream", ie);
            }
        }
    }

    public static void printProperties() {
        LOGGER.info("MAX_BUFFERED_PACKETS = " + MAX_BUFFERED_PACKETS);
        LOGGER.info("MIN_BUFFERED_PACKETS = " + MIN_BUFFERED_PACKETS);
        LOGGER.info("PACKET_SIZE = " + PACKET_SIZE);
        LOGGER.info("NETWORK_BUFFER_SIZE = " + NETWORK_BUFFER_SIZE);
        LOGGER.info("MAX_BUFFERED_PACKETS = " + MAX_BUFFERED_PACKETS);
        LOGGER.info("MIN_BUFFERED_PACKETS = " + MIN_BUFFERED_PACKETS);
        LOGGER.info("PACKET_SIZE = " + PACKET_SIZE);
        LOGGER.info("NETWORK_BUFFER_SIZE = " + NETWORK_BUFFER_SIZE);
        LOGGER.info("MAX_SEND = " + MAX_SENDS);
        LOGGER.info("MAX_RECEIVES = " + MAX_RECEIVES);
        LOGGER.info("MAX_RETRIES = " + MAX_RETRIES);
    }
}

