/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway;

import com.amazonaws.AmazonClientException;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;

public class StorageGatewayUtils {
    public static String getActivationKey(String gatewayAddress) throws AmazonClientException {
        try {
            BasicHttpParams httpClientParams = new BasicHttpParams();
            httpClientParams.setBooleanParameter("http.protocol.handle-redirects", false);
            DefaultHttpClient client = new DefaultHttpClient(httpClientParams);
            HttpGet method = new HttpGet("http://" + gatewayAddress);
            HttpResponse response = client.execute(method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 302) {
                throw new AmazonClientException("Could not fetch activation key.  HTTP status code: " + statusCode);
            }
            Header[] headers = response.getHeaders("Location");
            if (headers.length < 1) {
                throw new AmazonClientException("Could not fetch activation key, no location header found");
            }
            String activationUrl = headers[0].getValue();
            String[] parts = activationUrl.split("activationKey=");
            if (parts.length < 2 || null == parts[1]) {
                throw new AmazonClientException("Unable to get activation key from : " + activationUrl);
            }
            return parts[1];
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to get activation key", ioe);
        }
    }
}

