/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.netty.WebTarget;
import com.github.dockerjava.netty.exec.AbstrAsyncDockerCmdExec;
import com.google.common.net.UrlEscapers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsCmdExec
extends AbstrAsyncDockerCmdExec<EventsCmd, Event>
implements EventsCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsCmdExec.class);

    public EventsCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected Void execute0(EventsCmd command, ResultCallback<Event> resultCallback) {
        WebTarget webTarget = this.getBaseResource().path("/events").queryParam("since", command.getSince()).queryParam("until", command.getUntil());
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters())));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        webTarget.request().get(new TypeReference<Event>(){}, resultCallback);
        return null;
    }
}

