/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.BackendService;
import org.jclouds.googlecomputeengine.domain.HealthStatus;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.BackendServiceOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface BackendServiceApi {
    @Named(value="BackendServices:get")
    @GET
    @Path(value="/{backendService}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public BackendService get(@PathParam(value="backendService") String var1);

    @Named(value="BackendServices:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) BackendServiceOptions var1);

    @Named(value="BackendServices:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{backendService}")
    public Operation update(@PathParam(value="backendService") String var1, @BinderParam(value=BindToJsonPayload.class) BackendServiceOptions var2);

    @Named(value="BackendServices:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/{backendService}")
    public Operation patch(@PathParam(value="backendService") String var1, @BinderParam(value=BindToJsonPayload.class) BackendServiceOptions var2);

    @Named(value="BackendServices:getHealth")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/{backendService}/getHealth")
    @MapBinder(value=BindToJsonPayload.class)
    public HealthStatus getHealth(@PathParam(value="backendService") String var1, @PayloadParam(value="group") URI var2);

    @Named(value="BackendServices:delete")
    @DELETE
    @Path(value="/{backendService}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="backendService") String var1);

    @Named(value="BackendServices:list")
    @GET
    public ListPage<BackendService> listPage(@QueryParam(value="pageToken") @Nullable String var1, ListOptions var2);

    @Named(value="BackendServices:list")
    @GET
    @Transform(value=BackendServicePages.class)
    public Iterator<ListPage<BackendService>> list();

    @Named(value="BackendServices:list")
    @GET
    @Transform(value=BackendServicePages.class)
    public Iterator<ListPage<BackendService>> list(ListOptions var1);

    public static final class BackendServicePages
    extends BaseToIteratorOfListPage<BackendService, BackendServicePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        BackendServicePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<BackendService>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<BackendService>>(){

                @Override
                public ListPage<BackendService> apply(String pageToken) {
                    return BackendServicePages.this.api.backendServices().listPage(pageToken, options);
                }
            };
        }
    }
}

