/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.security.sshtrilead;

import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.File;
import java.io.IOException;

public class HostKeyVerifier
implements ServerHostKeyVerifier {
    private final KnownHosts database = new KnownHosts();
    private boolean writeKnownHosts;
    private boolean strictHostKeyChecking;
    private boolean noHostKeyChecking;
    private static File knownHosts = new File(System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "known_hosts");
    private static boolean knownHostsExists = knownHosts.exists();
    private boolean knownHostsAdded = false;

    public HostKeyVerifier(boolean writeKnownHosts, boolean strictHostKeyChecking, boolean noHostKeyChecking) {
        this.writeKnownHosts = writeKnownHosts;
        this.strictHostKeyChecking = strictHostKeyChecking;
        this.noHostKeyChecking = noHostKeyChecking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
        if (this.noHostKeyChecking) {
            return true;
        }
        if (knownHostsExists) {
            HostKeyVerifier hostKeyVerifier = this;
            synchronized (hostKeyVerifier) {
                if (!this.knownHostsAdded) {
                    this.knownHostsAdded = true;
                    try {
                        this.database.addHostkeys(knownHosts);
                    }
                    catch (IOException e) {
                        this.writeKnownHosts = false;
                    }
                }
            }
        }
        int result = this.database.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
        switch (result) {
            case 0: {
                return true;
            }
            case 1: {
                if (this.strictHostKeyChecking) {
                    return false;
                }
                String[] hostnames = new String[]{hostname};
                this.database.addHostkey(hostnames, serverHostKeyAlgorithm, serverHostKey);
                if (this.writeKnownHosts) {
                    KnownHosts.addHostkeyToFile((File)knownHosts, (String[])hostnames, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
                }
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }
}

