/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import benchmarks.AdaptorTestResult;
import benchmarks.AdaptorTestResultEntry;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInputStream;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.ResourceBroker;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.security.PasswordSecurityContext;
import org.gridlab.gat.security.SecurityContext;

public class FileInputStreamAdaptorTest {
    public static void main(String[] args) {
        FileInputStreamAdaptorTest a = new FileInputStreamAdaptorTest();
        a.test(args[0], args[1]).print();
        GAT.end();
    }

    public AdaptorTestResult test(String adaptor, String host) {
        this.run(host, "fileinputstream-adaptor-test-init.sh");
        AdaptorTestResult adaptorTestResult = new AdaptorTestResult(adaptor, host);
        GATContext gatContext = new GATContext();
        PasswordSecurityContext password = new PasswordSecurityContext("username", "TeMpPaSsWoRd");
        password.addNote("adaptors", "ftp");
        gatContext.addSecurityContext((SecurityContext)password);
        Preferences preferences = new Preferences();
        preferences.put("fileinputstream.adaptor.name", (Object)adaptor);
        FileInputStream in = null;
        try {
            in = GAT.createFileInputStream((GATContext)gatContext, (Preferences)preferences, (String)("any://" + host + "/JavaGAT-test-fileinputstream"));
        }
        catch (GATObjectCreationException e) {
            adaptorTestResult.put("create         ", new AdaptorTestResultEntry(false, 0L, e));
            this.run(host, "fileinputstream-adaptor-test-clean.sh");
            return adaptorTestResult;
        }
        adaptorTestResult.put("markSupported      ", this.markSupportedTest(in));
        adaptorTestResult.put("available:         ", this.availableTest(in, 0L, true));
        adaptorTestResult.put("read: single char a", this.readTest(in, 'a', true));
        adaptorTestResult.put("read: single char b", this.readTest(in, 'b', true));
        adaptorTestResult.put("read: single char c", this.readTest(in, 'c', true));
        adaptorTestResult.put("read: single char !d", this.readTest(in, 'q', false));
        adaptorTestResult.put("read: small       ", this.readTest(in, "efg".getBytes(), true));
        byte[] bytes = new byte[0xA00000];
        int current = 104;
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = current;
            current = current == 122 ? 10 : (current == 10 ? 97 : (int)((byte)(current + 1)));
        }
        adaptorTestResult.put("read: large          ", this.readTest(in, bytes, true));
        adaptorTestResult.put("skip: small          ", this.skipTest(in, 100L));
        adaptorTestResult.put("skip: large          ", this.skipTest(in, 0xA00000L));
        adaptorTestResult.put("close                ", this.closeTest(in));
        this.run(host, "fileinputstream-adaptor-test-clean.sh");
        return adaptorTestResult;
    }

    private void run(String host, String script) {
        Preferences preferences = new Preferences();
        preferences.put("resourcebroker.adaptor.name", (Object)"commandlinessh,sshtrilead,local");
        preferences.put("file.adaptor.name", (Object)"commandlinessh,sshtrilead,local");
        SoftwareDescription sd = new SoftwareDescription();
        sd.setExecutable("/bin/bash");
        sd.setArguments(new String[]{script});
        try {
            sd.addPreStagedFile(GAT.createFile((Preferences)preferences, (String)("tests" + File.separator + "src" + File.separator + "benchmarks" + File.separator + script)));
        }
        catch (GATObjectCreationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        ResourceBroker broker = null;
        try {
            broker = GAT.createResourceBroker((Preferences)preferences, (URI)new URI("any://" + host));
        }
        catch (GATObjectCreationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Job job = null;
        try {
            job = broker.submitJob((AbstractJobDescription)new JobDescription(sd));
        }
        catch (GATInvocationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        while (job.getState() != Job.JobState.STOPPED && job.getState() != Job.JobState.SUBMISSION_ERROR) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private AdaptorTestResultEntry availableTest(FileInputStream in, long correctValue, boolean correctResult) {
        boolean correct;
        long start = System.currentTimeMillis();
        try {
            correct = (long)in.available() >= correctValue;
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(correct == correctResult, stop - start, null);
    }

    private AdaptorTestResultEntry readTest(FileInputStream in, char correctValue, boolean correctResult) {
        boolean correct;
        long start = System.currentTimeMillis();
        try {
            correct = (char)in.read() == correctValue;
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(correct == correctResult, stop - start, null);
    }

    private AdaptorTestResultEntry readTest(FileInputStream in, byte[] correctValue, boolean correctResult) {
        int read;
        byte[] result = new byte[correctValue.length];
        boolean correct = true;
        long start = System.currentTimeMillis();
        for (read = 0; read != correctValue.length; read += in.read(result, read, correctValue.length - read)) {
            try {
                continue;
            }
            catch (IOException e) {
                return new AdaptorTestResultEntry(false, 0L, e);
            }
        }
        long stop = System.currentTimeMillis();
        boolean printed = false;
        for (int i = 0; i < read; ++i) {
            boolean bl = correct = correct && result[i] == correctValue[i];
            if (result[i] == correctValue[i] || printed) continue;
            System.out.println("i[" + i + "]: result[i]=" + (char)result[i] + ", correct[i]=" + (char)correctValue[i]);
            printed = true;
        }
        return new AdaptorTestResultEntry(correct, stop - start, null);
    }

    private AdaptorTestResultEntry skipTest(FileInputStream in, long n) {
        long start = System.currentTimeMillis();
        try {
            long skipped = in.skip(n);
            if (skipped != n) {
                return new AdaptorTestResultEntry(true, System.currentTimeMillis() - start, new Exception("skipped less bytes (" + skipped + ") than correct value (" + n + "), but the correct execution"));
            }
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(true, stop - start, null);
    }

    private AdaptorTestResultEntry markSupportedTest(FileInputStream in) {
        long start = System.currentTimeMillis();
        boolean markSupported = in.markSupported();
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(true, stop - start, markSupported ? new Exception("mark supported") : new Exception("mark not supported"));
    }

    private AdaptorTestResultEntry closeTest(FileInputStream in) {
        long start = System.currentTimeMillis();
        try {
            in.close();
        }
        catch (IOException e) {
            return new AdaptorTestResultEntry(false, 0L, e);
        }
        long stop = System.currentTimeMillis();
        return new AdaptorTestResultEntry(true, stop - start, null);
    }
}

