/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi;

import java.util.Map;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.Preferences;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.FileInputStreamInterface;
import org.gridlab.gat.monitoring.cpi.MonitorableCpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileInputStreamCpi
extends MonitorableCpi
implements FileInputStreamInterface {
    protected static Logger logger = LoggerFactory.getLogger(FileInputStreamCpi.class);
    protected GATContext gatContext;
    protected URI location;

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map<String, Boolean> capabilities = MonitorableCpi.getSupportedCapabilities();
        capabilities.put("available", false);
        capabilities.put("close", false);
        capabilities.put("mark", false);
        capabilities.put("markSupported", false);
        capabilities.put("read", false);
        capabilities.put("reset", false);
        capabilities.put("skip", false);
        return capabilities;
    }

    public static Preferences getSupportedPreferences() {
        Preferences preferences = MonitorableCpi.getSupportedPreferences();
        preferences.put("FileInputStream.adaptor.name", (Object)"<no default>");
        preferences.put("adaptors.local", (Object)"false");
        return preferences;
    }

    protected FileInputStreamCpi(GATContext gatContext, URI location) {
        this.gatContext = gatContext;
        this.location = location;
        if (logger.isDebugEnabled()) {
            logger.debug("FileInputStreamCpi: creating stream with URI " + location);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileInputStreamCpi)) {
            return false;
        }
        FileInputStreamCpi s = (FileInputStreamCpi)object;
        return this.location.equals((Object)s.location);
    }

    public int available() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void mark(int readlimit) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean markSupported() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int read() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int read(byte[] b, int off, int len) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int read(byte[] b) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void reset() throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long skip(long n) throws GATInvocationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        return this.location.toString();
    }
}

