/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.utils;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.VM;
import integratedtoolkit.connectors.utils.Operations;
import integratedtoolkit.types.CloudImageDescription;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.types.resources.configuration.MethodConfiguration;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.ResourceManager;
import java.util.HashMap;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreationThread
extends Thread {
    private static final Logger resourceLogger = LogManager.getLogger((String)"integratedtoolkit.ConnectorsUtils");
    private static final Logger runtimeLogger = LogManager.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    private static final boolean debug = resourceLogger.isDebugEnabled();
    private static final String ERROR_ASKING_NEW_RESOURCE = "Error asking a new Resource to ";
    private static final String ERROR_WAITING_VM = "Error waiting for a machine that should be provided by ";
    private static final String ERROR_POWEROFF_VM = "Cannot poweroff the machine\n]";
    private static final String ERROR_GRANTED_NULL = "Error: Granted description is null";
    private static final String ERROR_CONFIGURE_ACCESS_VM = "Error configuring access to machine ";
    private static final String ERROR_PREPARING_VM = "Exception preparing machine ";
    private static final String ERROR_START_WORKER = "Error starting the worker application in machine ";
    private static final String ERROR_START_VM = "Error: Could not turn on the VM";
    private static final String ERROR_ANNOUNCE_VM = "Error announcing the machine ";
    private static final String ERROR_WORKER_SHUTDOWN = "Exception raised on worker shutdown";
    private static final String ERROR_ANNOUNCE_VM_DESTROY = "Error announcing VM destruction";
    private static final String ERROR_USELESS_VM = "Useless VM";
    private static final String WARN_VM_REFUSED = "New resource has been refused because COMPSs has been stopped";
    private static final String WARN_CANNOT_PROVIDE_VM = "Provider can not provide the vm";
    private static ResourceUser listener;
    private static final Object countSynchronizer;
    private static Integer count;
    private final Operations operations;
    private final String name;
    private final String provider;
    private final ResourceCreationRequest rcr;
    private final VM reused;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreationThread(Operations operations, String name, String provider, ResourceCreationRequest rR, VM reused) {
        this.setName("Creation Thread " + name);
        this.operations = operations;
        this.provider = provider;
        this.name = name;
        this.rcr = rR;
        this.reused = reused;
        Object object = countSynchronizer;
        synchronized (object) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        VM granted;
        boolean check = this.operations.getCheck();
        runtimeLogger.debug("Operations check = " + check);
        CloudMethodResourceDescription requested = this.rcr.getRequested();
        if (this.reused == null) {
            try {
                granted = this.createResourceOnProvider(requested);
            }
            catch (Exception e) {
                runtimeLogger.error("Error creating resource.", (Throwable)e);
                this.notifyFailure();
                return;
            }
            if (debug) {
                runtimeLogger.debug("Resource " + granted.getName() + " with id  " + granted.getEnvId() + " has been created ");
            }
            resourceLogger.info("RESOURCE_GRANTED = [\n\tNAME = " + granted.getName() + "\n\tSTATUS = ID " + granted.getEnvId() + " CREATED\n]");
        } else {
            granted = this.reused;
            if (debug) {
                runtimeLogger.debug("Resource " + granted.getName() + " with id  " + granted.getEnvId() + " has been reused ");
            }
            resourceLogger.info("RESOURCE_GRANTED = [\n\tNAME = " + this.reused.getName() + "\n\tSTATUS = ID " + granted.getEnvId() + " REUSED\n]");
        }
        this.setName("Creation Thread " + granted.getName());
        CloudMethodWorker r = ResourceManager.getDynamicResource(granted.getName());
        if (r == null) {
            if (this.reused == null) {
                try {
                    if (debug) {
                        runtimeLogger.debug(" Preparing new worker resource " + granted.getName() + ".");
                    }
                    r = this.prepareNewResource(granted);
                    this.operations.vmReady(granted);
                }
                catch (Exception e) {
                    runtimeLogger.error(ERROR_PREPARING_VM, (Throwable)e);
                    this.powerOff(granted);
                    this.notifyFailure();
                    return;
                }
            } else {
                int limitOfTasks = granted.getDescription().getTotalCPUComputingUnits();
                r = new CloudMethodWorker(granted.getDescription(), granted.getNode(), limitOfTasks, this.rcr.getRequested().getImage().getSharedDisks());
                if (debug) {
                    runtimeLogger.debug("Worker for new resource " + granted.getName() + " set.");
                }
            }
            granted.setWorker(r);
            ResourceManager.addCloudWorker(this.rcr, r);
        } else {
            ResourceManager.increasedCloudWorker(this.rcr, r, granted.getDescription());
        }
        Object object = countSynchronizer;
        synchronized (object) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
        }
    }

    public static int getCount() {
        return count;
    }

    public static void setTaskDispatcher(ResourceUser listener) {
        CreationThread.listener = listener;
    }

    public static ResourceUser getTaskDispatcher() {
        return listener;
    }

    private VM createResourceOnProvider(CloudMethodResourceDescription requested) throws ConnectorException {
        VM granted;
        Object envID;
        try {
            envID = this.operations.poweron(this.name, requested);
        }
        catch (ConnectorException e) {
            runtimeLogger.error(ERROR_ASKING_NEW_RESOURCE + this.provider + "\n", (Throwable)e);
            resourceLogger.error("ERROR_MSG = [\n\tError asking a new Resource to " + this.provider + "\n]", (Throwable)e);
            throw e;
        }
        if (envID == null) {
            runtimeLogger.info(WARN_CANNOT_PROVIDE_VM);
            resourceLogger.info("INFO_MSG = [\n\t" + this.provider + WARN_CANNOT_PROVIDE_VM + "\n]");
            throw new ConnectorException(WARN_CANNOT_PROVIDE_VM);
        }
        try {
            granted = this.operations.waitCreation(envID, requested);
        }
        catch (ConnectorException e) {
            runtimeLogger.error(ERROR_WAITING_VM + this.provider + "\n", (Throwable)e);
            resourceLogger.error("ERROR_MSG = [\n\tError waiting for a machine that should be provided by " + this.provider + "\n]", (Throwable)e);
            try {
                this.operations.destroy(envID);
            }
            catch (ConnectorException ex) {
                runtimeLogger.error(ERROR_POWEROFF_VM);
                resourceLogger.error("ERROR_MSG = [\n\tCannot poweroff the machine\n]\n]");
            }
            throw new ConnectorException("Error waiting for the vm");
        }
        if (granted == null) {
            throw new ConnectorException(ERROR_GRANTED_NULL);
        }
        resourceLogger.debug("CONNECTOR_REQUEST = [");
        resourceLogger.debug("\tPROC_CPU_CU = " + requested.getTotalCPUComputingUnits());
        resourceLogger.debug("\tPROC_GPU_CU = " + requested.getTotalGPUComputingUnits());
        resourceLogger.debug("\tPROC_FPGA_CU = " + requested.getTotalFPGAComputingUnits());
        resourceLogger.debug("\tPROC_OTHER_CU = " + requested.getTotalOTHERComputingUnits());
        resourceLogger.debug("\tOS = " + requested.getOperatingSystemType());
        resourceLogger.debug("\tMEM = " + requested.getMemorySize());
        resourceLogger.debug("]");
        CloudMethodResourceDescription desc = granted.getDescription();
        resourceLogger.debug("CONNECTOR_GRANTED = [");
        resourceLogger.debug("\tPROC_CPU_CU = " + desc.getTotalCPUComputingUnits());
        resourceLogger.debug("\tPROC_GPU_CU = " + desc.getTotalGPUComputingUnits());
        resourceLogger.debug("\tPROC_FPGA_CU = " + desc.getTotalFPGAComputingUnits());
        resourceLogger.debug("\tPROC_OTHER_CU = " + desc.getTotalOTHERComputingUnits());
        resourceLogger.debug("\tOS = " + desc.getOperatingSystemType());
        resourceLogger.debug("\tMEM = " + desc.getMemorySize());
        resourceLogger.debug("]");
        return granted;
    }

    private CloudMethodWorker prepareNewResource(VM vm) throws ConnectorException {
        CloudMethodWorker worker;
        CloudMethodResourceDescription granted = vm.getDescription();
        CloudImageDescription cid = granted.getImage();
        HashMap<String, String> workerProperties = cid.getProperties();
        String user = cid.getConfig().getUser();
        String password = workerProperties.get("Password");
        try {
            this.operations.configureAccess(granted.getName(), user, password);
        }
        catch (ConnectorException e) {
            runtimeLogger.error(ERROR_CONFIGURE_ACCESS_VM + granted.getName(), (Throwable)e);
            resourceLogger.error("ERROR_MSG = [\n\tError configuring access to machine \n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]", (Throwable)e);
            throw e;
        }
        try {
            this.operations.prepareMachine(granted.getName(), cid);
        }
        catch (ConnectorException e) {
            runtimeLogger.error(ERROR_PREPARING_VM + granted.getName(), (Throwable)e);
            resourceLogger.error("ERROR_MSG = [\n\tException preparing machine " + granted.getName() + "]", (Throwable)e);
            throw e;
        }
        MethodConfiguration mc = cid.getConfig();
        try {
            int limitOfTasks = mc.getLimitOfTasks();
            int computingUnits = granted.getTotalCPUComputingUnits();
            if (limitOfTasks < 0 && computingUnits < 0) {
                mc.setLimitOfTasks(0);
                mc.setTotalComputingUnits(0);
            } else {
                mc.setLimitOfTasks(Math.max(limitOfTasks, computingUnits));
                mc.setTotalComputingUnits(Math.max(limitOfTasks, computingUnits));
            }
            mc.setHost(granted.getName());
            worker = new CloudMethodWorker(granted.getName(), granted, mc, cid.getSharedDisks());
        }
        catch (Exception e) {
            runtimeLogger.error(ERROR_START_WORKER + granted.getName(), (Throwable)e);
            resourceLogger.error("ERROR_MSG = [\n\tError starting the worker application in machine \n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]");
            throw new ConnectorException(ERROR_START_VM, e);
        }
        try {
            worker.announceCreation();
        }
        catch (Exception e) {
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            worker.stop(sl);
            runtimeLogger.error(ERROR_ANNOUNCE_VM + granted.getName() + ". Shutting down", (Throwable)e);
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e2) {
                resourceLogger.error(ERROR_WORKER_SHUTDOWN, (Throwable)e2);
            }
            runtimeLogger.error("Machine " + granted.getName() + " shut down because an error announcing destruction");
            resourceLogger.error("ERROR_MSG = [\n\tError announcing the machine \n\tNAME = " + granted.getName() + "\n\tPROVIDER =  " + this.provider + "\n]", (Throwable)e);
            throw new ConnectorException(e);
        }
        if (this.operations.getTerminate()) {
            resourceLogger.info("INFO_MSG = [\n\tNew resource has been refused because COMPSs has been stopped\n\tRESOURCE_NAME = " + granted.getName() + "\n]");
            try {
                worker.announceDestruction();
            }
            catch (Exception e) {
                resourceLogger.error("ERROR_MSG = [\n\tError announcing VM destruction\n\tVM_NAME = " + granted.getName() + "\n]", (Throwable)e);
            }
            Semaphore sem = new Semaphore(0);
            ShutdownListener sl = new ShutdownListener(sem);
            worker.stop(sl);
            sl.enable();
            try {
                sem.acquire();
            }
            catch (Exception e) {
                resourceLogger.error(ERROR_WORKER_SHUTDOWN);
            }
            throw new ConnectorException(ERROR_USELESS_VM);
        }
        return worker;
    }

    private void powerOff(VM granted) {
        try {
            this.operations.poweroff(granted);
        }
        catch (Exception e) {
            resourceLogger.error("ERROR_MSG = [\n\tCannot poweroff the machine\n]\n]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure() {
        Object object = countSynchronizer;
        synchronized (object) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
        }
    }

    static {
        countSynchronizer = new Object();
        count = 0;
    }
}

