/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.connectors.utils;

import integratedtoolkit.connectors.ConnectorException;
import integratedtoolkit.connectors.VM;
import integratedtoolkit.connectors.utils.Operations;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.ShutdownListener;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.ResourceManager;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeletionThread
extends Thread {
    private final Operations operations;
    private final CloudMethodWorker worker;
    private final CloudMethodResourceDescription reduction;
    private VM vm;
    private static final Object countSynchronizer = new Object();
    private static Integer count = 0;
    private static final Logger resourcesLogger = LogManager.getLogger((String)"integratedtoolkit.ConnectorsUtils");
    private static final Logger runtimeLogger = LogManager.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    private static final boolean debug = resourcesLogger.isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeletionThread(Operations connector, CloudMethodWorker worker, CloudMethodResourceDescription reduction) {
        this.setName("DeletionThread " + worker.getName());
        this.operations = connector;
        this.worker = worker;
        this.reduction = reduction;
        this.vm = null;
        Object object = countSynchronizer;
        synchronized (object) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeletionThread(Operations connector, VM vm) {
        this.setName("DeletionThread " + vm.getName());
        this.operations = connector;
        this.worker = null;
        this.reduction = null;
        this.vm = vm;
        Object object = countSynchronizer;
        synchronized (object) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.reduction != null) {
            Semaphore sem = ResourceManager.reduceCloudWorker(this.worker, this.reduction);
            try {
                if (sem != null) {
                    if (debug) {
                        runtimeLogger.debug("[Deletion Thread] Waiting until all tasks finishes for resource " + this.worker.getName() + "...");
                    }
                    sem.acquire();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (debug) {
                runtimeLogger.debug("[Deletion Thread] All tasks finished for resource " + this.worker.getName() + ". Pausing worker...");
            }
            this.vm = this.operations.pause(this.worker);
        }
        if (this.vm != null) {
            CloudMethodWorker cloudWorker = this.vm.getWorker();
            if (cloudWorker.shouldBeStopped()) {
                cloudWorker.retrieveData(true);
                Semaphore sem = new Semaphore(0);
                ShutdownListener sl = new ShutdownListener(sem);
                runtimeLogger.info("[Deletion Thread] Stopping worker " + cloudWorker.getName() + "...");
                cloudWorker.stop(sl);
                sl.enable();
                try {
                    sem.acquire();
                }
                catch (Exception e) {
                    resourcesLogger.error("ERROR: Exception raised on worker shutdown");
                }
                if (debug) {
                    runtimeLogger.debug("[Deletion Thread] Stopping worker " + cloudWorker.getName() + "...");
                }
            } else if (debug) {
                runtimeLogger.debug("[Deletion Thread] Worker " + cloudWorker.getName() + " should not be stopped.");
            }
            if (debug) {
                runtimeLogger.debug("[Deletion Thread] Worker " + cloudWorker.getName() + " stopped. Powering of the VM");
            }
            try {
                this.operations.poweroff(this.vm);
                ResourceManager.removeWorker(cloudWorker);
            }
            catch (ConnectorException e) {
                resourcesLogger.error("ERROR: Powering off the resource", (Throwable)e);
            }
        }
        Object object = countSynchronizer;
        synchronized (object) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
            if (debug) {
                runtimeLogger.debug("[Deletion Thread] Number of current VMs deletions decreased (" + count + ").");
            }
        }
    }

    public static int getCount() {
        return count;
    }
}

