/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.configuration.Configuration;
import integratedtoolkit.types.resources.configuration.MethodConfiguration;
import java.util.HashMap;

public class MethodWorker
extends Worker<MethodResourceDescription, Implementation<MethodResourceDescription>> {
    private String name;
    protected final MethodResourceDescription available;

    public MethodWorker(String name, MethodResourceDescription description, COMPSsWorker worker, int limitOfTasks, HashMap<String, String> sharedDisks) {
        super(name, description, (COMPSsNode)worker, limitOfTasks, sharedDisks);
        this.name = name;
        this.available = new MethodResourceDescription(description);
    }

    public MethodWorker(String name, MethodResourceDescription description, MethodConfiguration conf, HashMap<String, String> sharedDisks) {
        super(name, description, (Configuration)conf, sharedDisks);
        this.name = name;
        this.available = new MethodResourceDescription(description);
    }

    public MethodWorker(MethodWorker mw) {
        super(mw);
        this.available = mw.available.copy();
    }

    public String getName() {
        return this.name;
    }

    public MethodResourceDescription getAvailable() {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MethodResourceDescription reserveResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            if (this.hasAvailable(consumption)) {
                return (MethodResourceDescription)this.available.reduceDynamic((ResourceDescription)consumption);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResource(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            this.available.increaseDynamic((ResourceDescription)consumption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllResources() {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            super.resetUsedTaskCount();
            this.available.reduceDynamic((ResourceDescription)this.available);
            this.available.increaseDynamic((ResourceDescription)this.description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAvailable(MethodResourceDescription consumption) {
        MethodResourceDescription methodResourceDescription = this.available;
        synchronized (methodResourceDescription) {
            return this.available.containsDynamic(consumption);
        }
    }

    @Override
    public boolean usesGPU(MethodResourceDescription consumption) {
        return consumption.getTotalGPUComputingUnits() > 0;
    }

    @Override
    public boolean usesFPGA(MethodResourceDescription consumption) {
        return consumption.getTotalFPGAComputingUnits() > 0;
    }

    @Override
    public boolean usesOthers(MethodResourceDescription consumption) {
        return consumption.getTotalOTHERComputingUnits() > 0;
    }

    @Override
    public Integer fitCount(Implementation<MethodResourceDescription> impl) {
        if (impl.getTaskType() == Implementation.TaskType.SERVICE) {
            return null;
        }
        MethodResourceDescription ctrs = (MethodResourceDescription)impl.getRequirements();
        return ((MethodResourceDescription)this.description).canHostSimultaneously(ctrs);
    }

    public Resource.Type getType() {
        return Resource.Type.WORKER;
    }

    @Override
    public String getMonitoringData(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("<TotalCPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalCPUComputingUnits()).append("</TotalCPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalGPUComputingUnits>").append(((MethodResourceDescription)this.description).getTotalGPUComputingUnits()).append("</TotalGPUComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalFPGAComputingUnits>").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("</TotalFPGAComputingUnits>").append("\n");
        sb.append(prefix).append("<TotalOTHERComputingUnits>").append(((MethodResourceDescription)this.description).getTotalOTHERComputingUnits()).append("</TotalOTHERComputingUnits>").append("\n");
        sb.append(prefix).append("<Memory>").append(((MethodResourceDescription)this.description).getMemorySize()).append("</Memory>").append("\n");
        sb.append(prefix).append("<Disk>").append(((MethodResourceDescription)this.description).getStorageSize()).append("</Disk>").append("\n");
        return sb.toString();
    }

    private Float getValue() {
        return ((MethodResourceDescription)this.description).value;
    }

    public int compareTo(Resource t) {
        if (t == null) {
            throw new NullPointerException();
        }
        switch (t.getType()) {
            case SERVICE: {
                return 1;
            }
            case WORKER: {
                MethodWorker w = (MethodWorker)t;
                if (((MethodResourceDescription)this.description).getValue() == null) {
                    if (w.getValue() == null) {
                        return w.getName().compareTo(this.getName());
                    }
                    return 1;
                }
                if (w.getValue() == null) {
                    return -1;
                }
                float dif = w.getValue().floatValue() - ((MethodResourceDescription)this.description).getValue().floatValue();
                if (dif > 0.0f) {
                    return -1;
                }
                if (dif < 0.0f) {
                    return 1;
                }
                return this.getName().compareTo(w.getName());
            }
            case MASTER: {
                return -1;
            }
        }
        return this.getName().compareTo(t.getName());
    }

    @Override
    public boolean canRun(Implementation<MethodResourceDescription> implementation) {
        switch (implementation.getTaskType()) {
            case METHOD: {
                MethodResourceDescription ctrs = (MethodResourceDescription)implementation.getRequirements();
                return ((MethodResourceDescription)this.description).contains(ctrs);
            }
        }
        return false;
    }

    @Override
    public String getResourceLinks(String prefix) {
        StringBuilder sb = new StringBuilder(super.getResourceLinks(prefix));
        sb.append(prefix).append("TYPE = WORKER").append("\n");
        sb.append(prefix).append("CPU_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalCPUComputingUnits()).append("\n");
        sb.append(prefix).append("GPU_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalGPUComputingUnits()).append("\n");
        sb.append(prefix).append("FPGA_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("\n");
        sb.append(prefix).append("OTHER_COMPUTING_UNITS = ").append(((MethodResourceDescription)this.description).getTotalFPGAComputingUnits()).append("\n");
        sb.append(prefix).append("MEMORY = ").append(((MethodResourceDescription)this.description).getMemorySize()).append("\n");
        return sb.toString();
    }

    @Override
    public Worker<MethodResourceDescription, Implementation<MethodResourceDescription>> getSchedulingCopy() {
        return new MethodWorker(this);
    }
}

