/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.types.resources;

import integratedtoolkit.types.COMPSsNode;
import integratedtoolkit.types.COMPSsWorker;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.Resource;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import integratedtoolkit.types.resources.configuration.Configuration;
import integratedtoolkit.util.CoreManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Worker<T extends WorkerResourceDescription, I extends Implementation<T>>
extends Resource {
    protected final T description;
    private LinkedList<Integer> executableCores;
    private LinkedList<I>[] executableImpls;
    private int[][] implSimultaneousTasks;
    private int[] coreSimultaneousTasks;
    private int[] idealSimultaneousTasks;
    private int usedTaskCount = 0;
    private final int maxTaskCount;
    private int usedGPUTaskCount = 0;
    private final int maxGPUTaskCount;
    private int usedFPGATaskCount = 0;
    private final int maxFPGATaskCount;
    private int usedOthersTaskCount = 0;
    private final int maxOthersTaskCount;
    protected static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();

    public Worker(String name, T description, COMPSsNode worker, int limitOfTasks, HashMap<String, String> sharedDisks) {
        super(worker, sharedDisks);
        int coreCount = CoreManager.getCoreCount();
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        this.executableCores = new LinkedList();
        this.implSimultaneousTasks = new int[coreCount][];
        this.executableImpls = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.executableImpls[coreId] = new LinkedList();
            this.implSimultaneousTasks[coreId] = new int[CoreManager.getNumberCoreImplementations((int)coreId)];
        }
        this.description = description;
        this.maxTaskCount = limitOfTasks;
        this.maxGPUTaskCount = 0;
        this.maxFPGATaskCount = 0;
        this.maxOthersTaskCount = 0;
    }

    public Worker(String name, T description, Configuration config, HashMap<String, String> sharedDisks) {
        super(name, config, sharedDisks);
        int coreCount = CoreManager.getCoreCount();
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        this.executableCores = new LinkedList();
        this.implSimultaneousTasks = new int[coreCount][];
        this.executableImpls = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            this.executableImpls[coreId] = new LinkedList();
            this.implSimultaneousTasks[coreId] = new int[CoreManager.getNumberCoreImplementations((int)coreId)];
        }
        this.description = description;
        this.maxTaskCount = config.getLimitOfTasks();
        this.maxGPUTaskCount = config.getLimitOfGPUTasks();
        this.maxFPGATaskCount = config.getLimitOfFPGATasks();
        this.maxOthersTaskCount = config.getLimitOfOTHERSTasks();
    }

    public Worker(Worker<T, I> w) {
        super(w);
        this.coreSimultaneousTasks = w.coreSimultaneousTasks;
        this.idealSimultaneousTasks = w.idealSimultaneousTasks;
        this.executableCores = w.executableCores;
        this.implSimultaneousTasks = w.implSimultaneousTasks;
        this.executableImpls = w.executableImpls;
        this.description = w.description;
        this.maxTaskCount = w.maxTaskCount;
        this.usedTaskCount = w.usedTaskCount;
        this.maxGPUTaskCount = w.maxGPUTaskCount;
        this.usedGPUTaskCount = w.usedGPUTaskCount;
        this.maxFPGATaskCount = w.maxFPGATaskCount;
        this.usedFPGATaskCount = w.usedFPGATaskCount;
        this.maxOthersTaskCount = w.maxOthersTaskCount;
        this.usedOthersTaskCount = w.usedOthersTaskCount;
    }

    public T getDescription() {
        return this.description;
    }

    public int getMaxTaskCount() {
        return this.maxTaskCount;
    }

    public int getUsedTaskCount() {
        return this.usedTaskCount;
    }

    public int getMaxGPUTaskCount() {
        return this.maxGPUTaskCount;
    }

    public int getUsedGPUTaskCount() {
        return this.usedGPUTaskCount;
    }

    public int getMaxFPGATaskCount() {
        return this.maxFPGATaskCount;
    }

    public int getUsedFPGATaskCount() {
        return this.usedFPGATaskCount;
    }

    public int getMaxOthersTaskCount() {
        return this.maxOthersTaskCount;
    }

    public int getUsedOthersTaskCount() {
        return this.usedOthersTaskCount;
    }

    private void decreaseUsedTaskCount() {
        --this.usedTaskCount;
    }

    private void increaseUsedTaskCount() {
        ++this.usedTaskCount;
    }

    private void decreaseUsedGPUTaskCount() {
        --this.usedGPUTaskCount;
    }

    private void increaseUsedGPUTaskCount() {
        ++this.usedGPUTaskCount;
    }

    private void decreaseUsedFPGATaskCount() {
        --this.usedFPGATaskCount;
    }

    private void increaseUsedFPGATaskCount() {
        ++this.usedFPGATaskCount;
    }

    private void decreaseUsedOthersTaskCount() {
        --this.usedOthersTaskCount;
    }

    private void increaseUsedOthersTaskCount() {
        ++this.usedOthersTaskCount;
    }

    public void resetUsedTaskCount() {
        this.usedTaskCount = 0;
    }

    public void updatedCoreElements(List<Integer> updatedCoreIds) {
        if (DEBUG) {
            LOGGER.debug("Update coreElements on Worker " + this.getName());
        }
        int coreCount = CoreManager.getCoreCount();
        boolean[] coresToUpdate = new boolean[coreCount];
        for (int coreId : updatedCoreIds) {
            coresToUpdate[coreId] = true;
        }
        boolean[] wasExecutable = new boolean[coreCount];
        Iterator coreId = this.executableCores.iterator();
        while (coreId.hasNext()) {
            int coreId2 = (Integer)coreId.next();
            wasExecutable[coreId2] = true;
        }
        this.executableCores.clear();
        LinkedList[] executableImpls = new LinkedList[coreCount];
        int[][] implSimultaneousTasks = new int[coreCount][];
        int[] coreSimultaneousTasks = new int[coreCount];
        int[] idealSimultaneousTasks = new int[coreCount];
        for (int coreId3 = 0; coreId3 < coreCount; ++coreId3) {
            if (!coresToUpdate[coreId3]) {
                executableImpls[coreId3] = this.executableImpls[coreId3];
                implSimultaneousTasks[coreId3] = this.implSimultaneousTasks[coreId3];
                coreSimultaneousTasks[coreId3] = this.coreSimultaneousTasks[coreId3];
                idealSimultaneousTasks[coreId3] = this.idealSimultaneousTasks[coreId3];
                if (!wasExecutable[coreId3]) continue;
                this.executableCores.add(coreId3);
                continue;
            }
            boolean executableCore = false;
            List impls = CoreManager.getCoreImplementations((int)coreId3);
            implSimultaneousTasks[coreId3] = new int[impls.size()];
            executableImpls[coreId3] = new LinkedList();
            for (Implementation i : impls) {
                Implementation impl = i;
                if (!this.canRun(impl)) continue;
                int simultaneousCapacity = this.simultaneousCapacity(impl);
                idealSimultaneousTasks[coreId3] = Math.max(idealSimultaneousTasks[coreId3], simultaneousCapacity);
                implSimultaneousTasks[coreId3][impl.getImplementationId().intValue()] = simultaneousCapacity;
                if (implSimultaneousTasks[coreId3][impl.getImplementationId()] <= 0) continue;
                executableImpls[coreId3].add(impl);
                executableCore = true;
            }
            if (!executableCore) continue;
            this.executableCores.add(coreId3);
        }
        this.executableImpls = executableImpls;
        this.implSimultaneousTasks = implSimultaneousTasks;
        this.coreSimultaneousTasks = coreSimultaneousTasks;
        this.idealSimultaneousTasks = idealSimultaneousTasks;
    }

    public void updatedFeatures() {
        int coreCount = CoreManager.getCoreCount();
        this.executableCores.clear();
        this.executableImpls = new LinkedList[coreCount];
        this.implSimultaneousTasks = new int[coreCount][];
        this.coreSimultaneousTasks = new int[coreCount];
        this.idealSimultaneousTasks = new int[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            boolean executableCore = false;
            List impls = CoreManager.getCoreImplementations((int)coreId);
            this.implSimultaneousTasks[coreId] = new int[impls.size()];
            this.executableImpls[coreId] = new LinkedList();
            for (Implementation i : impls) {
                Implementation impl = i;
                if (!this.canRun(impl)) continue;
                int simultaneousCapacity = this.simultaneousCapacity(impl);
                this.idealSimultaneousTasks[coreId] = Math.max(this.idealSimultaneousTasks[coreId], simultaneousCapacity);
                this.implSimultaneousTasks[coreId][impl.getImplementationId().intValue()] = simultaneousCapacity;
                if (simultaneousCapacity <= 0) continue;
                this.executableImpls[coreId].add(impl);
                executableCore = true;
            }
            if (!executableCore) continue;
            this.coreSimultaneousTasks[coreId] = Math.min(this.getMaxTaskCount(), this.idealSimultaneousTasks[coreId]);
            this.executableCores.add(coreId);
        }
    }

    public LinkedList<Integer> getExecutableCores() {
        return this.executableCores;
    }

    public LinkedList<I>[] getExecutableImpls() {
        return this.executableImpls;
    }

    public LinkedList<I> getExecutableImpls(int coreId) {
        return this.executableImpls[coreId];
    }

    public int[] getIdealSimultaneousTasks() {
        return this.idealSimultaneousTasks;
    }

    public int[] getSimultaneousTasks() {
        return this.coreSimultaneousTasks;
    }

    public Integer simultaneousCapacity(I impl) {
        return Math.min(this.fitCount(impl), this.getMaxTaskCount());
    }

    public String getResourceLinks(String prefix) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("NAME = ").append(this.getName()).append("\n");
        sb.append(prefix).append("EXEC_CORES = ").append(this.executableCores).append("\n");
        sb.append(prefix).append("CORE_SIMTASKS = [").append("\n");
        for (i = 0; i < this.coreSimultaneousTasks.length; ++i) {
            sb.append(prefix).append("\t").append("CORE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("COREID = ").append(i).append("\n");
            sb.append(prefix).append("\t").append("\t").append("SIM_TASKS = ").append(this.coreSimultaneousTasks[i]).append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        sb.append(prefix).append("IMPL_SIMTASKS = [").append("\n");
        for (i = 0; i < this.implSimultaneousTasks.length; ++i) {
            for (int j = 0; j < this.implSimultaneousTasks[i].length; ++j) {
                sb.append(prefix).append("\t").append("IMPLEMENTATION = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("COREID = ").append(i).append("\n");
                sb.append(prefix).append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                sb.append(prefix).append("\t").append("\t").append("SIM_TASKS = ").append(this.implSimultaneousTasks[i][j]).append("\n");
                sb.append(prefix).append("\t").append("]").append("\n");
            }
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }

    public LinkedList<Integer> getRunnableCores() {
        LinkedList<Integer> cores = new LinkedList<Integer>();
        int coreCount = CoreManager.getCoreCount();
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (this.getRunnableImplementations(coreId).isEmpty()) continue;
            cores.add(coreId);
        }
        return cores;
    }

    public LinkedList<I>[] getRunnableImplementations() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] runnable = new LinkedList[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            runnable[coreId] = this.getRunnableImplementations(coreId);
        }
        return runnable;
    }

    public LinkedList<I> getRunnableImplementations(int coreId) {
        LinkedList<Implementation> runnable = new LinkedList<Implementation>();
        for (Implementation impl : this.executableImpls[coreId]) {
            if (!this.canRunNow(impl.getRequirements())) continue;
            runnable.add(impl);
        }
        return runnable;
    }

    public boolean canRun(int coreId) {
        return this.idealSimultaneousTasks[coreId] > 0;
    }

    public LinkedList<I> canRunNow(LinkedList<I> candidates) {
        LinkedList<Implementation> runnable = new LinkedList<Implementation>();
        for (Implementation impl : candidates) {
            if (!this.canRunNow(impl.getRequirements())) continue;
            runnable.add(impl);
        }
        return runnable;
    }

    public boolean canRunNow(T consumption) {
        boolean canRun = this.getUsedTaskCount() < this.getMaxTaskCount();
        canRun = canRun && (this.getUsedGPUTaskCount() < this.getMaxGPUTaskCount() || !this.usesGPU(consumption));
        canRun = canRun && (this.getUsedFPGATaskCount() < this.getMaxFPGATaskCount() || !this.usesFPGA(consumption));
        canRun = canRun && (this.getUsedOthersTaskCount() < this.getMaxOthersTaskCount() || !this.usesOthers(consumption));
        canRun = canRun && this.hasAvailable(consumption);
        return canRun;
    }

    public void endTask(T consumption) {
        if (DEBUG) {
            LOGGER.debug("End task received. Releasing resource " + this.getName());
        }
        this.decreaseUsedTaskCount();
        if (this.usesGPU(consumption)) {
            this.decreaseUsedGPUTaskCount();
        }
        if (this.usesFPGA(consumption)) {
            this.decreaseUsedFPGATaskCount();
        }
        if (this.usesOthers(consumption)) {
            this.decreaseUsedOthersTaskCount();
        }
        this.releaseResource(consumption);
    }

    public T runTask(T consumption) {
        if (this.usedTaskCount < this.maxTaskCount) {
            T reserved = this.reserveResource(consumption);
            if (reserved != null) {
                this.increaseUsedTaskCount();
                if (this.usesGPU(consumption)) {
                    this.increaseUsedGPUTaskCount();
                }
                if (this.usesFPGA(consumption)) {
                    this.increaseUsedFPGATaskCount();
                }
                if (this.usesOthers(consumption)) {
                    this.increaseUsedOthersTaskCount();
                }
                return reserved;
            }
            return null;
        }
        return null;
    }

    public abstract String getMonitoringData(String var1);

    public abstract boolean canRun(I var1);

    public abstract Integer fitCount(I var1);

    public abstract boolean hasAvailable(T var1);

    public abstract boolean usesGPU(T var1);

    public abstract boolean usesFPGA(T var1);

    public abstract boolean usesOthers(T var1);

    public abstract T reserveResource(T var1);

    public abstract void releaseResource(T var1);

    public abstract void releaseAllResources();

    public void announceCreation() throws Exception {
        COMPSsWorker w = (COMPSsWorker)this.getNode();
        w.announceCreation();
    }

    public void announceDestruction() throws Exception {
        COMPSsWorker w = (COMPSsWorker)this.getNode();
        w.announceDestruction();
    }

    public abstract Worker<T, I> getSchedulingCopy();

    public String toString() {
        return "Worker " + this.description + " with usedTaskCount = " + this.usedTaskCount + " and maxTaskCount = " + this.maxTaskCount + " with the following description " + this.description;
    }
}

