/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.CoreManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloudTypeManager {
    private HashMap<String, Type> types = new HashMap();
    private HashMap<String, HashMap<String, int[]>> vmToType = new HashMap();

    public void add(CloudMethodResourceDescription rd) {
        Type t = new Type(rd);
        this.types.put(rd.getName(), t);
    }

    public LinkedList<CloudMethodResourceDescription> getCompatibleTypes(MethodResourceDescription requested) {
        LinkedList<CloudMethodResourceDescription> compatiblesList = new LinkedList<CloudMethodResourceDescription>();
        for (Type type : this.types.values()) {
            CloudMethodResourceDescription mixedDescription = new CloudMethodResourceDescription(type.getResourceDescription());
            if (!mixedDescription.contains(requested)) continue;
            compatiblesList.add(mixedDescription);
        }
        return compatiblesList;
    }

    public Set<String> getAllInstanceTypeNames() {
        return this.types.keySet();
    }

    public void createdVM(String resourceName, String requestType) {
        HashMap<String, Object> vm = this.vmToType.get(resourceName);
        if (vm == null) {
            vm = new HashMap();
            for (String type : this.types.keySet()) {
                vm.put(type, new int[]{0});
            }
            vm.put(requestType, new int[]{1});
            this.vmToType.put(resourceName, vm);
        } else {
            int[] nArray = vm.get(requestType);
            nArray[0] = nArray[0] + 1;
        }
    }

    public void reduceVM(String resourceName, String requestType) {
        HashMap<String, int[]> vm = this.vmToType.remove(resourceName);
        if (vm != null) {
            int[] nArray = vm.get(requestType);
            nArray[0] = nArray[0] - 1;
            if (this.hasValidInstances(vm)) {
                this.vmToType.put(resourceName, vm);
            }
        }
    }

    public void clearAll() {
        this.vmToType.clear();
    }

    public CloudMethodResourceDescription getDescription(String type) {
        Type t = this.types.get(type);
        if (t != null) {
            return t.getResourceDescription();
        }
        return null;
    }

    public int[][] getSimultaneousImpls(String type) {
        Type t = this.types.get(type);
        if (t != null) {
            return t.getSlotsImpl();
        }
        return null;
    }

    public HashMap<String, Object[]> getPossibleReductions(String name) {
        HashMap<String, Object[]> h = new HashMap<String, Object[]>();
        for (Map.Entry<String, int[]> entry : this.vmToType.get(name).entrySet()) {
            Type t;
            String type = entry.getKey();
            Object[] value = new Object[2];
            int[] amount = entry.getValue();
            if (amount == null || amount[0] <= 0 || (t = this.types.get(type)) == null) continue;
            value[0] = t.getSlotsCore();
            value[1] = t.getResourceDescription();
            h.put(type, value);
        }
        return h;
    }

    public void removeVM(String name) {
        this.vmToType.remove(name);
    }

    private boolean hasValidInstances(HashMap<String, int[]> vm) {
        int validCount = 0;
        for (int[] amounts : vm.values()) {
            validCount += amounts[0];
        }
        return validCount == 0;
    }

    public HashMap<CloudMethodResourceDescription, Integer> getComposition(String name) {
        HashMap<String, int[]> vm = this.vmToType.get(name);
        HashMap<CloudMethodResourceDescription, Integer> composition = new HashMap<CloudMethodResourceDescription, Integer>();
        for (Map.Entry<String, int[]> entry : vm.entrySet()) {
            String typeName = entry.getKey();
            int[] counts = entry.getValue();
            Type type = this.types.get(typeName);
            if (type == null || counts[0] <= 0) continue;
            composition.put(type.getResourceDescription(), counts[0]);
        }
        return composition;
    }

    public void newCoreElementsDetected(List<Integer> newCores) {
        int coreCount = CoreManager.getCoreCount();
        for (Type type : this.types.values()) {
            int[] slotsC = new int[coreCount];
            int[][] slotsI = new int[coreCount][];
            int[] slotsCore = type.getSlotsCore();
            System.arraycopy(slotsCore, 0, slotsC, 0, slotsCore.length);
            for (int i = 0; i < type.getSlotsImplLength(); ++i) {
                int[] slotsImpl = type.getSpecificSlotsImpl(i);
                slotsI[i] = new int[slotsImpl.length];
                System.arraycopy(slotsImpl, 0, slotsI[i], 0, slotsImpl.length);
            }
            for (int coreId : newCores) {
                List impls = CoreManager.getCoreImplementations((int)coreId);
                int implsSize = impls.size();
                slotsI[coreId] = new int[implsSize];
                for (int implId = 0; implId < implsSize; ++implId) {
                    Implementation impl = (Implementation)impls.get(implId);
                    if (impl.getTaskType() != Implementation.TaskType.METHOD) continue;
                    MethodResourceDescription rd = (MethodResourceDescription)impl.getRequirements();
                    Integer into = type.getResourceDescription().canHostSimultaneously(rd);
                    slotsC[coreId] = Math.max(slotsC[coreId], into);
                    slotsI[coreId][implId] = into;
                }
            }
            type.setSlotsCore(slotsC);
            type.setSlotsImpl(slotsI);
        }
    }

    public String getCurrentState(String prefix) {
        int coreCount = CoreManager.getCoreCount();
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("TYPES = [").append("\n");
        for (Map.Entry<String, Type> entry : this.types.entrySet()) {
            int i;
            sb.append(prefix).append("\t").append("TYPE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("KEY = ").append(entry.getKey()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("CORES = [").append("\n");
            for (i = 0; i < coreCount; ++i) {
                sb.append(prefix).append("\t").append("\t").append("\t").append("CORE = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("COREID = ").append(i).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("SLOTS = ").append(entry.getValue().getSpecificSlotsCore(i)).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("\t").append("IMPLEMENTATIONS = [").append("\n");
            for (i = 0; i < coreCount; ++i) {
                for (int j = 0; j < CoreManager.getNumberCoreImplementations((int)i); ++j) {
                    sb.append(prefix).append("\t").append("\t").append("\t").append("IMPLEMENTATION = [").append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("COREID = ").append(i).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("SLOTS = ").append(entry.getValue().getSpecificSlotsImpl(i, j)).append("\n");
                    sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
                }
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        sb.append(prefix).append("VIRTUAL_INSTANCES = [").append("\n");
        for (Map.Entry<String, Object> entry : this.vmToType.entrySet()) {
            HashMap composition = (HashMap)entry.getValue();
            sb.append(prefix).append("\t").append("VIRTUAL_INSTANCE = [").append("\n");
            sb.append(prefix).append("\t").append("\t").append("NAME = ").append(entry.getKey()).append("\n");
            sb.append(prefix).append("\t").append("\t").append("COMPONENTS = [").append("\n");
            for (Map.Entry component : composition.entrySet()) {
                String componentName = (String)component.getKey();
                int[] amount = (int[])component.getValue();
                sb.append(prefix).append("\t").append("\t").append("\t").append("COMPONENT = [").append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("NAME = ").append(componentName).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("\t").append("AMOUNT = ").append(amount[0]).append("\n");
                sb.append(prefix).append("\t").append("\t").append("\t").append("]").append("\n");
            }
            sb.append(prefix).append("\t").append("\t").append("]").append("\n");
            sb.append(prefix).append("\t").append("]").append("\n");
        }
        sb.append(prefix).append("]").append("\n");
        return sb.toString();
    }

    private class Type {
        private final CloudMethodResourceDescription rd;
        private int[] slotsCore;
        private int[][] slotsImpl;

        public Type(CloudMethodResourceDescription rd) {
            this.rd = rd;
            int coreCount = CoreManager.getCoreCount();
            this.slotsCore = new int[coreCount];
            this.slotsImpl = new int[coreCount][];
            for (int coreId = 0; coreId < coreCount; ++coreId) {
                List impls = CoreManager.getCoreImplementations((int)coreId);
                int implsSize = impls.size();
                this.slotsImpl[coreId] = new int[implsSize];
                for (int implId = 0; implId < implsSize; ++implId) {
                    Implementation impl = (Implementation)impls.get(implId);
                    if (impl.getTaskType() != Implementation.TaskType.METHOD) continue;
                    MethodResourceDescription reqs = (MethodResourceDescription)impl.getRequirements();
                    Integer into = rd.canHostSimultaneously(reqs);
                    this.slotsCore[coreId] = Math.max(this.slotsCore[coreId], into);
                    this.slotsImpl[coreId][implId] = into;
                }
            }
        }

        public CloudMethodResourceDescription getResourceDescription() {
            return this.rd;
        }

        public int[] getSlotsCore() {
            return this.slotsCore;
        }

        public int getSpecificSlotsCore(int index) {
            return this.slotsCore[index];
        }

        public void setSlotsCore(int[] slotsCore) {
            this.slotsCore = slotsCore;
        }

        public int[][] getSlotsImpl() {
            return this.slotsImpl;
        }

        public int getSlotsImplLength() {
            return this.slotsImpl.length;
        }

        public int[] getSpecificSlotsImpl(int i) {
            return this.slotsImpl[i];
        }

        public int getSpecificSlotsImpl(int i, int j) {
            return this.slotsImpl[i][j];
        }

        public void setSlotsImpl(int[][] slotsImpl) {
            this.slotsImpl = slotsImpl;
        }
    }
}

