/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.util;

import integratedtoolkit.components.ResourceUser;
import integratedtoolkit.types.ResourceCreationRequest;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.implementations.MethodImplementation;
import integratedtoolkit.types.resources.CloudMethodWorker;
import integratedtoolkit.types.resources.MethodResourceDescription;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.types.resources.components.Processor;
import integratedtoolkit.types.resources.description.CloudMethodResourceDescription;
import integratedtoolkit.util.CloudManager;
import integratedtoolkit.util.CoreManager;
import integratedtoolkit.util.ErrorManager;
import integratedtoolkit.util.ResourceManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceOptimizer
extends Thread {
    private static final Logger RESOURCES_LOGGER = LogManager.getLogger((String)"integratedtoolkit.Resources");
    private static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Components.ResourceManager");
    private static final boolean debug = LOGGER.isDebugEnabled();
    private static final int SLEEP_TIME = 10000;
    private static final int EVERYTHING_BLOCKED_MAX_RETRIES = 3;
    private static final String ERROR_OPT_RES = "Error optimizing resources.";
    private static final String PERSISTENT_BLOCK_ERR = "Unschedulable tasks detected.\nCOMPSs has found tasks with constraints that cannot be fulfilled.\nShutting down COMPSs now...";
    private final Object alarmClock = new Object();
    private boolean running;
    private Integer maxNumberOfVMs;
    private Integer minNumberOfVMs;
    private ResourceUser resUser;
    private static boolean cleanUp;
    private static boolean redo;
    private int everythingBlockedRetryCount = -1;

    public ResourceOptimizer(ResourceUser resUser) {
        if (debug) {
            LOGGER.debug("[Resource Optimizer] Initializing Resource Optimizer");
        }
        this.resUser = resUser;
        redo = false;
        LOGGER.info("[Resource Optimizer] Initialization finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ResourceUser.WorkloadStatus status) {
        Object object = this.alarmClock;
        synchronized (object) {
            this.running = false;
            this.alarmClock.notify();
            cleanUp = true;
        }
        RESOURCES_LOGGER.info(status.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        if (ResourceManager.useCloud()) {
            this.initialCreations();
        }
        while (this.running) {
            try {
                do {
                    boolean potentialBlock;
                    redo = false;
                    ResourceUser.WorkloadStatus workload = this.resUser.getWorkload();
                    int blockedTasks = workload.getNoResourceCount();
                    boolean bl = potentialBlock = blockedTasks > 0;
                    if (ResourceManager.useCloud()) {
                        this.applyPolicies(workload);
                        int VMsBeingCreated = CloudManager.getPendingRequests().size();
                        potentialBlock = potentialBlock && VMsBeingCreated == 0;
                    }
                    this.handlePotentialBlock(potentialBlock);
                } while (redo);
                try {
                    Object blockedTasks = this.alarmClock;
                    synchronized (blockedTasks) {
                        if (this.running) {
                            this.alarmClock.wait(10000L);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                LOGGER.error(ERROR_OPT_RES, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeNow() {
        Object object = this.alarmClock;
        synchronized (object) {
            this.alarmClock.notify();
            redo = true;
        }
    }

    public void cleanUp() {
        cleanUp = true;
    }

    public void handlePotentialBlock(boolean potentialBlock) {
        if (potentialBlock) {
            ++this.everythingBlockedRetryCount;
            if (this.everythingBlockedRetryCount > 0) {
                if (this.everythingBlockedRetryCount < 3) {
                    int retriesLeft = 3 - this.everythingBlockedRetryCount;
                    ErrorManager.warn((String)("No task could be scheduled to any of the available resources.\nThis could end up blocking COMPSs. Will check it again in 10 seconds.\nPossible causes: \n    -Network problems: non-reachable nodes, sshd service not started, etc.\n    -There isn't any computing resource that fits the defined tasks constraints.\nIf this happens " + retriesLeft + " more time" + (retriesLeft > 1 ? "s" : "") + ", the runtime will shutdown."));
                } else {
                    ErrorManager.error((String)PERSISTENT_BLOCK_ERR);
                }
            }
        } else {
            this.everythingBlockedRetryCount = 0;
        }
    }

    private void initialCreations() {
        int alreadyCreated = ResourceOptimizer.addBasicNodes();
        ResourceOptimizer.addExtraNodes(alreadyCreated);
    }

    public static int addBasicNodes() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList<ConstraintsCore>[] unfulfilledConstraints = ResourceOptimizer.getUnfulfilledConstraints();
        int unfulfilledConstraintsCores = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            if (unfulfilledConstraints[coreId].size() <= 0) continue;
            unfulfilledConstraintsCores += unfulfilledConstraints[coreId].size();
            break;
        }
        if (unfulfilledConstraintsCores == 0) {
            return 0;
        }
        HashMap<String, LinkedList<ConstraintsCore>> arch2Constraints = ResourceOptimizer.classifyArchitectures(unfulfilledConstraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        ResourceOptimizer.reassignUnassignedConstraints(arch2Constraints);
        ResourceOptimizer.reduceArchitecturesConstraints(arch2Constraints);
        int createdCount = 0;
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            while (!unfulfilledConstraints[coreId].isEmpty()) {
                ConstraintsCore cc = unfulfilledConstraints[coreId].removeFirst();
                cc.confirmed();
                ResourceCreationRequest rcr = CloudManager.askForResources(cc.desc, false);
                if (rcr == null) continue;
                RESOURCES_LOGGER.info("ORDER_CREATION = [\n\tTYPE = " + rcr.getRequested().getType() + "\n\tPROVIDER = " + rcr.getProvider() + "\n]");
                if (debug) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("EXPECTED_SIM_TASKS = [").append("\n");
                    for (int i = 0; i < rcr.requestedSimultaneousTaskCount().length; ++i) {
                        for (int j = 0; j < rcr.requestedSimultaneousTaskCount()[i].length; ++j) {
                            sb.append("\t").append("IMPLEMENTATION_INFO = [").append("\n");
                            sb.append("\t").append("\t").append("COREID = ").append(i).append("\n");
                            sb.append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                            sb.append("\t").append("\t").append("SIM_TASKS = ").append(rcr.requestedSimultaneousTaskCount()[i][j]).append("\n");
                            sb.append("\t").append("]").append("\n");
                        }
                    }
                    sb.append("]");
                    RESOURCES_LOGGER.debug(sb.toString());
                }
                ++createdCount;
            }
        }
        if (debug) {
            RESOURCES_LOGGER.debug("DEBUG_MSG = [\n\tIn order to be able to execute all cores, Resource Manager has asked for " + createdCount + " Cloud resources\n]");
        }
        return createdCount;
    }

    private static LinkedList<ConstraintsCore>[] getUnfulfilledConstraints() {
        int coreCount = CoreManager.getCoreCount();
        LinkedList[] unfulfilledConstraints = new LinkedList[coreCount];
        int[] maxSimTasks = ResourceManager.getTotalSlots();
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            unfulfilledConstraints[coreId] = new LinkedList();
            if (maxSimTasks[coreId] != 0) continue;
            List impls = CoreManager.getCoreImplementations((int)coreId);
            for (Implementation impl : impls) {
                if (impl.getTaskType() != Implementation.TaskType.METHOD) continue;
                MethodResourceDescription requirements = (MethodResourceDescription)impl.getRequirements();
                CloudMethodResourceDescription cd = new CloudMethodResourceDescription(requirements);
                ConstraintsCore cc = new ConstraintsCore(cd, coreId, unfulfilledConstraints[coreId]);
                unfulfilledConstraints[coreId].add(cc);
            }
        }
        return unfulfilledConstraints;
    }

    private static HashMap<String, LinkedList<ConstraintsCore>> classifyArchitectures(LinkedList<ConstraintsCore>[] constraints) {
        HashMap<String, LinkedList<ConstraintsCore>> archs = new HashMap<String, LinkedList<ConstraintsCore>>();
        for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
            if (constraints[coreId] == null) continue;
            for (ConstraintsCore cc : constraints[coreId]) {
                List runnableArchitectures = cc.desc.getArchitectures();
                for (String arch : runnableArchitectures) {
                    LinkedList<ConstraintsCore> archConstr = archs.get(arch);
                    if (archConstr == null) {
                        archConstr = new LinkedList();
                        archs.put(arch, archConstr);
                    }
                    archConstr.add(cc);
                }
            }
        }
        return archs;
    }

    private static void reduceArchitecturesConstraints(HashMap<String, LinkedList<ConstraintsCore>> arch2Ctrs) {
        for (LinkedList<ConstraintsCore> arch : arch2Ctrs.values()) {
            ConstraintsCore[] ctrs = new ConstraintsCore[arch.size()];
            int i = 0;
            for (ConstraintsCore cc : arch) {
                ctrs[i++] = cc;
            }
            Integer[] mergedTo = new Integer[arch.size()];
            for (i = 0; i < ctrs.length; ++i) {
                if (mergedTo[i] != null) continue;
                String OS = ctrs[i].desc.getOperatingSystemType();
                for (int j = i + 1; j < ctrs.length; ++j) {
                    if (mergedTo[j] != null || OS.compareTo(ctrs[j].desc.getOperatingSystemType()) != 0 && OS.compareTo("[unassigned]") != 0 && ctrs[j].desc.getOperatingSystemType().compareTo("[unassigned]") != 0) continue;
                    mergedTo[j] = i;
                    ctrs[i].join(ctrs[j]);
                    arch.remove(ctrs[j]);
                }
            }
        }
    }

    private static void reassignUnassignedConstraints(HashMap<String, LinkedList<ConstraintsCore>> arch2Ctrs) {
        LinkedList<ConstraintsCore> unassignedList = arch2Ctrs.get("[unassigned]");
        if (unassignedList == null) {
            return;
        }
        if (arch2Ctrs.size() == 1) {
            return;
        }
        if (arch2Ctrs.size() == 2) {
            for (Map.Entry<String, LinkedList<ConstraintsCore>> ctrs : arch2Ctrs.entrySet()) {
                if (((String)ctrs.getKey()).compareTo("[unassigned]") == 0) continue;
                ((LinkedList)ctrs.getValue()).addAll(unassignedList);
                return;
            }
        }
        LinkedList assignedList = new LinkedList();
        for (Map.Entry entry : arch2Ctrs.entrySet()) {
            if (((String)entry.getKey()).compareTo("[unassigned]") == 0) continue;
            assignedList.addAll((Collection)entry.getValue());
        }
        while (!unassignedList.isEmpty()) {
            ConstraintsCore unassigned = unassignedList.removeFirst();
            CloudMethodResourceDescription cloudMethodResourceDescription = unassigned.desc;
            String bestArch = "[unassigned]";
            Float bestDifference = Float.valueOf(Float.MAX_VALUE);
            for (ConstraintsCore assigned : assignedList) {
                List avail_archs;
                CloudMethodResourceDescription option = assigned.desc;
                float difference = cloudMethodResourceDescription.difference(option);
                if (bestDifference.floatValue() < 0.0f) {
                    if (!(difference < 0.0f) || !(difference > bestDifference.floatValue())) continue;
                    avail_archs = option.getArchitectures();
                    if (avail_archs != null && !avail_archs.isEmpty()) {
                        bestArch = (String)avail_archs.get(0);
                    }
                    bestDifference = Float.valueOf(difference);
                    continue;
                }
                if (!(difference < bestDifference.floatValue())) continue;
                avail_archs = option.getArchitectures();
                if (avail_archs != null && !avail_archs.isEmpty()) {
                    bestArch = (String)avail_archs.get(0);
                }
                bestDifference = Float.valueOf(difference);
            }
            LinkedList<Processor> procs = unassigned.desc.getProcessors();
            if (procs == null) {
                procs = new LinkedList<Processor>();
            }
            if (!procs.isEmpty()) {
                ((Processor)procs.get(0)).setArchitecture(bestArch);
            } else {
                Processor p = new Processor();
                p.setArchitecture(bestArch);
                procs.add(p);
            }
            arch2Ctrs.get(bestArch).add(unassigned);
        }
    }

    public static int addExtraNodes(int alreadyCreated) {
        int initialVMsCount = CloudManager.getInitialVMs();
        int vmCount = initialVMsCount - alreadyCreated;
        if (vmCount <= 0) {
            return 0;
        }
        if (debug) {
            RESOURCES_LOGGER.debug("DEBUG_MSG = [\n\tALREADY_CREATED_INSTANCES = " + alreadyCreated + "\n\tMAXIMUM_NEW_PETITIONS = " + vmCount + "\n]");
        }
        return vmCount;
    }

    private void applyPolicies(ResourceUser.WorkloadStatus workload) {
        long creationTime;
        int currentCloudVMCount = CloudManager.getCurrentVMCount();
        this.maxNumberOfVMs = CloudManager.getMaxVMs() > 0 ? Integer.valueOf(CloudManager.getMaxVMs()) : null;
        this.minNumberOfVMs = CloudManager.getMinVMs();
        try {
            creationTime = CloudManager.getNextCreationTime();
        }
        catch (Exception ex) {
            creationTime = 120000L;
        }
        int coreCount = workload.getCoreCount();
        int noResourceCount = workload.getNoResourceCount();
        int[] noResourceCounts = workload.getNoResourceCounts();
        long[] minCoreTime = new long[coreCount];
        long[] meanCoreTime = new long[coreCount];
        long[] maxCoreTime = new long[coreCount];
        long[] minRemainingCoreTime = new long[coreCount];
        long[] meanRemainingCoreTime = new long[coreCount];
        long[] maxRemainingCoreTime = new long[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            minCoreTime[coreId] = Math.min(workload.getCoreMinTime(coreId), creationTime);
            meanCoreTime[coreId] = Math.min(workload.getCoreMeanTime(coreId), creationTime);
            maxCoreTime[coreId] = Math.min(workload.getCoreMaxTime(coreId), creationTime);
            long meanRunningCoreTime = workload.getRunningCoreMeanTime(coreId);
            minRemainingCoreTime[coreId] = minCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(minCoreTime[coreId] - meanRunningCoreTime, creationTime);
            meanRemainingCoreTime[coreId] = meanCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(meanCoreTime[coreId] - meanRunningCoreTime, creationTime);
            maxRemainingCoreTime[coreId] = maxCoreTime[coreId] - meanRunningCoreTime < 0L ? 0L : Math.min(maxCoreTime[coreId] - meanRunningCoreTime, creationTime);
        }
        long[] runningMinCoreTime = new long[coreCount];
        long[] runningMeanCoreTime = new long[coreCount];
        long[] runningMaxCoreTime = new long[coreCount];
        long[] readyMinCoreTime = new long[coreCount];
        long[] readyMeanCoreTime = new long[coreCount];
        long[] readyMaxCoreTime = new long[coreCount];
        long[] pendingMinCoreTime = new long[coreCount];
        long[] pendingMeanCoreTime = new long[coreCount];
        long[] pendingMaxCoreTime = new long[coreCount];
        int[] realSlots = ResourceManager.getAvailableSlots();
        int[] totalSlots = ResourceManager.getTotalSlots();
        int[] runningCounts = workload.getRunningTaskCounts();
        int[] readyCounts = workload.getReadyCounts();
        int[] pendingCounts = new int[coreCount];
        long totalPendingTasks = 0L;
        for (int i = 0; i < coreCount; ++i) {
            runningMinCoreTime[i] = minRemainingCoreTime[i] * (long)runningCounts[i];
            readyMinCoreTime[i] = runningMinCoreTime[i] + minCoreTime[i] * (long)readyCounts[i];
            pendingMinCoreTime[i] = readyMinCoreTime[i] + minCoreTime[i] * (long)pendingCounts[i];
            runningMeanCoreTime[i] = meanRemainingCoreTime[i] * (long)runningCounts[i];
            readyMeanCoreTime[i] = runningMeanCoreTime[i] + meanCoreTime[i] * (long)readyCounts[i];
            pendingMeanCoreTime[i] = readyMeanCoreTime[i] + meanCoreTime[i] * (long)pendingCounts[i];
            runningMaxCoreTime[i] = maxRemainingCoreTime[i] * (long)runningCounts[i];
            readyMaxCoreTime[i] = runningMaxCoreTime[i] + maxCoreTime[i] * (long)readyCounts[i];
            pendingMaxCoreTime[i] = readyMaxCoreTime[i] + maxCoreTime[i] * (long)pendingCounts[i];
            totalPendingTasks += (long)pendingCounts[i];
        }
        if (debug) {
            LOGGER.debug("[Resource Optimizer] Applying VM optimization policies (currentVMs: " + currentCloudVMCount + " maxVMs: " + this.maxNumberOfVMs + " minVMs: " + this.minNumberOfVMs + ")");
        }
        if (!cleanUp) {
            LinkedList<Integer> requiredVMs = this.checkNeededMachines(noResourceCount, noResourceCounts, totalSlots);
            if (!requiredVMs.isEmpty()) {
                LOGGER.debug("[Resource Optimizer] Required VMs. Mandatory Increase");
                float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                for (Integer coreId : requiredVMs) {
                    creationRecommendations[coreId.intValue()] = Math.max(creationRecommendations[coreId], 1.0f);
                }
                this.mandatoryIncrease(creationRecommendations, requiredVMs);
                return;
            }
            if (this.minNumberOfVMs != null && this.minNumberOfVMs > currentCloudVMCount) {
                LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count smaller than minimum VMs (" + this.minNumberOfVMs + "). Mandatory Increase");
                float[] creationRecommendations = this.orderCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
                this.mandatoryIncrease(creationRecommendations, new LinkedList<Integer>());
                return;
            }
            if (this.maxNumberOfVMs != null && this.maxNumberOfVMs < currentCloudVMCount) {
                LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count bigger than maximum VMs (" + this.maxNumberOfVMs + "). Mandatory reduction");
                float[] destroyRecommendations = this.deleteRecommendations(coreCount, 10000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
                this.mandatoryReduction(destroyRecommendations);
                return;
            }
        }
        if ((this.maxNumberOfVMs == null || this.maxNumberOfVMs > currentCloudVMCount) && workload.getReadyCount() > 1) {
            LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count smaller than maximum VMs (" + this.maxNumberOfVMs + ")");
            float[] creationRecommendations = this.recommendCreations(coreCount, creationTime, readyMinCoreTime, readyMeanCoreTime, readyMaxCoreTime, totalSlots, realSlots);
            if (this.optionalIncrease(creationRecommendations)) {
                return;
            }
        }
        if ((this.minNumberOfVMs == null || this.minNumberOfVMs < currentCloudVMCount) && totalPendingTasks == 0L && workload.getReadyCount() == 0) {
            LOGGER.debug("[Resource Optimizer] Current VM (" + currentCloudVMCount + ") count bigger than minimum VMs (" + this.minNumberOfVMs + ")");
            float[] destroyRecommendations = this.deleteRecommendations(coreCount, 10000L, pendingMinCoreTime, pendingMeanCoreTime, pendingMaxCoreTime, totalSlots, realSlots);
            if (this.optionalReduction(destroyRecommendations)) {
                return;
            }
        }
    }

    private void mandatoryIncrease(float[] creationRecommendations, LinkedList<Integer> requiredVMs) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        boolean[] required = new boolean[creationRecommendations.length];
        Iterator iterator = requiredVMs.iterator();
        while (iterator.hasNext()) {
            int coreId = (Integer)iterator.next();
            required[coreId] = true;
        }
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            List impls = CoreManager.getCoreImplementations((int)coreId);
            for (Implementation impl : impls) {
                if (impl.getTaskType() == Implementation.TaskType.SERVICE) continue;
                MethodResourceDescription constraints = (MethodResourceDescription)((MethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription(constraints, creationRecommendations[coreId], false);
                pq.add(v);
            }
        }
        ResourceOptimizer.requestOneCreation(pq, true);
    }

    private boolean optionalIncrease(float[] creationRecommendations) {
        PriorityQueue<ValueResourceDescription> pq = new PriorityQueue<ValueResourceDescription>();
        for (int coreId = 0; coreId < creationRecommendations.length; ++coreId) {
            if (!(creationRecommendations[coreId] > 1.0f)) continue;
            List impls = CoreManager.getCoreImplementations((int)coreId);
            for (Implementation impl : impls) {
                if (impl.getTaskType() == Implementation.TaskType.SERVICE) continue;
                MethodResourceDescription constraints = (MethodResourceDescription)((MethodImplementation)impl).getRequirements();
                ValueResourceDescription v = new ValueResourceDescription(constraints, creationRecommendations[coreId], false);
                pq.add(v);
            }
        }
        ResourceCreationRequest rcr = ResourceOptimizer.requestOneCreation(pq, false);
        return rcr != null;
    }

    private boolean optionalReduction(float[] destroyRecommendations) {
        LinkedList<CloudMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations);
        Object[] nonCriticalSolution = CloudManager.getBestDestruction(nonCritical, destroyRecommendations);
        if (nonCriticalSolution == null) {
            return false;
        }
        CloudMethodWorker res = (CloudMethodWorker)((Object)nonCriticalSolution[0]);
        float[] record = (float[])nonCriticalSolution[1];
        CloudMethodResourceDescription rd = (CloudMethodResourceDescription)((Object)nonCriticalSolution[3]);
        if (debug) {
            LOGGER.debug("[Resource Optimizer] Best resource to remove is " + res.getName() + "and record is [" + record[0] + "," + record[1] + "," + record[2]);
        }
        if (record[1] > 0.0f && res.getUsedTaskCount() > 0) {
            LOGGER.debug("[Resource Optimizer] Optional destroy recommendation not applied");
            return false;
        }
        LOGGER.debug("[Resource Optimizer] Optional destroy recommendation applied");
        CloudMethodResourceDescription finalDescription = rd;
        finalDescription.setName(res.getName());
        CloudManager.destroyResources(res, finalDescription);
        return true;
    }

    private void mandatoryReduction(float[] destroyRecommendations) {
        CloudMethodResourceDescription rd;
        CloudMethodWorker res;
        boolean criticalIsBetter;
        LinkedList<CloudMethodWorker> critical = this.trimReductionOptions(ResourceManager.getCriticalDynamicResources(), destroyRecommendations);
        LinkedList<CloudMethodWorker> nonCritical = this.trimReductionOptions(ResourceManager.getNonCriticalDynamicResources(), destroyRecommendations);
        Object[] criticalSolution = CloudManager.getBestDestruction(critical, destroyRecommendations);
        Object[] nonCriticalSolution = CloudManager.getBestDestruction(nonCritical, destroyRecommendations);
        if (criticalSolution == null) {
            if (nonCriticalSolution == null) {
                return;
            }
            criticalIsBetter = false;
        } else if (nonCriticalSolution == null) {
            criticalIsBetter = true;
        } else {
            criticalIsBetter = false;
            float[] noncriticalValues = (float[])nonCriticalSolution[1];
            float[] criticalValues = (float[])criticalSolution[1];
            if (noncriticalValues[0] == criticalValues[0]) {
                if (noncriticalValues[1] == criticalValues[1]) {
                    if (noncriticalValues[2] < criticalValues[2]) {
                        criticalIsBetter = true;
                    }
                } else if (noncriticalValues[1] > criticalValues[1]) {
                    criticalIsBetter = true;
                }
            } else if (noncriticalValues[0] > criticalValues[0]) {
                criticalIsBetter = true;
            }
        }
        if (criticalIsBetter) {
            res = (CloudMethodWorker)((Object)criticalSolution[0]);
            rd = (CloudMethodResourceDescription)((Object)criticalSolution[3]);
        } else {
            if (nonCriticalSolution == null) {
                return;
            }
            res = (CloudMethodWorker)((Object)nonCriticalSolution[0]);
            rd = (CloudMethodResourceDescription)((Object)nonCriticalSolution[3]);
        }
        CloudMethodResourceDescription finalDescription = new CloudMethodResourceDescription(rd);
        finalDescription.setName(res.getName());
        CloudManager.destroyResources(res, finalDescription);
    }

    private LinkedList<CloudMethodWorker> trimReductionOptions(Collection<CloudMethodWorker> options, float[] recommendations) {
        if (debug) {
            LOGGER.debug("[Resource Optimizer] * Trimming reduction options");
        }
        LinkedList<CloudMethodWorker> resources = new LinkedList<CloudMethodWorker>();
        for (CloudMethodWorker resource : options) {
            boolean add;
            boolean aggressive = false;
            boolean bl = add = !aggressive;
            if (debug) {
                LOGGER.debug("\tEvaluating " + resource.getName() + ". Default reduction is " + add);
            }
            LinkedList<Integer> executableCores = resource.getExecutableCores();
            Iterator iterator = executableCores.iterator();
            while (iterator.hasNext()) {
                int coreId = (Integer)iterator.next();
                if (!aggressive && recommendations[coreId] < 1.0f) {
                    if (debug) {
                        LOGGER.debug("\t\tVM not removed because of not agressive and recomendations < 1 (" + recommendations[coreId] + ")");
                    }
                    add = false;
                    break;
                }
                if (!aggressive || !(recommendations[coreId] > 0.0f)) continue;
                if (debug) {
                    LOGGER.debug("\t\tVM removed because of agressive and recomendations > 0 (" + recommendations[coreId] + ")");
                }
                add = true;
                break;
            }
            if (!add) continue;
            if (debug) {
                LOGGER.debug("\t\tVM added to candidate to remove.");
            }
            resources.add(resource);
        }
        return resources;
    }

    private static ResourceCreationRequest requestOneCreation(PriorityQueue<ValueResourceDescription> pq, boolean include) {
        ValueResourceDescription v;
        while ((v = pq.poll()) != null) {
            ResourceCreationRequest rcr = CloudManager.askForResources(v.value < 1.0f ? 1 : (int)v.value, v.constraints, include);
            if (rcr == null) continue;
            RESOURCES_LOGGER.info("ORDER_CREATION = [\n\tTYPE = " + rcr.getRequested().getType() + "\n\tPROVIDER = " + rcr.getProvider() + "\n]");
            if (debug) {
                StringBuilder sb = new StringBuilder();
                sb.append("EXPECTED_SIM_TASKS = [").append("\n");
                for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
                    for (int j = 0; j < rcr.requestedSimultaneousTaskCount()[i].length; ++j) {
                        sb.append("\t").append("IMPLEMENTATION_INFO = [").append("\n");
                        sb.append("\t").append("\t").append("COREID = ").append(i).append("\n");
                        sb.append("\t").append("\t").append("IMPLID = ").append(j).append("\n");
                        sb.append("\t").append("\t").append("SIM_TASKS = ").append(rcr.requestedSimultaneousTaskCount()[i][j]).append("\n");
                        sb.append("\t").append("]").append("\n");
                    }
                }
                sb.append("]");
                RESOURCES_LOGGER.debug(sb.toString());
            }
            return rcr;
        }
        return null;
    }

    private LinkedList<Integer> checkNeededMachines(int noResourceCount, int[] noResourceCountPerCore, int[] slotCountPerCore) {
        LinkedList<Integer> needed = new LinkedList<Integer>();
        if (noResourceCount == 0) {
            return needed;
        }
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            if (noResourceCountPerCore[i] <= 0 || slotCountPerCore[i] != 0) continue;
            needed.add(i);
        }
        return needed;
    }

    private float[] recommendCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long totalTime;
            long embraceableLoad = totalTime = (long)totalSlots[coreId] * creationTime;
            long remainingLoad = aggregatedMeanCoreTime[coreId] - embraceableLoad;
            if (debug) {
                LOGGER.debug("[Resource Optimizer] * Calculating increase recomendations");
                LOGGER.debug("\tRemaining load = " + aggregatedMeanCoreTime[coreId] + "-( " + totalSlots[coreId] + " * " + creationTime + " ) = " + remainingLoad);
            }
            if (remainingLoad > 0L) {
                creations[coreId] = (int)(remainingLoad / creationTime);
                if (!debug) continue;
                LOGGER.debug("\tRecomended slots = " + creations[coreId] + " ( " + remainingLoad + " / " + creationTime + " )");
                continue;
            }
            creations[coreId] = 0.0f;
        }
        return creations;
    }

    private float[] orderCreations(int coreCount, long creationTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        float[] creations = new float[coreCount];
        int maxI = 0;
        float maxRatio = 0.0f;
        for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
            float ratio;
            if (aggregatedMeanCoreTime[i] <= 0L || totalSlots[i] <= 0 || !((ratio = (float)(aggregatedMeanCoreTime[i] / (long)totalSlots[i])) > maxRatio)) continue;
            maxI = i;
            maxRatio = ratio;
        }
        creations[maxI] = 1.0f;
        return creations;
    }

    private float[] deleteRecommendations(int coreCount, long limitTime, long[] aggregatedMinCoreTime, long[] aggregatedMeanCoreTime, long[] aggregatedMaxCoreTime, int[] totalSlots, int[] realSlots) {
        if (debug) {
            LOGGER.debug("[Resource Optimizer] * Delete Recomendations calculations:\n\tcoreCount: " + coreCount + " limitTime: " + limitTime);
        }
        float[] destructions = new float[coreCount];
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            long embraceableLoad = limitTime * (long)realSlots[coreId];
            if (embraceableLoad == 0L) {
                destructions[coreId] = 0.0f;
                if (!debug) continue;
                LOGGER.debug("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad);
                LOGGER.debug("\tdestructions [ " + coreId + "] = 0");
                continue;
            }
            if (aggregatedMinCoreTime[coreId] > 0L) {
                double unusedTime = (double)embraceableLoad / 2.0 - (double)aggregatedMeanCoreTime[coreId];
                destructions[coreId] = (float)(unusedTime / (double)limitTime);
                if (!debug) continue;
                LOGGER.debug("\tembraceableLoad [ " + coreId + "] = " + limitTime + " * " + realSlots[coreId] + " = " + embraceableLoad);
                LOGGER.debug("\tunused [ " + coreId + "] =  ( " + embraceableLoad + " / 2) - " + aggregatedMeanCoreTime[coreId] + " = " + unusedTime);
                LOGGER.debug("\tdestructions [ " + coreId + "] = " + destructions[coreId]);
                continue;
            }
            destructions[coreId] = embraceableLoad / limitTime;
        }
        return destructions;
    }

    private static class ValueResourceDescription
    implements Comparable<ValueResourceDescription> {
        private final MethodResourceDescription constraints;
        private final float value;
        private final boolean prioritary;

        public ValueResourceDescription(MethodResourceDescription constraints, float value, boolean prioritary) {
            this.constraints = constraints;
            this.value = value;
            this.prioritary = prioritary;
        }

        @Override
        public int compareTo(ValueResourceDescription o) {
            if (this.prioritary && !o.prioritary) {
                return 1;
            }
            if (!this.prioritary && o.prioritary) {
                return -1;
            }
            float dif = this.value - o.value;
            if (dif > 0.0f) {
                return 1;
            }
            if (dif < 0.0f) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.value + (this.prioritary ? "!" : "") + this.constraints;
        }
    }

    private static class ConstraintsCore {
        private CloudMethodResourceDescription desc;
        private LinkedList<ConstraintsCore>[] cores;

        public ConstraintsCore(CloudMethodResourceDescription desc, int core, LinkedList<ConstraintsCore> coreList) {
            this.desc = desc;
            this.cores = new LinkedList[CoreManager.getCoreCount()];
            this.cores[core] = coreList;
        }

        public void join(ConstraintsCore c2) {
            this.desc.increase((ResourceDescription)c2.desc);
            c2.desc = this.desc;
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] != null) {
                    if (c2.cores[coreId] != null) {
                        this.cores[coreId].remove(c2);
                        continue;
                    }
                    c2.cores[coreId] = this.cores[coreId];
                    continue;
                }
                this.cores[coreId] = c2.cores[coreId];
            }
        }

        public void confirmed() {
            for (int coreId = 0; coreId < CoreManager.getCoreCount(); ++coreId) {
                if (this.cores[coreId] == null) continue;
                this.cores[coreId].clear();
            }
        }

        public String toString() {
            LinkedList<Integer> cores = new LinkedList<Integer>();
            for (int i = 0; i < CoreManager.getCoreCount(); ++i) {
                if (this.cores[i] == null) continue;
                cores.add(i);
            }
            return this.desc.toString() + " achieves for cores " + cores;
        }
    }
}

