/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.slurm;

import es.bsc.conn.Connector;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.slurm.JobDescription;
import es.bsc.conn.clients.slurm.SlurmClient;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.InstallationDescription;
import es.bsc.conn.types.Processor;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SLURMConnector
extends Connector {
    private static final String RUNNING = "RUNNING";
    private static final String PENDING = "PENDING";
    private static final String FAILED = "FAILED";
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;
    private static final Logger logger = LogManager.getLogger("integratedtoolkit.Connectors.Conn.SLURM");
    private SlurmClient client;
    private final Map<String, HardwareDescription> vmidToHardwareRequest = new HashMap<String, HardwareDescription>();
    private final Map<String, SoftwareDescription> vmidToSoftwareRequest = new HashMap<String, SoftwareDescription>();
    private int currentNodes;
    private String logDir;

    public SLURMConnector(Map<String, String> props) throws ConnException {
        super(props);
        String masterName = props.get("master_name");
        if (masterName == null || masterName.isEmpty()) {
            throw new ConnException("Unable to get master_name. Property is empty");
        }
        String appLogdir = System.getProperty("it.appLogDir");
        if (appLogdir == null) {
            throw new ConnException("Unable to get app log dir");
        }
        File f = new File(appLogdir + File.separator + "slurm-conn-log");
        if (!f.mkdirs()) {
            throw new ConnException("Unable to create SLURM connector log dir");
        }
        this.logDir = f.getAbsolutePath();
        this.client = new SlurmClient(props.get("master_name"));
        this.currentNodes = 0;
    }

    @Override
    public Object create(HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop) throws ConnException {
        try {
            String jobName = this.appName + '-' + UUID.randomUUID().toString();
            String preferredHost = "";
            ++this.currentNodes;
            String jobId = this.client.createCompute(this.generateJobDescription(hd, sd), this.generateExecScript(jobName, hd, sd, prop));
            this.vmidToHardwareRequest.put(jobId, hd);
            this.vmidToSoftwareRequest.put(jobId, sd);
            VirtualResource vr = new VirtualResource(jobId, hd, sd, prop);
            return vr.getId();
        }
        catch (ConnClientException ce) {
            logger.error("Exception submitting vm creation", (Throwable)ce);
            --this.currentNodes;
            throw new ConnException(ce);
        }
        catch (Exception e) {
            logger.error("Exception submitting vm creation", (Throwable)e);
            throw new ConnException(e);
        }
    }

    private String generateExecScript(String jobName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop) throws ConnException {
        String stdFlags = "-e " + this.logDir + File.separator + jobName + ".err -o " + this.logDir + File.separator + jobName + ".out";
        InstallationDescription instDesc = sd.getInstallation();
        StringBuilder script = new StringBuilder("#!/bin/sh\n");
        String installDir = instDesc.getInstallDir();
        if (installDir == null && (installDir = System.getenv("IT_HOME")) == null) {
            throw new ConnException("Unable to get COMPSs installation directory");
        }
        if (hd.getImageName() != null && !hd.getImageName().isEmpty() && !hd.getImageName().equals("None")) {
            script.append("singularity exec " + hd.getImageName() + " " + installDir + "/Runtime/scripts/system/adaptors/nio/persistent_worker_starter.sh");
        } else {
            script.append(installDir + "/Runtime/scripts/system/adaptors/nio/persistent_worker_starter.sh");
        }
        String libPath = instDesc.getLibraryPath();
        if (libPath == null || libPath.isEmpty()) {
            libPath = this.getPWD();
        }
        script.append(" " + libPath);
        String appDir = instDesc.getAppDir();
        if (appDir == null || appDir.isEmpty()) {
            appDir = this.getPWD();
        }
        script.append(" " + appDir);
        String cp = instDesc.getClasspath();
        if (cp == null || cp.isEmpty()) {
            cp = this.getPWD();
        }
        script.append(" " + cp);
        String jvmOptsSize = prop.get("jvm_opts_size");
        if (jvmOptsSize == null || jvmOptsSize.isEmpty()) {
            jvmOptsSize = "0";
        }
        script.append(" " + jvmOptsSize);
        String jvmOptsStr = prop.get("jvm_opts_str");
        if (jvmOptsStr == null) {
            jvmOptsStr = "";
        }
        script.append(" " + jvmOptsStr);
        String workerDebug = prop.get("worker_debug");
        if (workerDebug == null || workerDebug.isEmpty() || workerDebug.equals("null")) {
            workerDebug = "false";
        }
        script.append(" " + workerDebug);
        script.append(" 5");
        script.append(" 5");
        script.append(" $SLURM_JOB_NODELIST");
        script.append(" 43001");
        String masterPort = prop.get("master_port");
        if (masterPort == null || masterPort.isEmpty() || masterPort.equals("null")) {
            masterPort = "43000";
        }
        script.append(" " + masterPort);
        script.append(" " + hd.getTotalComputingUnits());
        script.append(" " + hd.getTotalGPUComputingUnits());
        String cpuAff = prop.get("cpu_affinity");
        if (cpuAff == null || cpuAff.isEmpty() || cpuAff.equals("null")) {
            cpuAff = "automatic";
        }
        script.append(" " + cpuAff);
        String gpuAff = prop.get("gpu_affinity");
        if (gpuAff == null || gpuAff.isEmpty() || gpuAff.equals("null")) {
            gpuAff = "automatic";
        }
        script.append(" " + gpuAff);
        int limitOfTasks = instDesc.getLimitOfTasks();
        if (limitOfTasks < 0) {
            limitOfTasks = hd.getTotalComputingUnits();
        }
        script.append(" " + limitOfTasks);
        String uuid = System.getProperty("it.uuid");
        if (uuid == null || uuid.isEmpty() || uuid.equals("null")) {
            throw new ConnException("Unable to get uuid");
        }
        script.append(" " + uuid);
        String lang = System.getProperty("it.lang");
        if (lang == null || lang.isEmpty() || lang.equals("null")) {
            throw new ConnException("Unable to get lang");
        }
        script.append(" " + lang);
        script.append(" " + instDesc.getWorkingDir() + File.separator + uuid + File.separator + "$SLURM_JOB_NODELIST");
        script.append(" " + installDir);
        script.append(" " + appDir);
        script.append(" " + libPath);
        script.append(" " + cp);
        String pythonPath = instDesc.getPythonPath();
        if (pythonPath == null || pythonPath.isEmpty()) {
            pythonPath = this.getPWD();
        }
        script.append(" " + pythonPath);
        String tracing = System.getProperty("it.tracing");
        if (tracing == null || tracing.isEmpty() || tracing.equals("null")) {
            tracing = "0";
        }
        script.append(" " + tracing);
        String extraeFile = System.getProperty("it.extrae.file");
        if (extraeFile == null || extraeFile.isEmpty() || extraeFile.equals("null")) {
            extraeFile = "null";
        }
        script.append(" " + extraeFile);
        script.append(" " + (this.client.getInitialNodes() + this.currentNodes));
        String storageConf = System.getProperty("it.storage.conf");
        if (storageConf == null || storageConf.isEmpty() || storageConf.equals("null")) {
            storageConf = "null";
        }
        script.append(" " + storageConf);
        String executionType = System.getProperty("it.task.execution");
        if (executionType == null || executionType.isEmpty() || executionType.equals("null")) {
            executionType = "compss";
        }
        script.append(" " + storageConf);
        File runScript = new File(this.logDir + File.separator + "run_" + jobName);
        FileOutputStream fos = null;
        try {
            runScript.createNewFile();
            runScript.setExecutable(true);
            fos = new FileOutputStream(runScript);
            fos.write(script.toString().getBytes());
            String string = stdFlags + " " + runScript.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new ConnException("Exception writting script", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getPWD() throws ConnException {
        String pwd = System.getenv("PWD");
        if (pwd == null) {
            throw new ConnException("Unable to get PWD directory");
        }
        return pwd;
    }

    private JobDescription generateJobDescription(HardwareDescription hd, SoftwareDescription sd) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("NumNodes", "1");
        req.put("NumCPUs", Integer.toString(hd.getTotalComputingUnits()));
        if (hd.getMemorySize() > 0.0f) {
            req.put("mem", Integer.toString((int)hd.getMemorySize() * 1024));
        }
        int gpuUnits = 0;
        for (Processor p : hd.getProcessors()) {
            if (!p.getArchitecture().equals("GPU")) continue;
            gpuUnits += p.getComputingUnits();
        }
        if (gpuUnits > 0) {
            req.put("Gres", Integer.toString(gpuUnits));
        }
        return new JobDescription(req);
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        logger.debug("Waiting for creation " + id);
        String jobId = (String)id;
        logger.info("Waiting until node of job " + jobId + " is created");
        try {
            JobDescription jd = this.client.getJobDescription(jobId);
            logger.info("VM State is " + jd.getProperty("JobState"));
            int tries = 0;
            while (jd.getProperty("JobState") == null || !jd.getProperty("JobState").equals(RUNNING)) {
                if (jd.getProperty("JobState").equals(FAILED)) {
                    logger.error("Error waiting for VM Creation. Middleware has return an error state");
                    throw new ConnException("Error waiting for VM Creation. Middleware has return an error state");
                }
                if ((long)tries * 5L > 1800L) {
                    this.client.cancelJob(jobId);
                    this.vmidToHardwareRequest.remove(jobId);
                    this.vmidToSoftwareRequest.remove(jobId);
                    throw new ConnException("Maximum Job creation time reached.");
                }
                ++tries;
                Thread.sleep(5000L);
                jd = this.client.getJobDescription(jobId);
            }
            this.client.addNodesToMain(jobId, jd);
            VirtualResource vr = new VirtualResource();
            vr.setId(jobId);
            vr.setIp(jd.getNodeList().get(0));
            vr.setProperties(null);
            HardwareDescription hd = this.vmidToHardwareRequest.get(jobId);
            if (hd == null) {
                throw new ConnException("Unregistered hardware description for job " + jobId);
            }
            vr.setHd(hd);
            SoftwareDescription sd = this.vmidToSoftwareRequest.get(jobId);
            if (sd == null) {
                throw new ConnException("Unregistered software description for job " + jobId);
            }
            sd.setOperatingSystemType("Linux");
            vr.setSd(sd);
            return vr;
        }
        catch (ConnClientException | InterruptedException e) {
            logger.error("Exception waiting for VM Creation");
            throw new ConnException(e);
        }
    }

    @Override
    public void destroy(Object id) {
        String jobId = (String)id;
        logger.debug("Destroying VM " + jobId);
        try {
            this.client.deleteCompute(jobId);
            this.vmidToHardwareRequest.remove(jobId);
            this.vmidToSoftwareRequest.remove(jobId);
        }
        catch (ConnClientException cce) {
            logger.error("Exception waiting for VM Destruction", (Throwable)cce);
        }
        logger.debug("VM " + jobId + " destroyed.");
        --this.currentNodes;
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        return virtualResource.getHd().getPricePerUnit();
    }

    @Override
    public void close() {
    }
}

