/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.rocci;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.rocci.types.json.JSONResources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RocciClient {
    private static final Logger LOGGER = LogManager.getLogger("integratedtoolkit.Connectors.Conn.Clients.Rocci");
    private static final String JSON_RESOURCES_OPEN = "{\"resources\":";
    private static final String JSON_RESOURCES_CLOSE = "}";
    private final String cmdLine;
    private final String attributes;

    public RocciClient(List<String> cmdString, String attr) {
        LOGGER.info("Initializing RocciClient");
        StringBuilder sb = new StringBuilder();
        for (String s : cmdString) {
            sb.append(s).append(" ");
        }
        this.cmdLine = sb.toString();
        this.attributes = attr;
    }

    public String describeResource(String resourceId) throws ConnClientException {
        String resDesc = "";
        String cmd = this.cmdLine + "--action describe" + " --resource " + resourceId;
        try {
            LOGGER.debug("Describe CMD: " + cmd);
            resDesc = this.executeCmd(cmd);
        }
        catch (ConnClientException ie) {
            LOGGER.error("Error on Describe CMD", (Throwable)ie);
            throw new ConnClientException(ie);
        }
        return resDesc;
    }

    public String getResourceStatus(String resourceId) throws ConnClientException {
        LOGGER.debug("Get Status from Resource " + resourceId);
        String jsonOutput = this.describeResource(resourceId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        jsonOutput = JSON_RESOURCES_OPEN + jsonOutput + JSON_RESOURCES_CLOSE;
        JSONResources obj = gson.fromJson(jsonOutput, JSONResources.class);
        return obj.getResources().get(0).getAttributes().getOcci().getCompute().getState();
    }

    public String getResourceAddress(String resourceId) throws ConnClientException {
        LOGGER.debug("Get Address from Resource " + resourceId);
        String resIP = null;
        String jsonOutput = this.describeResource(resourceId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        jsonOutput = JSON_RESOURCES_OPEN + jsonOutput + JSON_RESOURCES_CLOSE;
        JSONResources obj = gson.fromJson(jsonOutput, JSONResources.class);
        for (int i = 0; i < obj.getResources().get(0).getLinks().size(); ++i) {
            if (obj.getResources().get(0).getLinks().get(i).getAttributes().getOcci().getNetworkinterface() == null) continue;
            resIP = obj.getResources().get(0).getLinks().get(i).getAttributes().getOcci().getNetworkinterface().getAddress();
            break;
        }
        return resIP;
    }

    public Object[] getHardwareDescription(String resourceId) throws ConnClientException {
        LOGGER.debug("Get Hardware description from Resource " + resourceId);
        String jsonOutput = this.describeResource(resourceId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        jsonOutput = JSON_RESOURCES_OPEN + jsonOutput + JSON_RESOURCES_CLOSE;
        JSONResources obj = gson.fromJson(jsonOutput, JSONResources.class);
        Float memory = null;
        for (int i = 0; i < obj.getResources().get(0).getLinks().size(); ++i) {
            if (obj.getResources().get(0).getAttributes().getOcci().getCompute().getMemory() == null) continue;
            memory = obj.getResources().get(0).getAttributes().getOcci().getCompute().getMemory();
            break;
        }
        Object storage = null;
        Integer cores = null;
        for (int i = 0; i < obj.getResources().get(0).getLinks().size(); ++i) {
            if (obj.getResources().get(0).getAttributes().getOcci().getCompute().getCores() == null) continue;
            cores = obj.getResources().get(0).getAttributes().getOcci().getCompute().getCores();
            break;
        }
        String architecture = null;
        for (int i = 0; i < obj.getResources().get(0).getLinks().size(); ++i) {
            if (obj.getResources().get(0).getAttributes().getOcci().getCompute().getArchitecture() == null) continue;
            architecture = obj.getResources().get(0).getAttributes().getOcci().getCompute().getArchitecture();
            break;
        }
        Float speed = null;
        for (int i = 0; i < obj.getResources().get(0).getLinks().size(); ++i) {
            if (obj.getResources().get(0).getAttributes().getOcci().getCompute().getSpeed() == null) continue;
            speed = obj.getResources().get(0).getAttributes().getOcci().getCompute().getSpeed();
            break;
        }
        return new Object[]{memory, storage, cores, architecture, speed};
    }

    public void deleteCompute(String resourceId) {
        String cmd = this.cmdLine + "--action delete" + " --resource " + resourceId;
        try {
            this.executeCmd(cmd);
        }
        catch (ConnClientException e) {
            LOGGER.error("Cannot delete resource with id " + resourceId, (Throwable)e);
        }
    }

    public String createCompute(String osTPL, String resourceTPL) {
        String s = "";
        String cmd = this.cmdLine + " --action create" + " --resource compute -M os_tpl#" + osTPL + " -M resource_tpl#" + resourceTPL + " --attribute occi.core.title=\"" + this.attributes + "\"";
        try {
            LOGGER.debug("Create CMD: " + cmd);
            s = this.executeCmd(cmd);
        }
        catch (ConnClientException e) {
            LOGGER.error("Error on Create CMD", (Throwable)e);
        }
        return s;
    }

    public void attachLink(String resourceId, String link) {
        String cmd = this.cmdLine + "--resource " + resourceId + " --action link --link " + link;
        try {
            this.executeCmd(cmd);
        }
        catch (ConnClientException e) {
            LOGGER.error("Cannot attach link " + link + " to resource with id " + resourceId, (Throwable)e);
        }
    }

    private String executeCmd(String cmdArgs) throws ConnClientException {
        Object[] cmd = new String[]{"/bin/bash", "-c", "occi " + cmdArgs};
        try {
            String line;
            LOGGER.info("Execute CMD: " + Arrays.toString(cmd));
            Process p = Runtime.getRuntime().exec((String[])cmd);
            BufferedReader stdInput1 = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError1 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            LOGGER.debug("Execute CMD Output:");
            StringBuilder cmdResult = new StringBuilder();
            while ((line = stdInput1.readLine()) != null) {
                LOGGER.debug(line);
                cmdResult.append(line);
            }
            LOGGER.error("Execute CMD Error:");
            while ((line = stdError1.readLine()) != null) {
                LOGGER.error(line);
            }
            p.waitFor();
            LOGGER.info("Excute CMD exitValue: " + p.exitValue());
            LOGGER.info("__________________________________________");
            return cmdResult.toString();
        }
        catch (IOException | InterruptedException e) {
            throw new ConnClientException(e);
        }
    }
}

