/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.fifoDataScheduler;

import integratedtoolkit.components.impl.ResourceScheduler;
import integratedtoolkit.scheduler.exceptions.BlockedActionException;
import integratedtoolkit.scheduler.exceptions.UnassignedActionException;
import integratedtoolkit.scheduler.fifoDataScheduler.FIFODataResourceScheduler;
import integratedtoolkit.scheduler.readyScheduler.ReadyScheduler;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.FIFODataScore;
import integratedtoolkit.scheduler.types.ObjectValue;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.scheduler.types.Score;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.Worker;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.LinkedList;
import java.util.PriorityQueue;

public class FIFODataScheduler<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends ReadyScheduler<P, T, I> {
    public ResourceScheduler<P, T, I> generateSchedulerForResource(Worker<T, I> w) {
        return new FIFODataResourceScheduler(w);
    }

    public FIFODataScore generateActionScore(AllocatableAction<P, T, I> action) {
        return new FIFODataScore(action.getPriority(), 0.0, 0.0, 0.0);
    }

    protected void purgeFreeActions(LinkedList<AllocatableAction<P, T, I>> dataFreeActions, LinkedList<AllocatableAction<P, T, I>> resourceFreeActions, LinkedList<AllocatableAction<P, T, I>> blockedCandidates, ResourceScheduler<P, T, I> resource) {
        LOGGER.debug("[DataScheduler] Treating dependency free actions");
        PriorityQueue<ObjectValue> executableActions = new PriorityQueue<ObjectValue>();
        for (AllocatableAction allocatableAction : dataFreeActions) {
            FIFODataScore actionScore = this.generateActionScore((AllocatableAction<P, T, I>)allocatableAction);
            FIFODataScore fullScore = (FIFODataScore)allocatableAction.schedulingScore(resource, (Score)actionScore);
            ObjectValue obj = new ObjectValue((Object)allocatableAction, (Score)fullScore);
            executableActions.add(obj);
        }
        dataFreeActions.clear();
        while (!executableActions.isEmpty()) {
            ObjectValue obj = (ObjectValue)executableActions.poll();
            AllocatableAction allocatableAction = (AllocatableAction)obj.getObject();
            try {
                this.scheduleAction(allocatableAction, resource, obj.getScore());
                this.tryToLaunch(allocatableAction);
            }
            catch (BlockedActionException e) {
                this.removeFromReady(allocatableAction);
                this.addToBlocked(allocatableAction);
            }
            catch (UnassignedActionException e) {
                dataFreeActions.add(allocatableAction);
            }
        }
        LinkedList unassignedReadyActions = this.getUnassignedActions();
        this.unassignedReadyActions.removeAllActions();
        dataFreeActions.addAll(unassignedReadyActions);
    }
}

