/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.io.cpi.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import org.gridlab.gat.AdaptorNotApplicableException;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.io.cpi.FileInputStreamCpi;

public class LocalFileInputStreamAdaptor
extends FileInputStreamCpi {
    FileInputStream in;

    public static String getDescription() {
        return "The Local FileInputStream Adaptor is a simple wrapper around the java.io.FileInputStream object.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = FileInputStreamCpi.getSupportedCapabilities();
        capabilities.put("available", true);
        capabilities.put("close", true);
        capabilities.put("mark", true);
        capabilities.put("markSupported", true);
        capabilities.put("read", true);
        capabilities.put("reset", true);
        capabilities.put("skip", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"local", "file", ""};
    }

    public LocalFileInputStreamAdaptor(GATContext gatContext, URI location) throws IOException, GATObjectCreationException {
        super(gatContext, location);
        if (!location.refersToLocalHost()) {
            throw new AdaptorNotApplicableException("Cannot use remote files with the local file input stream adaptor");
        }
        String path = location.getPath();
        File f = new File(path);
        this.in = new FileInputStream(f);
    }

    public int available() throws GATInvocationException {
        try {
            return this.in.available();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileInputStream", (Throwable)e);
        }
    }

    public void close() throws GATInvocationException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileInputStream", (Throwable)e);
        }
    }

    public synchronized void mark(int arg0) {
        this.in.mark(arg0);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws GATInvocationException {
        try {
            return this.in.read();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileInputStream", (Throwable)e);
        }
    }

    public int read(byte[] b, int offset, int len) throws GATInvocationException {
        try {
            return this.in.read(b, offset, len);
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileInputStream", (Throwable)e);
        }
    }

    public int read(byte[] arg0) throws GATInvocationException {
        try {
            return this.in.read(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileInputStream", (Throwable)e);
        }
    }

    public synchronized void reset() throws GATInvocationException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileInputStream", (Throwable)e);
        }
    }

    public long skip(long arg0) throws GATInvocationException {
        try {
            return this.in.skip(arg0);
        }
        catch (IOException e) {
            throw new GATInvocationException("LocalFileInputStream", (Throwable)e);
        }
    }
}

