/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunProcess {
    private final ProcessBuilder builder;
    private int exitStatus = -1;
    private Process p = null;
    private buf proc_out;
    private buf proc_err;

    public RunProcess(String ... command) {
        this.builder = new ProcessBuilder(command);
    }

    public RunProcess(List<String> command) {
        this.builder = new ProcessBuilder(command);
    }

    public void run() {
        try {
            this.p = this.builder.start();
        }
        catch (Exception e) {
            this.proc_err = new buf(("Could not execute cmd: " + this.builder.command().toString() + " " + e).getBytes());
            return;
        }
        this.dealWithResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithResult() {
        this.proc_out = new buf(this.p.getInputStream());
        this.proc_err = new buf(this.p.getErrorStream());
        Proc stdoutreader = new Proc(this.proc_out);
        Proc errorreader = new Proc(this.proc_err);
        stdoutreader.setDaemon(true);
        errorreader.setDaemon(true);
        stdoutreader.start();
        errorreader.start();
        boolean interrupted = false;
        do {
            try {
                interrupted = false;
                this.exitStatus = this.p.waitFor();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (interrupted);
        buf buf2 = this.proc_out;
        synchronized (buf2) {
            while (!this.proc_out.done) {
                try {
                    this.proc_out.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        buf2 = this.proc_err;
        synchronized (buf2) {
            while (!this.proc_err.done) {
                try {
                    this.proc_err.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (this.p != null) {
            RunProcess.close(this.p.getOutputStream());
            RunProcess.close(this.p.getInputStream());
            RunProcess.close(this.p.getErrorStream());
            this.p.destroy();
        }
    }

    private static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte[] getStdout() {
        if (this.proc_out == null) {
            return new byte[0];
        }
        byte[] b = new byte[this.proc_out.sz];
        System.arraycopy(this.proc_out.buffer, 0, b, 0, this.proc_out.sz);
        return b;
    }

    public byte[] getStderr() {
        if (this.proc_err == null) {
            return new byte[0];
        }
        byte[] b = new byte[this.proc_err.sz];
        System.arraycopy(this.proc_err.buffer, 0, b, 0, this.proc_err.sz);
        return b;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public List<String> command() {
        return this.builder.command();
    }

    public RunProcess command(List<String> command) {
        this.builder.command(command);
        return this;
    }

    public RunProcess command(String ... command) {
        this.builder.command(command);
        return this;
    }

    public File directory() {
        return this.builder.directory();
    }

    public ProcessBuilder directory(File directory) {
        return this.builder.directory(directory);
    }

    public Map<String, String> environment() {
        return this.builder.environment();
    }

    public boolean redirectErrorStream() {
        return this.builder.redirectErrorStream();
    }

    public RunProcess redirectErrorStream(boolean redirectErrorStream) {
        this.builder.redirectErrorStream(redirectErrorStream);
        return this;
    }

    public Process start() throws IOException {
        return this.builder.start();
    }

    private static class Proc
    extends Thread {
        buf b;

        Proc(buf b) {
            this.b = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean must_read;
            do {
                must_read = false;
                if (this.b.sz == this.b.buffer.length) {
                    byte[] newbuf = new byte[2 * this.b.buffer.length];
                    System.arraycopy(this.b.buffer, 0, newbuf, 0, this.b.buffer.length);
                    this.b.buffer = newbuf;
                }
                int ro = 0;
                try {
                    ro = this.b.s.read(this.b.buffer, this.b.sz, this.b.buffer.length - this.b.sz);
                }
                catch (IOException ex) {
                    ro = -1;
                }
                if (ro != -1) {
                    this.b.sz += ro;
                }
                if (ro < 0) continue;
                must_read = true;
            } while (must_read);
            buf buf2 = this.b;
            synchronized (buf2) {
                this.b.done = true;
                this.b.notifyAll();
            }
        }
    }

    private static class buf {
        public InputStream s;
        public byte[] buffer = new byte[4096];
        public int sz = 0;
        public boolean done = false;

        buf(InputStream s) {
            this.s = s;
        }

        buf(byte[] b) {
            this.buffer = b;
            this.sz = b.length;
            this.done = true;
        }
    }
}

