/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.fullGraphScheduler;

import integratedtoolkit.components.impl.ResourceScheduler;
import integratedtoolkit.scheduler.exceptions.BlockedActionException;
import integratedtoolkit.scheduler.exceptions.InvalidSchedulingException;
import integratedtoolkit.scheduler.exceptions.UnassignedActionException;
import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphResourceScheduler;
import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphScheduler;
import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphSchedulingInformation;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.FullGraphScore;
import integratedtoolkit.scheduler.types.OptimizationWorker;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.concurrent.Semaphore;

public class ScheduleOptimizer<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
extends Thread {
    private static final long OPTIMIZATION_THRESHOLD = 5000L;
    private FullGraphScheduler<P, T, I> scheduler;
    private boolean stop = false;
    private Semaphore sem = new Semaphore(0);
    private FullGraphScore<P, T, I> dummyScore = new FullGraphScore(0.0, 0.0, 0.0, 0.0, 0.0);

    public ScheduleOptimizer(FullGraphScheduler<P, T, I> scheduler) {
        this.setName("ScheduleOptimizer");
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        long lastUpdate = System.currentTimeMillis();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        while (!this.stop) {
            long optimizationTS = System.currentTimeMillis();
            Collection workers = this.scheduler.getWorkers();
            this.globalOptimization(optimizationTS, workers);
            this.waitForNextIteration(lastUpdate);
            lastUpdate = optimizationTS;
        }
        this.sem.release();
    }

    public void shutdown() throws InterruptedException {
        this.stop = true;
        this.interrupt();
        this.sem.acquire();
    }

    private void waitForNextIteration(long lastUpdate) {
        long difference = 5000L - (System.currentTimeMillis() - lastUpdate);
        if (difference > 0L) {
            try {
                Thread.sleep(difference);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void globalOptimization(long optimizationTS, Collection<ResourceScheduler<P, T, I>> workers) {
        int workersCount = workers.size();
        if (workersCount == 0) {
            return;
        }
        OptimizationWorker[] optimizedWorkers = new OptimizationWorker[workersCount];
        LinkedList<OptimizationWorker<P, T, I>> receivers = new LinkedList<OptimizationWorker<P, T, I>>();
        int index = 0;
        for (ResourceScheduler<P, T, I> rs : workers) {
            optimizedWorkers[index] = new OptimizationWorker((FullGraphResourceScheduler)rs);
            ++index;
        }
        boolean hasDonated = true;
        while (hasDonated) {
            AllocatableAction<P, T, I> candidate;
            optimizationTS = System.currentTimeMillis();
            hasDonated = false;
            for (int i = 0; i < workersCount; ++i) {
                optimizedWorkers[i].localOptimization(optimizationTS);
            }
            OptimizationWorker<P, T, I> donor = this.determineDonorAndReceivers(optimizedWorkers, receivers);
            while (!hasDonated && (candidate = donor.pollDonorAction()) != null) {
                for (OptimizationWorker optimizationWorker : receivers) {
                    if (!this.move(candidate, donor, optimizationWorker)) continue;
                    hasDonated = true;
                }
            }
        }
    }

    public OptimizationWorker<P, T, I> determineDonorAndReceivers(OptimizationWorker<P, T, I>[] workers, LinkedList<OptimizationWorker<P, T, I>> receivers) {
        OptimizationWorker<P, T, I> ow;
        receivers.clear();
        PriorityQueue<OptimizationWorker<P, T, I>> receiversPQ = new PriorityQueue<OptimizationWorker<P, T, I>>(1, ScheduleOptimizer.getReceptionComparator());
        long topIndicator = Long.MIN_VALUE;
        OptimizationWorker<P, T, I> top = null;
        for (OptimizationWorker<P, T, I> ow2 : workers) {
            long indicator = ow2.getDonationIndicator();
            if (topIndicator > indicator) {
                receiversPQ.add(ow2);
                continue;
            }
            topIndicator = indicator;
            if (top != null) {
                receiversPQ.add(top);
            }
            top = ow2;
        }
        while ((ow = receiversPQ.poll()) != null) {
            receivers.add(ow);
        }
        return top;
    }

    public static <P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> Comparator<AllocatableAction<P, T, I>> getSelectionComparator() {
        return new Comparator<AllocatableAction<P, T, I>>(){

            @Override
            public int compare(AllocatableAction<P, T, I> action1, AllocatableAction<P, T, I> action2) {
                int priority = Integer.compare(action1.getPriority(), action2.getPriority());
                if (priority == 0) {
                    return Long.compare(action1.getId(), action2.getId());
                }
                return -priority;
            }
        };
    }

    public static <P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> Comparator<AllocatableAction<P, T, I>> getDonationComparator() {
        return new Comparator<AllocatableAction<P, T, I>>(){

            @Override
            public int compare(AllocatableAction<P, T, I> action1, AllocatableAction<P, T, I> action2) {
                FullGraphSchedulingInformation action1DSI = (FullGraphSchedulingInformation)action1.getSchedulingInfo();
                FullGraphSchedulingInformation action2DSI = (FullGraphSchedulingInformation)action2.getSchedulingInfo();
                int priority = Long.compare(action2DSI.getExpectedEnd(), action1DSI.getExpectedEnd());
                if (priority == 0) {
                    return Long.compare(action1.getId(), action2.getId());
                }
                return priority;
            }
        };
    }

    public static <P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> Comparator<OptimizationWorker<P, T, I>> getReceptionComparator() {
        return new Comparator<OptimizationWorker<P, T, I>>(){

            @Override
            public int compare(OptimizationWorker<P, T, I> worker1, OptimizationWorker<P, T, I> worker2) {
                return Long.compare(worker1.getDonationIndicator(), worker2.getDonationIndicator());
            }
        };
    }

    private boolean move(AllocatableAction<P, T, I> action, OptimizationWorker<P, T, I> donor, OptimizationWorker<P, T, I> receiver) {
        LinkedList dataPreds = action.getDataPredecessors();
        long dataAvailable = 0L;
        try {
            for (AllocatableAction dataPred : dataPreds) {
                FullGraphSchedulingInformation dsi = (FullGraphSchedulingInformation)dataPred.getSchedulingInfo();
                dataAvailable = Math.max(dataAvailable, dsi.getExpectedEnd());
            }
        }
        catch (ConcurrentModificationException cme) {
            dataAvailable = 0L;
            dataPreds = action.getDataPredecessors();
        }
        Implementation bestImpl = null;
        long bestTime = Long.MAX_VALUE;
        LinkedList impls = action.getCompatibleImplementations(receiver.getResource());
        for (Implementation impl : impls) {
            Profile p = receiver.getResource().getProfile(impl);
            long avgTime = p.getAverageExecutionTime();
            if (avgTime >= bestTime) continue;
            bestTime = avgTime;
            bestImpl = impl;
        }
        FullGraphSchedulingInformation dsi = (FullGraphSchedulingInformation)action.getSchedulingInfo();
        long currentEnd = dsi.getExpectedEnd();
        if (bestImpl != null && currentEnd > receiver.getResource().getLastGapExpectedStart() + bestTime) {
            this.unschedule(action);
            this.schedule(action, bestImpl, receiver);
            return true;
        }
        return false;
    }

    public void schedule(AllocatableAction<P, T, I> action, I impl, OptimizationWorker<P, T, I> ow) {
        try {
            action.schedule(ow.getResource(), impl);
            action.tryToLaunch();
        }
        catch (InvalidSchedulingException ise) {
            try {
                long actionScore = FullGraphScore.getActionScore(action);
                long dataTime = this.dummyScore.getDataPredecessorTime(action.getDataPredecessors());
                FullGraphScore aScore = new FullGraphScore(actionScore, (double)dataTime, 0.0, 0.0, 0.0);
                boolean keepTrying = true;
                for (int i = 0; i < action.getConstrainingPredecessors().size() && keepTrying; ++i) {
                    AllocatableAction pre = (AllocatableAction)action.getConstrainingPredecessors().get(i);
                    action.schedule(pre.getAssignedResource(), aScore);
                    try {
                        action.tryToLaunch();
                        keepTrying = false;
                        continue;
                    }
                    catch (InvalidSchedulingException ise2) {
                        keepTrying = true;
                    }
                }
            }
            catch (BlockedActionException | UnassignedActionException throwable) {
            }
        }
        catch (BlockedActionException | UnassignedActionException throwable) {
            // empty catch block
        }
    }

    public void unschedule(AllocatableAction<P, T, I> action) {
        FullGraphResourceScheduler resource = (FullGraphResourceScheduler)action.getAssignedResource();
        resource.unscheduleAction(action);
    }
}

