/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.types;

import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphSchedulingInformation;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.Gap;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.Iterator;
import java.util.LinkedList;

public class LocalOptimizationState<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> {
    private final long updateId;
    private final LinkedList<Gap<P, T, I>> gaps = new LinkedList();
    private AllocatableAction<P, T, I> action = null;
    private ResourceDescription missingResources;
    private long topStartTime;

    public LocalOptimizationState(long updateId, ResourceDescription rd) {
        this.updateId = updateId;
        Gap g = new Gap(0L, Long.MAX_VALUE, null, rd.copy(), 0);
        this.gaps.add(g);
    }

    public long getId() {
        return this.updateId;
    }

    public LinkedList<Gap<P, T, I>> reserveResources(ResourceDescription resources, long startTime) {
        LinkedList<Gap<P, T, I>> previousGaps = new LinkedList<Gap<P, T, I>>();
        ResourceDescription requirements = resources.copy();
        Iterator gapIt = this.gaps.iterator();
        while (gapIt.hasNext() && !requirements.isDynamicUseless()) {
            Gap g = (Gap)gapIt.next();
            if (!this.checkGapForReserve(g, requirements, startTime, previousGaps)) continue;
            gapIt.remove();
        }
        return previousGaps;
    }

    private boolean checkGapForReserve(Gap<P, T, I> g, ResourceDescription requirements, long reserveStart, LinkedList<Gap<P, T, I>> previousGaps) {
        FullGraphSchedulingInformation gapDSI;
        boolean remove = false;
        AllocatableAction<P, T, I> gapAction = g.getOrigin();
        ResourceDescription rd = g.getResources();
        ResourceDescription reduction = ResourceDescription.reduceCommonDynamics((ResourceDescription)rd, (ResourceDescription)requirements);
        Gap<P, T, I> tmpGap = new Gap<P, T, I>(g.getInitialTime(), reserveStart, g.getOrigin(), reduction, 0);
        previousGaps.add(tmpGap);
        if (gapAction != null) {
            gapDSI = (FullGraphSchedulingInformation)gapAction.getSchedulingInfo();
            gapDSI.addGap();
        }
        if (rd.isDynamicUseless()) {
            remove = true;
            if (gapAction != null) {
                gapDSI = (FullGraphSchedulingInformation)gapAction.getSchedulingInfo();
                gapDSI.removeGap();
            }
        }
        return remove;
    }

    public void releaseResources(long expectedStart, AllocatableAction<P, T, I> action) {
        Gap<P, T, I> gap = new Gap<P, T, I>(expectedStart, Long.MAX_VALUE, action, (ResourceDescription)action.getAssignedImplementation().getRequirements(), 0);
        FullGraphSchedulingInformation dsi = (FullGraphSchedulingInformation)action.getSchedulingInfo();
        dsi.addGap();
        this.gaps.add(gap);
        if (this.missingResources != null) {
            ResourceDescription empty = gap.getResources().copy();
            this.topStartTime = gap.getInitialTime();
            ResourceDescription.reduceCommonDynamics((ResourceDescription)empty, (ResourceDescription)this.missingResources);
        }
    }

    public void replaceAction(AllocatableAction<P, T, I> action) {
        this.action = action;
        if (this.action != null) {
            this.missingResources = this.action.getAssignedImplementation().getRequirements().copy();
            for (Gap gap : this.gaps) {
                ResourceDescription empty = gap.getResources().copy();
                this.topStartTime = gap.getInitialTime();
                ResourceDescription.reduceCommonDynamics((ResourceDescription)empty, (ResourceDescription)this.missingResources);
                if (!this.missingResources.isDynamicUseless()) continue;
                break;
            }
        } else {
            this.missingResources = null;
            this.topStartTime = 0L;
        }
    }

    public void addTmpGap(Gap<P, T, I> g) {
        AllocatableAction<P, T, I> gapAction = g.getOrigin();
        FullGraphSchedulingInformation gapDSI = (FullGraphSchedulingInformation)gapAction.getSchedulingInfo();
        gapDSI.addGap();
    }

    public void replaceTmpGap(Gap<P, T, I> gap, Gap<P, T, I> previousGap) {
    }

    public void removeTmpGap(Gap<P, T, I> g) {
        AllocatableAction<P, T, I> gapAction = g.getOrigin();
        if (gapAction != null) {
            FullGraphSchedulingInformation gapDSI = (FullGraphSchedulingInformation)gapAction.getSchedulingInfo();
            gapDSI.removeGap();
            if (!gapDSI.hasGaps()) {
                gapDSI.unlock();
            }
        }
    }

    public AllocatableAction<P, T, I> getAction() {
        return this.action;
    }

    public long getActionStartTime() {
        return Math.max(this.topStartTime, ((FullGraphSchedulingInformation)this.action.getSchedulingInfo()).getExpectedStart());
    }

    public boolean canActionRun() {
        if (this.missingResources != null) {
            return this.missingResources.isDynamicUseless();
        }
        return false;
    }

    public boolean areGaps() {
        return !this.gaps.isEmpty();
    }

    public Gap<P, T, I> peekFirstGap() {
        return this.gaps.peekFirst();
    }

    public void pollGap() {
        this.gaps.removeFirst();
    }

    public LinkedList<Gap<P, T, I>> getGaps() {
        return this.gaps;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Optimization State at " + this.updateId + "\n");
        sb.append("\tGaps:\n");
        for (Gap gap : this.gaps) {
            sb.append("\t\t").append(gap).append("\n");
        }
        sb.append("\tTopAction:").append(this.action).append("\n");
        sb.append("\tMissing To Run:").append(this.missingResources).append("\n");
        sb.append("\tExpected Start:").append(this.topStartTime).append("\n");
        return sb.toString();
    }
}

