/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.types;

import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphResourceScheduler;
import integratedtoolkit.scheduler.fullGraphScheduler.ScheduleOptimizer;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.PriorityQueue;

public class OptimizationWorker<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>> {
    private FullGraphResourceScheduler<P, T, I> resource;
    private PriorityQueue<AllocatableAction<P, T, I>> donorActions;

    public OptimizationWorker(FullGraphResourceScheduler<P, T, I> resource) {
        this.resource = resource;
    }

    public void localOptimization(long optimizationTS) {
        this.donorActions = this.resource.localOptimization(optimizationTS, ScheduleOptimizer.getSelectionComparator(), ScheduleOptimizer.getDonationComparator());
    }

    public AllocatableAction<P, T, I> pollDonorAction() {
        return this.donorActions.poll();
    }

    public long getDonationIndicator() {
        return this.resource.getLastGapExpectedStart();
    }

    public String getName() {
        return this.resource.getName();
    }

    public FullGraphResourceScheduler<P, T, I> getResource() {
        return this.resource;
    }
}

