/*
 * Decompiled with CFR 0.152.
 */
package integratedtoolkit.scheduler.types;

import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphResourceScheduler;
import integratedtoolkit.scheduler.fullGraphScheduler.FullGraphSchedulingInformation;
import integratedtoolkit.scheduler.types.AllocatableAction;
import integratedtoolkit.scheduler.types.Gap;
import integratedtoolkit.scheduler.types.LocalOptimizationState;
import integratedtoolkit.scheduler.types.PriorityActionSet;
import integratedtoolkit.scheduler.types.Profile;
import integratedtoolkit.types.implementations.Implementation;
import integratedtoolkit.types.resources.ResourceDescription;
import integratedtoolkit.types.resources.WorkerResourceDescription;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.PriorityQueue;

public abstract class SchedulingEvent<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
implements Comparable<SchedulingEvent<P, T, I>> {
    protected long expectedTimeStamp;
    protected AllocatableAction<P, T, I> action;

    public SchedulingEvent(long timeStamp, AllocatableAction<P, T, I> action) {
        this.expectedTimeStamp = timeStamp;
        this.action = action;
    }

    @Override
    public int compareTo(SchedulingEvent<P, T, I> e) {
        int time = Long.compare(this.expectedTimeStamp, e.expectedTimeStamp);
        if (time == 0) {
            return this.getPriority() - e.getPriority();
        }
        return time;
    }

    public AllocatableAction<P, T, I> getAction() {
        return this.action;
    }

    protected abstract int getPriority();

    public abstract LinkedList<SchedulingEvent<P, T, I>> process(LocalOptimizationState<P, T, I> var1, FullGraphResourceScheduler<P, T, I> var2, PriorityQueue<AllocatableAction<P, T, I>> var3, PriorityActionSet<P, T, I> var4, PriorityQueue<AllocatableAction<P, T, I>> var5);

    public void releaseSuccessors(FullGraphSchedulingInformation<P, T, I> dsi, FullGraphResourceScheduler<P, T, I> worker, PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, long timeLimit) {
        LinkedList<AllocatableAction<P, T, I>> successors = dsi.getOptimizingSuccessors();
        for (AllocatableAction allocatableAction : successors) {
            FullGraphSchedulingInformation successorDSI = (FullGraphSchedulingInformation)allocatableAction.getSchedulingInfo();
            int missingParams = 0;
            long startTime = 0L;
            boolean retry = true;
            while (retry) {
                try {
                    LinkedList predecessors = allocatableAction.getDataPredecessors();
                    for (AllocatableAction predecessor : predecessors) {
                        FullGraphSchedulingInformation predDSI = (FullGraphSchedulingInformation)predecessor.getSchedulingInfo();
                        if (predecessor.getAssignedResource() != worker) {
                            startTime = Math.max(startTime, predDSI.getExpectedEnd());
                            continue;
                        }
                        if (predDSI.isOnOptimization()) {
                            ++missingParams;
                            continue;
                        }
                        startTime = Math.max(startTime, predDSI.getExpectedEnd());
                    }
                    retry = false;
                }
                catch (ConcurrentModificationException cme) {
                    missingParams = 0;
                    startTime = 0L;
                }
            }
            successorDSI.setExpectedStart(startTime);
            if (missingParams != 0) continue;
            if (successorDSI.getExpectedStart() <= timeLimit) {
                selectableActions.offer(allocatableAction);
                continue;
            }
            readyActions.add(allocatableAction);
        }
        dsi.clearOptimizingSuccessors();
    }

    public static class End<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
    extends SchedulingEvent<P, T, I> {
        public End(long timeStamp, AllocatableAction<P, T, I> action) {
            super(timeStamp, action);
        }

        @Override
        protected int getPriority() {
            return 0;
        }

        @Override
        public LinkedList<SchedulingEvent<P, T, I>> process(LocalOptimizationState<P, T, I> state, FullGraphResourceScheduler<P, T, I> worker, PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, PriorityQueue<AllocatableAction<P, T, I>> rescheduledActions) {
            AllocatableAction<P, T, I> top;
            FullGraphSchedulingInformation topDSI;
            long start;
            LinkedList<SchedulingEvent<P, T, I>> enabledEvents = new LinkedList<SchedulingEvent<P, T, I>>();
            FullGraphSchedulingInformation dsi = (FullGraphSchedulingInformation)this.action.getSchedulingInfo();
            dsi.setOnOptimization(false);
            while (readyActions.size() > 0 && (start = (topDSI = (FullGraphSchedulingInformation)(top = readyActions.peek()).getSchedulingInfo()).getExpectedStart()) <= this.expectedTimeStamp) {
                readyActions.poll();
                selectableActions.offer(top);
            }
            this.releaseSuccessors(dsi, worker, readyActions, selectableActions, this.expectedTimeStamp);
            AllocatableAction<P, T, I> currentTop = selectableActions.peek();
            if (state.getAction() != currentTop) {
                state.replaceAction(currentTop);
            }
            state.releaseResources(this.expectedTimeStamp, this.action);
            while (state.canActionRun()) {
                selectableActions.removeFirst(currentTop.getCoreId());
                topDSI = (FullGraphSchedulingInformation)currentTop.getSchedulingInfo();
                topDSI.lock();
                topDSI.setToReschedule(false);
                Start<P, T, I> se = new Start<P, T, I>(state.getActionStartTime(), currentTop);
                enabledEvents.addAll(((SchedulingEvent)se).process(state, worker, readyActions, selectableActions, rescheduledActions));
                currentTop = selectableActions.peek();
                state.replaceAction(currentTop);
            }
            return enabledEvents;
        }

        public String toString() {
            return this.action + " end @ " + this.expectedTimeStamp;
        }
    }

    public static class Start<P extends Profile, T extends WorkerResourceDescription, I extends Implementation<T>>
    extends SchedulingEvent<P, T, I> {
        public Start(long timeStamp, AllocatableAction<P, T, I> action) {
            super(timeStamp, action);
        }

        @Override
        protected int getPriority() {
            return 1;
        }

        public String toString() {
            return this.action + " start @ " + this.expectedTimeStamp;
        }

        @Override
        public LinkedList<SchedulingEvent<P, T, I>> process(LocalOptimizationState<P, T, I> state, FullGraphResourceScheduler<P, T, I> worker, PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, PriorityQueue<AllocatableAction<P, T, I>> rescheduledActions) {
            LinkedList<SchedulingEvent<P, T, I>> enabledEvents = new LinkedList<SchedulingEvent<P, T, I>>();
            FullGraphSchedulingInformation dsi = (FullGraphSchedulingInformation)this.action.getSchedulingInfo();
            dsi.setExpectedStart(this.expectedTimeStamp);
            long expectedEndTime = this.getExpectedEnd(this.action, worker, this.expectedTimeStamp);
            dsi.setExpectedEnd(expectedEndTime);
            End endEvent = new End(expectedEndTime, this.action);
            enabledEvents.add(endEvent);
            dsi.clearPredecessors();
            dsi.clearSuccessors();
            LinkedList<Gap<P, T, I>> tmpGaps = state.reserveResources((ResourceDescription)this.action.getAssignedImplementation().getRequirements(), this.expectedTimeStamp);
            for (Gap gap : tmpGaps) {
                AllocatableAction gapAction = gap.getOrigin();
                if (gap.getInitialTime() == gap.getEndTime()) {
                    if (gapAction == null) continue;
                    FullGraphSchedulingInformation gapActionDSI = (FullGraphSchedulingInformation)gapAction.getSchedulingInfo();
                    gapActionDSI.addSuccessor(this.action);
                    dsi.addPredecessor(gapAction);
                    state.removeTmpGap(gap);
                    continue;
                }
                PriorityQueue<Gap<P, T, I>> outGaps = this.fillGap(worker, gap, readyActions, selectableActions, rescheduledActions, state);
                for (Gap<P, T, I> outGap : outGaps) {
                    AllocatableAction<P, T, I> pred = outGap.getOrigin();
                    if (pred != null) {
                        FullGraphSchedulingInformation predDSI = (FullGraphSchedulingInformation)pred.getSchedulingInfo();
                        predDSI.addSuccessor(this.action);
                        dsi.addPredecessor(pred);
                    }
                    state.removeTmpGap(outGap);
                }
            }
            rescheduledActions.offer(this.action);
            return enabledEvents;
        }

        private PriorityQueue<Gap<P, T, I>> fillGap(FullGraphResourceScheduler<P, T, I> worker, Gap<P, T, I> gap, PriorityQueue<AllocatableAction<P, T, I>> readyActions, PriorityActionSet<P, T, I> selectableActions, PriorityQueue<AllocatableAction<P, T, I>> rescheduledActions, LocalOptimizationState<P, T, I> state) {
            PriorityQueue<Gap<P, T, I>> availableGaps = new PriorityQueue<Gap<P, T, I>>(1, new Comparator<Gap<P, T, I>>(){

                @Override
                public int compare(Gap<P, T, I> g1, Gap<P, T, I> g2) {
                    return Long.compare(g1.getInitialTime(), g2.getInitialTime());
                }
            });
            AllocatableAction<P, T, I> gapAction = this.pollActionForGap(gap, worker, selectableActions);
            if (gapAction != null) {
                FullGraphSchedulingInformation gapActionDSI = (FullGraphSchedulingInformation)gapAction.getSchedulingInfo();
                gapActionDSI.setToReschedule(false);
                long gapActionStart = Math.max(gapActionDSI.getExpectedStart(), gap.getInitialTime());
                if (gap.getInitialTime() != gapActionStart) {
                    Gap<P, T, I> previousGap = new Gap<P, T, I>(gap.getInitialTime(), gapActionStart, gap.getOrigin(), gap.getResources(), 0);
                    state.replaceTmpGap(gap, previousGap);
                    availableGaps = this.fillGap(worker, previousGap, readyActions, selectableActions, rescheduledActions, state);
                } else {
                    availableGaps.add(gap);
                }
                gapActionDSI.lock();
                gapActionDSI.setExpectedStart(gapActionStart);
                long expectedEnd = this.getExpectedEnd(gapAction, worker, gapActionStart);
                gapActionDSI.setExpectedEnd(expectedEnd);
                gapActionDSI.clearPredecessors();
                ResourceDescription desc = gapAction.getAssignedImplementation().getRequirements().copy();
                while (!desc.isDynamicUseless()) {
                    Gap<P, T, I> peekGap = availableGaps.peek();
                    AllocatableAction<P, T, I> peekAction = peekGap.getOrigin();
                    if (peekAction != null) {
                        FullGraphSchedulingInformation fullGraphSchedulingInformation = (FullGraphSchedulingInformation)peekAction.getSchedulingInfo();
                        gapActionDSI.addPredecessor(peekAction);
                        fullGraphSchedulingInformation.addSuccessor(gapAction);
                    }
                    ResourceDescription.reduceCommonDynamics((ResourceDescription)desc, (ResourceDescription)peekGap.getResources());
                    if (!peekGap.getResources().isDynamicUseless()) continue;
                    availableGaps.poll();
                    state.removeTmpGap(gap);
                }
                LinkedList extendedGaps = new LinkedList();
                for (Gap gap2 : availableGaps) {
                    Gap extendedGap = new Gap(gap2.getInitialTime(), gap.getEndTime(), gap2.getOrigin(), gap2.getResources(), gap2.getCapacity());
                    state.replaceTmpGap(extendedGap, gap);
                    extendedGaps.add(extendedGap);
                }
                availableGaps.clear();
                for (Gap gap3 : extendedGaps) {
                    availableGaps.addAll(this.fillGap(worker, gap3, readyActions, selectableActions, rescheduledActions, state));
                }
                gapActionDSI.clearSuccessors();
                rescheduledActions.add(gapAction);
                gapActionDSI.setOnOptimization(false);
                this.releaseSuccessors(gapActionDSI, worker, readyActions, selectableActions, expectedEnd);
                Gap<P, T, I> actionGap = new Gap<P, T, I>(expectedEnd, gap.getEndTime(), gapAction, (ResourceDescription)gapAction.getAssignedImplementation().getRequirements(), 0);
                state.addTmpGap(actionGap);
                availableGaps.addAll(this.fillGap(worker, actionGap, readyActions, selectableActions, rescheduledActions, state));
            } else {
                availableGaps.add(gap);
            }
            return availableGaps;
        }

        private long getExpectedEnd(AllocatableAction<P, T, I> action, FullGraphResourceScheduler<P, T, I> worker, long expectedStart) {
            Implementation impl = action.getAssignedImplementation();
            Profile p = worker.getProfile(impl);
            long endTime = expectedStart;
            if (p != null) {
                endTime += p.getAverageExecutionTime();
            }
            if (endTime < 0L) {
                endTime = 0L;
            }
            return endTime;
        }

        private AllocatableAction<P, T, I> pollActionForGap(Gap<P, T, I> gap, FullGraphResourceScheduler<P, T, I> worker, PriorityActionSet<P, T, I> selectableActions) {
            AllocatableAction<P, T, I> gapAction = null;
            PriorityQueue<AllocatableAction<P, T, I>> peeks = selectableActions.peekAll();
            while (!peeks.isEmpty() && gapAction == null) {
                AllocatableAction<P, T, I> candidate = peeks.poll();
                FullGraphSchedulingInformation candidateDSI = (FullGraphSchedulingInformation)candidate.getSchedulingInfo();
                long start = candidateDSI.getExpectedStart();
                if (start > gap.getEndTime()) continue;
                Implementation impl = candidate.getAssignedImplementation();
                Profile p = worker.getProfile(impl);
                long expectedLength = p.getAverageExecutionTime();
                if (gap.getEndTime() - gap.getInitialTime() < expectedLength || start + expectedLength > gap.getEndTime() || !gap.getResources().canHostDynamic(impl)) continue;
                selectableActions.removeFirst(candidate.getCoreId());
                gapAction = candidate;
            }
            return gapAction;
        }
    }
}

