/*
 * Decompiled with CFR 0.152.
 */
package org.gridlab.gat.resources.cpi.loadleveler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gridlab.gat.CommandNotFoundException;
import org.gridlab.gat.GAT;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.GATInvocationException;
import org.gridlab.gat.GATObjectCreationException;
import org.gridlab.gat.URI;
import org.gridlab.gat.engine.util.ProcessBundle;
import org.gridlab.gat.engine.util.StreamForwarder;
import org.gridlab.gat.io.FileInputStream;
import org.gridlab.gat.io.FileOutputStream;
import org.gridlab.gat.monitoring.Metric;
import org.gridlab.gat.monitoring.MetricListener;
import org.gridlab.gat.resources.AbstractJobDescription;
import org.gridlab.gat.resources.Job;
import org.gridlab.gat.resources.JobDescription;
import org.gridlab.gat.resources.SoftwareDescription;
import org.gridlab.gat.resources.WrapperJobDescription;
import org.gridlab.gat.resources.cpi.ResourceBrokerCpi;
import org.gridlab.gat.resources.cpi.Sandbox;
import org.gridlab.gat.resources.cpi.WrapperJobCpi;
import org.gridlab.gat.resources.cpi.loadleveler.LoadLevelerJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadLevelerResourceBrokerAdaptor
extends ResourceBrokerCpi {
    public static String LOADL_PID = null;
    protected static Logger logger = LoggerFactory.getLogger(LoadLevelerResourceBrokerAdaptor.class);

    public static String getDescription() {
        return "The LoadLeveler ResourceBroker Adaptor implements the ResourceBroker using the Java ProcessBuilder facility.";
    }

    public static Map<String, Boolean> getSupportedCapabilities() {
        Map capabilities = ResourceBrokerCpi.getSupportedCapabilities();
        capabilities.put("beginMultiJob", true);
        capabilities.put("endMultiJob", true);
        capabilities.put("submitJob", true);
        return capabilities;
    }

    public static String[] getSupportedSchemes() {
        return new String[]{"loadleveler", "fork", ""};
    }

    public LoadLevelerResourceBrokerAdaptor(GATContext gatContext, URI brokerURI) throws GATObjectCreationException {
        super(gatContext, brokerURI);
        String path = brokerURI.getUnresolvedPath();
        if (path != null && !path.equals("")) {
            throw new GATObjectCreationException("The LoadLevelerResourceBrokerAdaptor does not understand the specified path: " + path);
        }
    }

    public Job submitJob(AbstractJobDescription abstractDescription, MetricListener listener, String metricDefinitionName) throws GATInvocationException {
        StreamForwarder forwarder;
        if (!(abstractDescription instanceof JobDescription)) {
            throw new GATInvocationException("can only handle JobDescriptions: " + abstractDescription.getClass());
        }
        JobDescription description = (JobDescription)abstractDescription;
        SoftwareDescription sd = description.getSoftwareDescription();
        if (sd == null) {
            throw new GATInvocationException("The job description does not contain a software description");
        }
        if (description.getProcessCount() < 1) {
            throw new GATInvocationException("Adaptor cannot handle: process count < 1: " + description.getProcessCount());
        }
        if (description.getResourceCount() != 1) {
            throw new GATInvocationException("Adaptor cannot handle: resource count > 1: " + description.getResourceCount());
        }
        String home = System.getProperty("user.home");
        if (home == null) {
            throw new GATInvocationException("loadleveler broker could not get user home dir");
        }
        Sandbox sandbox = new Sandbox(this.gatContext, description, "localhost", home, true, true, false, false);
        LoadLevelerJob loadlevelerJob = new LoadLevelerJob(this.gatContext, description, sandbox);
        LoadLevelerJob job = null;
        if (description instanceof WrapperJobDescription) {
            WrapperJobCpi tmp = new WrapperJobCpi(this.gatContext, (Job)loadlevelerJob, listener, metricDefinitionName);
            listener = tmp;
            job = tmp;
        } else {
            job = loadlevelerJob;
        }
        if (listener != null && metricDefinitionName != null) {
            Metric metric = loadlevelerJob.getMetricDefinitionByName(metricDefinitionName).createMetric(null);
            loadlevelerJob.addMetricListener(listener, metric);
        }
        loadlevelerJob.setState(Job.JobState.PRE_STAGING);
        loadlevelerJob.waitForTrigger(Job.JobState.PRE_STAGING);
        sandbox.prestage();
        String exe = sandbox.getResolvedExecutable() != null ? sandbox.getResolvedExecutable().getPath() : this.getExecutable(description);
        String[] args = this.getArgumentsArray(description);
        File f = new File(sandbox.getSandboxPath());
        if (!f.exists()) {
            throw new GATInvocationException("Unable to find directory " + f.getAbsolutePath());
        }
        Map env = sd.getEnvironment();
        this.prepareBLaunchEnv(env);
        String host = this.brokerURI.getHost();
        String newExe = this.getLoadLevelerCommand();
        String[] newArgs = this.getLoadLevelerArgs(host, exe, args);
        System.out.println("[AFTER] exe: " + newExe);
        System.out.println("[AFTER] llspawan.stdio args:");
        for (int i = 0; i < newArgs.length; ++i) {
            System.out.print(" " + newArgs[i]);
        }
        System.out.println();
        ProcessBundle bundle = new ProcessBundle(description.getProcessCount(), newExe, newArgs, f, env);
        loadlevelerJob.setSubmissionTime();
        loadlevelerJob.setState(Job.JobState.SCHEDULED);
        try {
            loadlevelerJob.setState(Job.JobState.RUNNING);
            loadlevelerJob.waitForTrigger(Job.JobState.RUNNING);
            loadlevelerJob.setStartTime();
            bundle.startBundle();
            loadlevelerJob.setProcess(bundle);
            if (logger.isDebugEnabled()) {
                logger.debug("Job with PID: " + LOADL_PID + " is executed on host " + host);
            }
        }
        catch (IOException e) {
            throw new CommandNotFoundException("LoadLevelerResourceBrokerAdaptor", (Throwable)e);
        }
        if (!sd.streamingStderrEnabled()) {
            try {
                if (sd.getStderr() != null) {
                    FileOutputStream err = GAT.createFileOutputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStderr());
                    forwarder = new StreamForwarder(bundle.getStderr(), (OutputStream)err, sd.getExecutable() + " [stderr]");
                    loadlevelerJob.setErrorStream(forwarder);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Created stderr forwarder to file " + sd.getStderr());
                    }
                } else {
                    new StreamForwarder(bundle.getStderr(), null, sd.getExecutable() + " [stderr]");
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stderr!", (Throwable)e);
            }
        }
        if (!sd.streamingStdoutEnabled()) {
            try {
                if (sd.getStdout() != null) {
                    FileOutputStream out = GAT.createFileOutputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStdout());
                    forwarder = new StreamForwarder(bundle.getStdout(), (OutputStream)out, sd.getExecutable() + " [stdout]");
                    loadlevelerJob.setOutputStream(forwarder);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Created stdout forwarder to file " + sd.getStdout());
                    }
                } else {
                    new StreamForwarder(bundle.getStdout(), null, sd.getExecutable() + " [stdout]");
                }
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file output stream for stdout!", (Throwable)e);
            }
        }
        if (!sd.streamingStdinEnabled() && sd.getStdin() != null) {
            try {
                FileInputStream in = GAT.createFileInputStream((GATContext)this.gatContext, (org.gridlab.gat.io.File)sd.getStdin());
                bundle.setStdin(sd.getExecutable(), (InputStream)in);
            }
            catch (GATObjectCreationException e) {
                throw new GATInvocationException("Unable to create file input stream for stdin!", (Throwable)e);
            }
        }
        loadlevelerJob.monitorState();
        return job;
    }

    private void prepareBLaunchEnv(Map<String, Object> env) throws GATInvocationException {
        if (env != null) {
            LOADL_PID = (String)env.get("LOADL_PID");
        }
        if (LOADL_PID == null) {
            LOADL_PID = System.getenv("LOADL_PID");
        }
        if (LOADL_PID == null) {
            throw new GATInvocationException("LOADL_PID environment varible not defined");
        }
    }

    private String getLoadLevelerCommand() {
        return "/usr/bin/llspawn.stdio";
    }

    private String[] getLoadLevelerArgs(String host, String exe, String[] args) {
        int i;
        String[] argsTmp = new String[args.length + 2];
        argsTmp[0] = host;
        argsTmp[1] = exe;
        for (i = 0; i < args.length; ++i) {
            argsTmp[2 + i] = args[i];
        }
        System.out.println("llspawan.stdio args: ");
        for (i = 0; i < argsTmp.length; ++i) {
            System.out.print(" " + argsTmp[i]);
        }
        System.out.println();
        return argsTmp;
    }
}

