/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gat.master;

import es.bsc.compss.exceptions.AnnounceException;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.gat.master.GATAdaptor;
import es.bsc.compss.gat.master.GATCopy;
import es.bsc.compss.gat.master.GATJob;
import es.bsc.compss.gat.master.GATTracer;
import es.bsc.compss.gat.master.configuration.GATConfiguration;
import es.bsc.compss.gat.master.utils.GATScriptExecutor;
import es.bsc.compss.gat.master.utils.SSHManager;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.gridlab.gat.GATContext;
import org.gridlab.gat.URI;
import org.gridlab.gat.resources.Job;

public class GATWorkerNode
extends COMPSsWorker {
    private static final String GAT_SCRIPT_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "gat" + File.separator;
    private static final String CLEANER_SCRIPT_NAME = "clean.sh";
    private static final String INIT_SCRIPT_NAME = "init.sh";
    private GATConfiguration config;
    private Job tracingJob;

    public GATWorkerNode(String name, GATConfiguration config) {
        super(name, config);
        this.config = config;
    }

    @Override
    public String getName() {
        return this.config.getHost();
    }

    @Override
    public void start() throws InitNodeException {
        this.initWorkingDir();
        if (GATTracer.isActivated()) {
            LOGGER.debug("Starting GAT tracer " + this.getName());
            this.tracingJob = GATTracer.startTracing(this);
            this.waitForTracingReady();
        }
    }

    private void initWorkingDir() throws InitNodeException {
        LinkedList<URI> traceScripts = new LinkedList<URI>();
        LinkedList<String> traceParams = new LinkedList<String>();
        String host = this.getHost();
        String installDir = this.getInstallDir();
        String workingDir = this.getWorkingDir();
        String user = this.getUser();
        user = user == null || user.isEmpty() ? "" : user + "@";
        try {
            String initScriptPath = DataLocation.Protocol.ANY_URI.getSchema() + user + host + File.separator + installDir + GAT_SCRIPT_PATH + INIT_SCRIPT_NAME;
            traceScripts.add(new URI(initScriptPath));
        }
        catch (URISyntaxException e) {
            new InitNodeException("Error addind initScript");
        }
        String pars = workingDir;
        traceParams.add(pars);
        LOGGER.debug("Initializing working dir " + workingDir + "  in host " + this.getName());
        boolean result = new GATScriptExecutor(this).executeScript(traceScripts, traceParams, "init_" + host);
        if (!result) {
            throw new InitNodeException("Error executing init script for initializing working dir " + workingDir + " in host " + this.getName());
        }
    }

    private void waitForTracingReady() {
        if (!GATTracer.isActivated()) {
            return;
        }
        GATTracer.waitForTracing(this.tracingJob);
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    public String getClasspath() {
        return this.config.getClasspath();
    }

    @Override
    public String getPythonpath() {
        return this.config.getPythonpath();
    }

    public String getHost() {
        return this.config.getHost();
    }

    public String getInstallDir() {
        return this.config.getInstallDir();
    }

    public String getWorkingDir() {
        return this.config.getSandboxWorkingDir();
    }

    public String getAppDir() {
        String appDir = this.config.getAppDir();
        appDir = appDir == null || appDir.isEmpty() ? "null" : appDir;
        return appDir;
    }

    public String getLibPath() {
        String libPath = this.config.getLibraryPath();
        libPath = libPath == null || libPath.isEmpty() ? "null" : libPath;
        return libPath;
    }

    public int getTotalComputingUnits() {
        return this.config.getTotalComputingUnits();
    }

    public GATContext getContext() {
        return this.config.getContext();
    }

    public boolean isUsingGlobus() {
        return this.config.isUsingGlobus();
    }

    public boolean isUserNeeded() {
        return this.config.isUserNeeded();
    }

    @Override
    public es.bsc.compss.types.job.Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        return new GATJob(taskId, taskParams, impl, res, listener, this.config.getContext(), this.config.isUserNeeded(), this.config.isUsingGlobus(), slaveWorkersNodeNames);
    }

    @Override
    public void setInternalURI(MultiURI uri) {
        String scheme = uri.getScheme();
        String user = this.config.getUser().isEmpty() ? "" : this.config.getUser() + "@";
        String host = this.config.getHost();
        String filePath = uri.getPath();
        String s = scheme + user + host + File.separator + filePath;
        try {
            URI gat = new URI(s);
            uri.setInternalURI(GATAdaptor.ID, gat);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error creating new URI", (Throwable)e);
        }
    }

    @Override
    public void stop(ShutdownListener sl) {
        try {
            File workingDirRoot;
            File[] filesInFolder;
            String workingDir = this.config.getWorkingDir();
            if (workingDir != null && !workingDir.isEmpty() && (filesInFolder = (workingDirRoot = new File(workingDir)).listFiles()) != null) {
                for (File c : filesInFolder) {
                    this.delete(c);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not remove clean node working dir\n" + e);
        }
        sl.notifyEnd();
    }

    private void delete(File f) throws FileNotFoundException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    @Override
    public void sendData(LogicalData srcData, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        GATCopy c = new GATCopy(srcData, source, target, tgtData, reason, listener);
        GATAdaptor.enqueueCopy(c);
    }

    @Override
    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        GATCopy c = new GATCopy(ld, source, target, tgtData, reason, listener);
        GATAdaptor.enqueueCopy(c);
    }

    @Override
    public void updateTaskCount(int processorCoreCount) {
        if (GATTracer.isActivated()) {
            LOGGER.error("Tracing system and Cloud do not work together");
        }
    }

    @Override
    public void announceCreation() throws AnnounceException {
        try {
            SSHManager.registerWorker(this);
            SSHManager.announceCreation(this);
        }
        catch (IOException ioe) {
            throw new AnnounceException(ioe);
        }
    }

    @Override
    public void announceDestruction() throws AnnounceException {
        try {
            SSHManager.removeKey(this);
            SSHManager.announceDestruction(this);
            SSHManager.removeWorker(this);
        }
        catch (IOException ioe) {
            throw new AnnounceException(ioe);
        }
    }

    @Override
    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case FILE_T: 
            case OBJECT_T: 
            case PSCO_T: 
            case EXTERNAL_OBJECT_T: {
                path = DataLocation.Protocol.FILE_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    @Override
    public void deleteTemporary() {
        LinkedList<URI> traceScripts = new LinkedList<URI>();
        LinkedList<String> traceParams = new LinkedList<String>();
        String host = this.getHost();
        String installDir = this.getInstallDir();
        String workingDir = this.getWorkingDir();
        String user = this.getUser();
        user = user == null ? "" : user + "@";
        try {
            traceScripts.add(new URI(DataLocation.Protocol.ANY_URI.getSchema() + user + host + File.separator + installDir + GAT_SCRIPT_PATH + CLEANER_SCRIPT_NAME));
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error deleting working dir " + workingDir + " in host " + this.getName(), (Throwable)e);
            return;
        }
        String pars = workingDir;
        traceParams.add(pars);
        LOGGER.debug("Deleting working dir " + workingDir + "  in host " + this.getName());
        boolean result = new GATScriptExecutor(this).executeScript(traceScripts, traceParams, "clean_" + host);
        if (!result) {
            LOGGER.error("Error executing clean script for deleting working dir " + workingDir + " in host " + this.getName());
        }
    }

    @Override
    public boolean generatePackage() {
        LOGGER.debug("Generating GAT tracing package");
        GATTracer.generatePackage(this);
        return true;
    }

    @Override
    public boolean generateWorkersDebugInfo() {
        LOGGER.info("Worker debug files not supported on GAT Adaptor");
        return false;
    }

    @Override
    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        sl.notifyEnd();
    }
}

